# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_image_build200_response_all_of_image_build import AddImageBuild200ResponseAllOfImageBuild
from typing import Optional, Set
from typing_extensions import Self

class AddImageBuild200Response(BaseModel):
    """
    AddImageBuild200Response
    """ # noqa: E501
    image_build: Optional[AddImageBuild200ResponseAllOfImageBuild] = Field(default=None, alias="imageBuild")
    error_code: Optional[StrictStr] = Field(default=None, alias="errorCode")
    success: Optional[StrictBool] = Field(default=True, description="Success indicator, true when the request succeeded and false when an error occurred")
    msg: Optional[StrictStr] = Field(default=None, description="Message containing a description of the result, usually a message about the error that occurred")
    errors: Optional[Dict[str, Any]] = Field(default=None, description="Validation errors, with a key for Object containing error messages for each invalid parameter (key)")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["imageBuild", "errorCode", "success", "msg", "errors"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddImageBuild200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of image_build
        if self.image_build:
            _dict['imageBuild'] = self.image_build.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if error_code (nullable) is None
        # and model_fields_set contains the field
        if self.error_code is None and "error_code" in self.model_fields_set:
            _dict['errorCode'] = None

        # set to None if msg (nullable) is None
        # and model_fields_set contains the field
        if self.msg is None and "msg" in self.model_fields_set:
            _dict['msg'] = None

        # set to None if errors (nullable) is None
        # and model_fields_set contains the field
        if self.errors is None and "errors" in self.model_fields_set:
            _dict['errors'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddImageBuild200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "imageBuild": AddImageBuild200ResponseAllOfImageBuild.from_dict(obj["imageBuild"]) if obj.get("imageBuild") is not None else None,
            "errorCode": obj.get("errorCode"),
            "success": obj.get("success") if obj.get("success") is not None else True,
            "msg": obj.get("msg"),
            "errors": obj.get("errors")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


