# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AddIntegrationsRequestOneOf1IntegrationConfig(BaseModel):
    """
    AddIntegrationsRequestOneOf1IntegrationConfig
    """ # noqa: E501
    default_branch: Optional[StrictStr] = Field(default=None, description="default branch", alias="defaultBranch")
    ansible_playbooks: Optional[StrictStr] = Field(default=None, description="Playbooks path", alias="ansiblePlaybooks")
    ansible_roles: Optional[StrictStr] = Field(default=None, description="Roles path", alias="ansibleRoles")
    ansible_group_vars: Optional[StrictStr] = Field(default=None, description="Group variables path", alias="ansibleGroupVars")
    ansible_host_vars: Optional[StrictStr] = Field(default=None, description="Host variables path", alias="ansibleHostVars")
    ansible_galaxy_enabled: Optional[StrictBool] = Field(default=None, description="Use Ansible Galaxy", alias="ansibleGalaxyEnabled")
    ansible_verbose: Optional[StrictBool] = Field(default=None, description="Use verbose logging", alias="ansibleVerbose")
    ansible_command_bus: Optional[StrictBool] = Field(default=None, description="Use Morpheus Agent Command Bus", alias="ansibleCommandBus")
    cache_enabled: Optional[StrictBool] = Field(default=None, description="Enable Git repository caching", alias="cacheEnabled")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["defaultBranch", "ansiblePlaybooks", "ansibleRoles", "ansibleGroupVars", "ansibleHostVars", "ansibleGalaxyEnabled", "ansibleVerbose", "ansibleCommandBus", "cacheEnabled"]

    @field_validator('default_branch')
    def default_branch_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['main', 'master']):
            raise ValueError("must be one of enum values ('main', 'master')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddIntegrationsRequestOneOf1IntegrationConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddIntegrationsRequestOneOf1IntegrationConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "defaultBranch": obj.get("defaultBranch"),
            "ansiblePlaybooks": obj.get("ansiblePlaybooks"),
            "ansibleRoles": obj.get("ansibleRoles"),
            "ansibleGroupVars": obj.get("ansibleGroupVars"),
            "ansibleHostVars": obj.get("ansibleHostVars"),
            "ansibleGalaxyEnabled": obj.get("ansibleGalaxyEnabled"),
            "ansibleVerbose": obj.get("ansibleVerbose"),
            "ansibleCommandBus": obj.get("ansibleCommandBus"),
            "cacheEnabled": obj.get("cacheEnabled")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


