# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.message_of_the_day_policy_type_configuration_motd import MessageOfTheDayPolicyTypeConfigurationMotd
from typing import Optional, Set
from typing_extensions import Self

class AddPoliciesGroupRequestPolicyPolicyTypeConfigOneOf20(BaseModel):
    """
    - Message of the Day 
    """ # noqa: E501
    motd_title: Optional[StrictStr] = Field(default=None, alias="motd.title")
    motd: Optional[MessageOfTheDayPolicyTypeConfigurationMotd] = None
    motd_message: Optional[StrictStr] = Field(default=None, alias="motd.message")
    motd_type: Optional[StrictStr] = Field(default=None, alias="motd.type")
    motd__full_page: Optional[StrictBool] = Field(default=None, alias="motd._fullPage")
    motd_date: Optional[datetime] = Field(default=None, alias="motd.date")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["motd.title", "motd", "motd.message", "motd.type", "motd._fullPage", "motd.date"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddPoliciesGroupRequestPolicyPolicyTypeConfigOneOf20 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of motd
        if self.motd:
            _dict['motd'] = self.motd.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if motd__full_page (nullable) is None
        # and model_fields_set contains the field
        if self.motd__full_page is None and "motd__full_page" in self.model_fields_set:
            _dict['motd._fullPage'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddPoliciesGroupRequestPolicyPolicyTypeConfigOneOf20 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "motd.title": obj.get("motd.title"),
            "motd": MessageOfTheDayPolicyTypeConfigurationMotd.from_dict(obj["motd"]) if obj.get("motd") is not None else None,
            "motd.message": obj.get("motd.message"),
            "motd.type": obj.get("motd.type"),
            "motd._fullPage": obj.get("motd._fullPage"),
            "motd.date": obj.get("motd.date")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


