# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_roles_request_role_app_template_permissions_inner import AddRolesRequestRoleAppTemplatePermissionsInner
from morpheus.models.add_roles_request_role_catalog_item_type_permissions_inner import AddRolesRequestRoleCatalogItemTypePermissionsInner
from morpheus.models.add_roles_request_role_feature_permissions_inner import AddRolesRequestRoleFeaturePermissionsInner
from morpheus.models.add_roles_request_role_instance_type_permissions_inner import AddRolesRequestRoleInstanceTypePermissionsInner
from morpheus.models.add_roles_request_role_persona_permissions_inner import AddRolesRequestRolePersonaPermissionsInner
from morpheus.models.add_roles_request_role_report_type_permissions_inner import AddRolesRequestRoleReportTypePermissionsInner
from morpheus.models.add_roles_request_role_sites_inner import AddRolesRequestRoleSitesInner
from morpheus.models.add_roles_request_role_task_permissions_inner import AddRolesRequestRoleTaskPermissionsInner
from morpheus.models.add_roles_request_role_task_set_permissions_inner import AddRolesRequestRoleTaskSetPermissionsInner
from morpheus.models.add_roles_request_role_vdi_pool_permissions_inner import AddRolesRequestRoleVdiPoolPermissionsInner
from morpheus.models.add_roles_request_role_zones_inner import AddRolesRequestRoleZonesInner
from typing import Optional, Set
from typing_extensions import Self

class AddRolesRequestRole(BaseModel):
    """
    Payload for creating a new role
    """ # noqa: E501
    authority: StrictStr = Field(description="Authority (Name)")
    description: Optional[StrictStr] = Field(default=None, description="Description")
    landing_url: Optional[StrictStr] = Field(default=None, description="An optional override for the default landing page after login for a user.", alias="landingUrl")
    role_type: Optional[StrictStr] = Field(default='user', description="Role type", alias="roleType")
    base_role_id: Optional[StrictInt] = Field(default=None, description="Base Role ID. Create the new role with the same permissions and access levels that the specified base role has. If this is not passed, the role is create without any permissions.", alias="baseRoleId")
    multitenant: Optional[StrictBool] = Field(default=False, description="Multitenant roles are copied to all tenant accounts and kept in sync until a sub-tenant user modifies their copy of the role. *Only available to master tenant*")
    multitenant_locked: Optional[StrictBool] = Field(default=False, description="Multitenant Locked, prevents sub-tenant users from modifying their copy of multienant roles. *Only available to master tenant*", alias="multitenantLocked")
    default_persona: Optional[StrictStr] = Field(default=None, alias="defaultPersona")
    feature_permissions: Optional[List[AddRolesRequestRoleFeaturePermissionsInner]] = Field(default=None, description="Set the access level for the specified permissions.", alias="featurePermissions")
    global_site_access: Optional[StrictStr] = Field(default=None, description="Set the default access level for for groups (sites). Only applies to user roles.", alias="globalSiteAccess")
    sites: Optional[List[AddRolesRequestRoleSitesInner]] = Field(default=None, description="Set the access level for the specified groups (sites). Only applies to user roles.")
    global_zone_access: Optional[StrictStr] = Field(default=None, description="Set the default access level for for clouds (zones). Only applies to base account (tenant) roles.", alias="globalZoneAccess")
    zones: Optional[List[AddRolesRequestRoleZonesInner]] = Field(default=None, description="Set the access level for the specified clouds (zones). Only applies to base account (tenant) roles.")
    global_instance_type_access: Optional[StrictStr] = Field(default=None, description="Set the default access level for for instance types", alias="globalInstanceTypeAccess")
    instance_type_permissions: Optional[List[AddRolesRequestRoleInstanceTypePermissionsInner]] = Field(default=None, description="Set the access level for the specified instance types", alias="instanceTypePermissions")
    global_app_template_access: Optional[StrictStr] = Field(default=None, description="Set the default access level for blueprints", alias="globalAppTemplateAccess")
    app_template_permissions: Optional[List[AddRolesRequestRoleAppTemplatePermissionsInner]] = Field(default=None, description="Set the access level for the specified blueprints (appTemplates)", alias="appTemplatePermissions")
    global_catalog_item_type_access: Optional[StrictStr] = Field(default=None, description="Set the default access level for catalog item types", alias="globalCatalogItemTypeAccess")
    catalog_item_type_permissions: Optional[List[AddRolesRequestRoleCatalogItemTypePermissionsInner]] = Field(default=None, description="Set the access level for the specified catalog item types", alias="catalogItemTypePermissions")
    global_persona_access: Optional[StrictStr] = Field(default=None, description="Set the default access level for personas", alias="globalPersonaAccess")
    persona_permissions: Optional[List[AddRolesRequestRolePersonaPermissionsInner]] = Field(default=None, description="Set the access level for the specified personas", alias="personaPermissions")
    global_vdi_pool_access: Optional[StrictStr] = Field(default=None, description="Set the default access level for VDI pools", alias="globalVdiPoolAccess")
    vdi_pool_permissions: Optional[List[AddRolesRequestRoleVdiPoolPermissionsInner]] = Field(default=None, description="Set the access level for the specified VDI pools", alias="vdiPoolPermissions")
    global_report_type_access: Optional[StrictStr] = Field(default=None, description="Set the default access level for report types", alias="globalReportTypeAccess")
    report_type_permissions: Optional[List[AddRolesRequestRoleReportTypePermissionsInner]] = Field(default=None, description="Set the access level for the specified report types", alias="reportTypePermissions")
    global_task_access: Optional[StrictStr] = Field(default=None, description="Set the default access level for tasks", alias="globalTaskAccess")
    task_permissions: Optional[List[AddRolesRequestRoleTaskPermissionsInner]] = Field(default=None, description="Set the access level for the specified tasks", alias="taskPermissions")
    global_task_set_access: Optional[StrictStr] = Field(default=None, description="Set the default access level for workflows (taskSets)", alias="globalTaskSetAccess")
    task_set_permissions: Optional[List[AddRolesRequestRoleTaskSetPermissionsInner]] = Field(default=None, description="Set the access level for the specified workflows (taskSets)", alias="taskSetPermissions")
    owner: Optional[StrictInt] = Field(default=None, description="Set the role owner (tenant) by ID. *Only available to master tenant*")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["authority", "description", "landingUrl", "roleType", "baseRoleId", "multitenant", "multitenantLocked", "defaultPersona", "featurePermissions", "globalSiteAccess", "sites", "globalZoneAccess", "zones", "globalInstanceTypeAccess", "instanceTypePermissions", "globalAppTemplateAccess", "appTemplatePermissions", "globalCatalogItemTypeAccess", "catalogItemTypePermissions", "globalPersonaAccess", "personaPermissions", "globalVdiPoolAccess", "vdiPoolPermissions", "globalReportTypeAccess", "reportTypePermissions", "globalTaskAccess", "taskPermissions", "globalTaskSetAccess", "taskSetPermissions", "owner"]

    @field_validator('role_type')
    def role_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['user', 'account']):
            raise ValueError("must be one of enum values ('user', 'account')")
        return value

    @field_validator('default_persona')
    def default_persona_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['standard', 'serviceCatalog', 'vdi']):
            raise ValueError("must be one of enum values ('standard', 'serviceCatalog', 'vdi')")
        return value

    @field_validator('global_site_access')
    def global_site_access_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['default', 'full', 'read', 'none']):
            raise ValueError("must be one of enum values ('default', 'full', 'read', 'none')")
        return value

    @field_validator('global_zone_access')
    def global_zone_access_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['default', 'full', 'read', 'none']):
            raise ValueError("must be one of enum values ('default', 'full', 'read', 'none')")
        return value

    @field_validator('global_instance_type_access')
    def global_instance_type_access_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['full', 'none']):
            raise ValueError("must be one of enum values ('full', 'none')")
        return value

    @field_validator('global_app_template_access')
    def global_app_template_access_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['full', 'none']):
            raise ValueError("must be one of enum values ('full', 'none')")
        return value

    @field_validator('global_catalog_item_type_access')
    def global_catalog_item_type_access_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['full', 'none']):
            raise ValueError("must be one of enum values ('full', 'none')")
        return value

    @field_validator('global_persona_access')
    def global_persona_access_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['full', 'none']):
            raise ValueError("must be one of enum values ('full', 'none')")
        return value

    @field_validator('global_vdi_pool_access')
    def global_vdi_pool_access_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['full', 'none']):
            raise ValueError("must be one of enum values ('full', 'none')")
        return value

    @field_validator('global_report_type_access')
    def global_report_type_access_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['full', 'none']):
            raise ValueError("must be one of enum values ('full', 'none')")
        return value

    @field_validator('global_task_access')
    def global_task_access_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['full', 'none']):
            raise ValueError("must be one of enum values ('full', 'none')")
        return value

    @field_validator('global_task_set_access')
    def global_task_set_access_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['full', 'none']):
            raise ValueError("must be one of enum values ('full', 'none')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddRolesRequestRole from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in feature_permissions (list)
        _items = []
        if self.feature_permissions:
            for _item_feature_permissions in self.feature_permissions:
                if _item_feature_permissions:
                    _items.append(_item_feature_permissions.to_dict())
            _dict['featurePermissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in sites (list)
        _items = []
        if self.sites:
            for _item_sites in self.sites:
                if _item_sites:
                    _items.append(_item_sites.to_dict())
            _dict['sites'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in zones (list)
        _items = []
        if self.zones:
            for _item_zones in self.zones:
                if _item_zones:
                    _items.append(_item_zones.to_dict())
            _dict['zones'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in instance_type_permissions (list)
        _items = []
        if self.instance_type_permissions:
            for _item_instance_type_permissions in self.instance_type_permissions:
                if _item_instance_type_permissions:
                    _items.append(_item_instance_type_permissions.to_dict())
            _dict['instanceTypePermissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in app_template_permissions (list)
        _items = []
        if self.app_template_permissions:
            for _item_app_template_permissions in self.app_template_permissions:
                if _item_app_template_permissions:
                    _items.append(_item_app_template_permissions.to_dict())
            _dict['appTemplatePermissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in catalog_item_type_permissions (list)
        _items = []
        if self.catalog_item_type_permissions:
            for _item_catalog_item_type_permissions in self.catalog_item_type_permissions:
                if _item_catalog_item_type_permissions:
                    _items.append(_item_catalog_item_type_permissions.to_dict())
            _dict['catalogItemTypePermissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in persona_permissions (list)
        _items = []
        if self.persona_permissions:
            for _item_persona_permissions in self.persona_permissions:
                if _item_persona_permissions:
                    _items.append(_item_persona_permissions.to_dict())
            _dict['personaPermissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in vdi_pool_permissions (list)
        _items = []
        if self.vdi_pool_permissions:
            for _item_vdi_pool_permissions in self.vdi_pool_permissions:
                if _item_vdi_pool_permissions:
                    _items.append(_item_vdi_pool_permissions.to_dict())
            _dict['vdiPoolPermissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in report_type_permissions (list)
        _items = []
        if self.report_type_permissions:
            for _item_report_type_permissions in self.report_type_permissions:
                if _item_report_type_permissions:
                    _items.append(_item_report_type_permissions.to_dict())
            _dict['reportTypePermissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in task_permissions (list)
        _items = []
        if self.task_permissions:
            for _item_task_permissions in self.task_permissions:
                if _item_task_permissions:
                    _items.append(_item_task_permissions.to_dict())
            _dict['taskPermissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in task_set_permissions (list)
        _items = []
        if self.task_set_permissions:
            for _item_task_set_permissions in self.task_set_permissions:
                if _item_task_set_permissions:
                    _items.append(_item_task_set_permissions.to_dict())
            _dict['taskSetPermissions'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if landing_url (nullable) is None
        # and model_fields_set contains the field
        if self.landing_url is None and "landing_url" in self.model_fields_set:
            _dict['landingUrl'] = None

        # set to None if default_persona (nullable) is None
        # and model_fields_set contains the field
        if self.default_persona is None and "default_persona" in self.model_fields_set:
            _dict['defaultPersona'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddRolesRequestRole from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "authority": obj.get("authority"),
            "description": obj.get("description"),
            "landingUrl": obj.get("landingUrl"),
            "roleType": obj.get("roleType") if obj.get("roleType") is not None else 'user',
            "baseRoleId": obj.get("baseRoleId"),
            "multitenant": obj.get("multitenant") if obj.get("multitenant") is not None else False,
            "multitenantLocked": obj.get("multitenantLocked") if obj.get("multitenantLocked") is not None else False,
            "defaultPersona": obj.get("defaultPersona"),
            "featurePermissions": [AddRolesRequestRoleFeaturePermissionsInner.from_dict(_item) for _item in obj["featurePermissions"]] if obj.get("featurePermissions") is not None else None,
            "globalSiteAccess": obj.get("globalSiteAccess"),
            "sites": [AddRolesRequestRoleSitesInner.from_dict(_item) for _item in obj["sites"]] if obj.get("sites") is not None else None,
            "globalZoneAccess": obj.get("globalZoneAccess"),
            "zones": [AddRolesRequestRoleZonesInner.from_dict(_item) for _item in obj["zones"]] if obj.get("zones") is not None else None,
            "globalInstanceTypeAccess": obj.get("globalInstanceTypeAccess"),
            "instanceTypePermissions": [AddRolesRequestRoleInstanceTypePermissionsInner.from_dict(_item) for _item in obj["instanceTypePermissions"]] if obj.get("instanceTypePermissions") is not None else None,
            "globalAppTemplateAccess": obj.get("globalAppTemplateAccess"),
            "appTemplatePermissions": [AddRolesRequestRoleAppTemplatePermissionsInner.from_dict(_item) for _item in obj["appTemplatePermissions"]] if obj.get("appTemplatePermissions") is not None else None,
            "globalCatalogItemTypeAccess": obj.get("globalCatalogItemTypeAccess"),
            "catalogItemTypePermissions": [AddRolesRequestRoleCatalogItemTypePermissionsInner.from_dict(_item) for _item in obj["catalogItemTypePermissions"]] if obj.get("catalogItemTypePermissions") is not None else None,
            "globalPersonaAccess": obj.get("globalPersonaAccess"),
            "personaPermissions": [AddRolesRequestRolePersonaPermissionsInner.from_dict(_item) for _item in obj["personaPermissions"]] if obj.get("personaPermissions") is not None else None,
            "globalVdiPoolAccess": obj.get("globalVdiPoolAccess"),
            "vdiPoolPermissions": [AddRolesRequestRoleVdiPoolPermissionsInner.from_dict(_item) for _item in obj["vdiPoolPermissions"]] if obj.get("vdiPoolPermissions") is not None else None,
            "globalReportTypeAccess": obj.get("globalReportTypeAccess"),
            "reportTypePermissions": [AddRolesRequestRoleReportTypePermissionsInner.from_dict(_item) for _item in obj["reportTypePermissions"]] if obj.get("reportTypePermissions") is not None else None,
            "globalTaskAccess": obj.get("globalTaskAccess"),
            "taskPermissions": [AddRolesRequestRoleTaskPermissionsInner.from_dict(_item) for _item in obj["taskPermissions"]] if obj.get("taskPermissions") is not None else None,
            "globalTaskSetAccess": obj.get("globalTaskSetAccess"),
            "taskSetPermissions": [AddRolesRequestRoleTaskSetPermissionsInner.from_dict(_item) for _item in obj["taskSetPermissions"]] if obj.get("taskSetPermissions") is not None else None,
            "owner": obj.get("owner")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


