# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from typing import Optional, Set
from typing_extensions import Self

class AddStorageServersRequestStorageServer(BaseModel):
    """
    AddStorageServersRequestStorageServer
    """ # noqa: E501
    name: StrictStr = Field(description="Name")
    type: StrictStr = Field(description="The `Storage Type` Code or ID")
    description: Optional[StrictStr] = Field(default=None, description="description")
    enabled: Optional[StrictBool] = Field(default=True, description="The enabled flag")
    config: Dict[str, Any] = Field(description="Configuration object with parameters that vary by `type`")
    visibility: Optional[StrictStr] = Field(default='private', description="private or public")
    tenants: Optional[List[GetAlerts200ResponseAllOfChecksInnerAccount]] = Field(default=None, description="Array of tenant account ids that are allowed access")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "type", "description", "enabled", "config", "visibility", "tenants"]

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['private', 'public']):
            raise ValueError("must be one of enum values ('private', 'public')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddStorageServersRequestStorageServer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tenants (list)
        _items = []
        if self.tenants:
            for _item_tenants in self.tenants:
                if _item_tenants:
                    _items.append(_item_tenants.to_dict())
            _dict['tenants'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddStorageServersRequestStorageServer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "type": obj.get("type"),
            "description": obj.get("description"),
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "config": obj.get("config"),
            "visibility": obj.get("visibility") if obj.get("visibility") is not None else 'private',
            "tenants": [GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(_item) for _item in obj["tenants"]] if obj.get("tenants") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


