# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_virtual_image_request_virtual_image_config import AddVirtualImageRequestVirtualImageConfig
from morpheus.models.add_virtual_image_request_virtual_image_os_type import AddVirtualImageRequestVirtualImageOsType
from morpheus.models.add_virtual_image_request_virtual_image_storage_provider import AddVirtualImageRequestVirtualImageStorageProvider
from morpheus.models.add_virtual_image_request_virtual_image_tags_inner import AddVirtualImageRequestVirtualImageTagsInner
from typing import Optional, Set
from typing_extensions import Self

class AddVirtualImageRequestVirtualImage(BaseModel):
    """
    AddVirtualImageRequestVirtualImage
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="A name for the virtual image")
    labels: Optional[List[StrictStr]] = Field(default=None, description="Array of label strings, can be used for filtering.")
    image_type: Optional[StrictStr] = Field(default=None, description="Code of image type. eg. vmware, ami, etc.", alias="imageType")
    storage_provider: Optional[AddVirtualImageRequestVirtualImageStorageProvider] = Field(default=None, alias="storageProvider")
    is_cloud_init: Optional[StrictBool] = Field(default=False, description="Cloud Init Enabled?", alias="isCloudInit")
    user_data: Optional[StrictStr] = Field(default=None, description="Cloud-Init User Data, a bash script", alias="userData")
    install_agent: Optional[StrictBool] = Field(default=False, description="Install Agent?", alias="installAgent")
    ssh_username: Optional[StrictStr] = Field(default=None, description="SSH Username", alias="sshUsername")
    ssh_password: Optional[StrictStr] = Field(default=None, description="SSH Password", alias="sshPassword")
    ssh_key: Optional[StrictStr] = Field(default=None, description="SSH Key", alias="sshKey")
    os_type: Optional[AddVirtualImageRequestVirtualImageOsType] = Field(default=None, alias="osType")
    visibility: Optional[StrictStr] = Field(default='private', description="private or public")
    accounts: Optional[List[StrictInt]] = None
    is_auto_join_domain: Optional[StrictBool] = Field(default=False, description="Auto Join Domain?", alias="isAutoJoinDomain")
    virtio_supported: Optional[StrictBool] = Field(default=True, description="VirtIO Drivers Loaded?", alias="virtioSupported")
    vm_tools_installed: Optional[StrictBool] = Field(default=True, description="VM Tools Installed?", alias="vmToolsInstalled")
    is_force_customization: Optional[StrictBool] = Field(default=False, description="Force Guest Customization?", alias="isForceCustomization")
    trial_version: Optional[StrictBool] = Field(default=False, description="Trial Version", alias="trialVersion")
    is_sysprep: Optional[StrictBool] = Field(default=False, description="Sysprep Enabled?", alias="isSysprep")
    config: Optional[AddVirtualImageRequestVirtualImageConfig] = None
    tags: Optional[List[AddVirtualImageRequestVirtualImageTagsInner]] = Field(default=None, description="Metadata tags, Array of objects having a name and value")
    url: Optional[StrictStr] = Field(default=None, description="Image File URL, a virtual image file will be created by fetching the specified URL")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "labels", "imageType", "storageProvider", "isCloudInit", "userData", "installAgent", "sshUsername", "sshPassword", "sshKey", "osType", "visibility", "accounts", "isAutoJoinDomain", "virtioSupported", "vmToolsInstalled", "isForceCustomization", "trialVersion", "isSysprep", "config", "tags", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddVirtualImageRequestVirtualImage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of storage_provider
        if self.storage_provider:
            _dict['storageProvider'] = self.storage_provider.to_dict()
        # override the default output from pydantic by calling `to_dict()` of os_type
        if self.os_type:
            _dict['osType'] = self.os_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        # set to None if user_data (nullable) is None
        # and model_fields_set contains the field
        if self.user_data is None and "user_data" in self.model_fields_set:
            _dict['userData'] = None

        # set to None if ssh_username (nullable) is None
        # and model_fields_set contains the field
        if self.ssh_username is None and "ssh_username" in self.model_fields_set:
            _dict['sshUsername'] = None

        # set to None if ssh_password (nullable) is None
        # and model_fields_set contains the field
        if self.ssh_password is None and "ssh_password" in self.model_fields_set:
            _dict['sshPassword'] = None

        # set to None if ssh_key (nullable) is None
        # and model_fields_set contains the field
        if self.ssh_key is None and "ssh_key" in self.model_fields_set:
            _dict['sshKey'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddVirtualImageRequestVirtualImage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "labels": obj.get("labels"),
            "imageType": obj.get("imageType"),
            "storageProvider": AddVirtualImageRequestVirtualImageStorageProvider.from_dict(obj["storageProvider"]) if obj.get("storageProvider") is not None else None,
            "isCloudInit": obj.get("isCloudInit") if obj.get("isCloudInit") is not None else False,
            "userData": obj.get("userData"),
            "installAgent": obj.get("installAgent") if obj.get("installAgent") is not None else False,
            "sshUsername": obj.get("sshUsername"),
            "sshPassword": obj.get("sshPassword"),
            "sshKey": obj.get("sshKey"),
            "osType": AddVirtualImageRequestVirtualImageOsType.from_dict(obj["osType"]) if obj.get("osType") is not None else None,
            "visibility": obj.get("visibility") if obj.get("visibility") is not None else 'private',
            "accounts": obj.get("accounts"),
            "isAutoJoinDomain": obj.get("isAutoJoinDomain") if obj.get("isAutoJoinDomain") is not None else False,
            "virtioSupported": obj.get("virtioSupported") if obj.get("virtioSupported") is not None else True,
            "vmToolsInstalled": obj.get("vmToolsInstalled") if obj.get("vmToolsInstalled") is not None else True,
            "isForceCustomization": obj.get("isForceCustomization") if obj.get("isForceCustomization") is not None else False,
            "trialVersion": obj.get("trialVersion") if obj.get("trialVersion") is not None else False,
            "isSysprep": obj.get("isSysprep") if obj.get("isSysprep") is not None else False,
            "config": AddVirtualImageRequestVirtualImageConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "tags": [AddVirtualImageRequestVirtualImageTagsInner.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "url": obj.get("url")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


