# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AzureInstanceConfiguration(BaseModel):
    """
    AzureInstanceConfiguration
    """ # noqa: E501
    resource_pool_id: Optional[StrictStr] = Field(default=None, description="id of the resource group to be used, can be prefixed with `pool-`. A resource pool group can be specified instead by prefixing its ID with `poolGroup-`.", alias="resourcePoolId")
    availability_options: Optional[StrictStr] = Field(default=None, description="Availability Options", alias="availabilityOptions")
    availability_set: Optional[StrictStr] = Field(default=None, description="Availability Set", alias="availabilitySet")
    availability_zone: Optional[StrictInt] = Field(default=None, description="Availability Zone", alias="availabilityZone")
    azurefloating_ip: Optional[StrictStr] = Field(default=None, description="Assign Public IP", alias="azurefloatingIp")
    boot_diagnostics: Optional[StrictStr] = Field(default=None, description="Boot Diagnostics", alias="bootDiagnostics")
    os_guest_diagnostics: Optional[StrictStr] = Field(default=None, description="OS Guest Diagnostics", alias="osGuestDiagnostics")
    diagnostics_storage_account: Optional[StrictStr] = Field(default=None, description="Diagnostics Storage Account", alias="diagnosticsStorageAccount")
    create_user: Optional[StrictBool] = Field(default=True, description="Create User", alias="createUser")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["resourcePoolId", "availabilityOptions", "availabilitySet", "availabilityZone", "azurefloatingIp", "bootDiagnostics", "osGuestDiagnostics", "diagnosticsStorageAccount", "createUser"]

    @field_validator('availability_options')
    def availability_options_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['zone', 'set']):
            raise ValueError("must be one of enum values ('zone', 'set')")
        return value

    @field_validator('azurefloating_ip')
    def azurefloating_ip_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['on', 'off']):
            raise ValueError("must be one of enum values ('on', 'off')")
        return value

    @field_validator('boot_diagnostics')
    def boot_diagnostics_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enable', 'enable_custom_storage']):
            raise ValueError("must be one of enum values ('enable', 'enable_custom_storage')")
        return value

    @field_validator('os_guest_diagnostics')
    def os_guest_diagnostics_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['on', 'off']):
            raise ValueError("must be one of enum values ('on', 'off')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AzureInstanceConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AzureInstanceConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "resourcePoolId": obj.get("resourcePoolId"),
            "availabilityOptions": obj.get("availabilityOptions"),
            "availabilitySet": obj.get("availabilitySet"),
            "availabilityZone": obj.get("availabilityZone"),
            "azurefloatingIp": obj.get("azurefloatingIp"),
            "bootDiagnostics": obj.get("bootDiagnostics"),
            "osGuestDiagnostics": obj.get("osGuestDiagnostics"),
            "diagnosticsStorageAccount": obj.get("diagnosticsStorageAccount"),
            "createUser": obj.get("createUser") if obj.get("createUser") is not None else True
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


