# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_backup_jobs200_response_all_of_jobs_inner_backups_inner import ListBackupJobs200ResponseAllOfJobsInnerBackupsInner
from morpheus.models.list_backup_results200_response_all_of_results_inner_created_by import ListBackupResults200ResponseAllOfResultsInnerCreatedBy
from typing import Optional, Set
from typing_extensions import Self

class BackupResult(BaseModel):
    """
    BackupResult
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="Backup Result ID")
    backup: Optional[ListBackupJobs200ResponseAllOfJobsInnerBackupsInner] = None
    backup_set_id: Optional[StrictStr] = Field(default=None, alias="backupSetId")
    instance_id: Optional[StrictInt] = Field(default=None, alias="instanceId")
    container_id: Optional[StrictInt] = Field(default=None, alias="containerId")
    server_id: Optional[StrictInt] = Field(default=None, alias="serverId")
    status: Optional[StrictStr] = None
    error_message: Optional[StrictStr] = Field(default=None, alias="errorMessage")
    start_date: Optional[datetime] = Field(default=None, alias="startDate")
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    duration_millis: Optional[StrictInt] = Field(default=None, alias="durationMillis")
    size_in_bytes: Optional[StrictInt] = Field(default=None, alias="sizeInBytes")
    size_in_mb: Optional[StrictInt] = Field(default=None, alias="sizeInMb")
    volume_path: Optional[StrictStr] = Field(default=None, alias="volumePath")
    result_archive: Optional[StrictStr] = Field(default=None, alias="resultArchive")
    result_path: Optional[StrictStr] = Field(default=None, alias="resultPath")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    snapshot_id: Optional[StrictStr] = Field(default=None, alias="snapshotId")
    snapshot_external_id: Optional[StrictStr] = Field(default=None, alias="snapshotExternalId")
    created_by: Optional[ListBackupResults200ResponseAllOfResultsInnerCreatedBy] = Field(default=None, alias="createdBy")
    date_created: Optional[datetime] = Field(default=None, description="Date Created", alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, description="Last Updated", alias="lastUpdated")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "backup", "backupSetId", "instanceId", "containerId", "serverId", "status", "errorMessage", "startDate", "endDate", "durationMillis", "sizeInBytes", "sizeInMb", "volumePath", "resultArchive", "resultPath", "externalId", "snapshotId", "snapshotExternalId", "createdBy", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BackupResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of backup
        if self.backup:
            _dict['backup'] = self.backup.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if backup_set_id (nullable) is None
        # and model_fields_set contains the field
        if self.backup_set_id is None and "backup_set_id" in self.model_fields_set:
            _dict['backupSetId'] = None

        # set to None if instance_id (nullable) is None
        # and model_fields_set contains the field
        if self.instance_id is None and "instance_id" in self.model_fields_set:
            _dict['instanceId'] = None

        # set to None if container_id (nullable) is None
        # and model_fields_set contains the field
        if self.container_id is None and "container_id" in self.model_fields_set:
            _dict['containerId'] = None

        # set to None if server_id (nullable) is None
        # and model_fields_set contains the field
        if self.server_id is None and "server_id" in self.model_fields_set:
            _dict['serverId'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if error_message (nullable) is None
        # and model_fields_set contains the field
        if self.error_message is None and "error_message" in self.model_fields_set:
            _dict['errorMessage'] = None

        # set to None if start_date (nullable) is None
        # and model_fields_set contains the field
        if self.start_date is None and "start_date" in self.model_fields_set:
            _dict['startDate'] = None

        # set to None if end_date (nullable) is None
        # and model_fields_set contains the field
        if self.end_date is None and "end_date" in self.model_fields_set:
            _dict['endDate'] = None

        # set to None if duration_millis (nullable) is None
        # and model_fields_set contains the field
        if self.duration_millis is None and "duration_millis" in self.model_fields_set:
            _dict['durationMillis'] = None

        # set to None if size_in_bytes (nullable) is None
        # and model_fields_set contains the field
        if self.size_in_bytes is None and "size_in_bytes" in self.model_fields_set:
            _dict['sizeInBytes'] = None

        # set to None if size_in_mb (nullable) is None
        # and model_fields_set contains the field
        if self.size_in_mb is None and "size_in_mb" in self.model_fields_set:
            _dict['sizeInMb'] = None

        # set to None if volume_path (nullable) is None
        # and model_fields_set contains the field
        if self.volume_path is None and "volume_path" in self.model_fields_set:
            _dict['volumePath'] = None

        # set to None if result_archive (nullable) is None
        # and model_fields_set contains the field
        if self.result_archive is None and "result_archive" in self.model_fields_set:
            _dict['resultArchive'] = None

        # set to None if result_path (nullable) is None
        # and model_fields_set contains the field
        if self.result_path is None and "result_path" in self.model_fields_set:
            _dict['resultPath'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if snapshot_id (nullable) is None
        # and model_fields_set contains the field
        if self.snapshot_id is None and "snapshot_id" in self.model_fields_set:
            _dict['snapshotId'] = None

        # set to None if snapshot_external_id (nullable) is None
        # and model_fields_set contains the field
        if self.snapshot_external_id is None and "snapshot_external_id" in self.model_fields_set:
            _dict['snapshotExternalId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BackupResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "backup": ListBackupJobs200ResponseAllOfJobsInnerBackupsInner.from_dict(obj["backup"]) if obj.get("backup") is not None else None,
            "backupSetId": obj.get("backupSetId"),
            "instanceId": obj.get("instanceId"),
            "containerId": obj.get("containerId"),
            "serverId": obj.get("serverId"),
            "status": obj.get("status"),
            "errorMessage": obj.get("errorMessage"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "durationMillis": obj.get("durationMillis"),
            "sizeInBytes": obj.get("sizeInBytes"),
            "sizeInMb": obj.get("sizeInMb"),
            "volumePath": obj.get("volumePath"),
            "resultArchive": obj.get("resultArchive"),
            "resultPath": obj.get("resultPath"),
            "externalId": obj.get("externalId"),
            "snapshotId": obj.get("snapshotId"),
            "snapshotExternalId": obj.get("snapshotExternalId"),
            "createdBy": ListBackupResults200ResponseAllOfResultsInnerCreatedBy.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None,
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


