# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_catalog_item_type_request_catalog_item_type_one_of1_blueprint import AddCatalogItemTypeRequestCatalogItemTypeOneOf1Blueprint
from morpheus.models.add_catalog_item_type_request_catalog_item_type_one_of_form import AddCatalogItemTypeRequestCatalogItemTypeOneOfForm
from typing import Optional, Set
from typing_extensions import Self

class CatalogItemTypeBlueprintCreate(BaseModel):
    """
    CatalogItemTypeBlueprintCreate
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Catalog Item Type name")
    code: Optional[StrictStr] = Field(default=None, description="Useful shortcode for provisioning naming schemes and export reference.")
    category: Optional[StrictStr] = Field(default=None, description="Catalog Item Type category")
    description: Optional[StrictStr] = Field(default=None, description="Catalog Item Type description")
    labels: Optional[List[StrictStr]] = Field(default=None, description="Array of label strings, can be used for filtering.")
    type: Optional[StrictStr] = Field(default=None, description="Type, `instance`, `blueprint` or `workflow`. This determines whether an Instance or App will be provisioned. Instance types require a config and blueprint requires a blueprint and appSpec, while workflow types requires a workflow and context.")
    visibility: Optional[StrictStr] = Field(default='private', description="Visibility - Set to public to allow all tenants")
    layout_code: Optional[StrictStr] = Field(default=None, description="Identifier primarily used for Plugin Catalog Item Types", alias="layoutCode")
    icon_path: Optional[StrictStr] = Field(default=None, description="Icon Path, relative location of an icon image, eg. /assets/containers-png/nginx.png.", alias="iconPath")
    allow_quantity: Optional[StrictBool] = Field(default=None, description="Can users order more than one of this item at a time.", alias="allowQuantity")
    blueprint: AddCatalogItemTypeRequestCatalogItemTypeOneOf1Blueprint
    app_spec: Optional[StrictStr] = Field(default=None, description="The appSpec for blueprint type catalog items is a string in the Scribe YAML format with fields", alias="appSpec")
    form_type: Optional[StrictStr] = Field(default='optionTypes', description="Form Type determines if the configuration options come from a Form (form) or a list of Inputs (optionTypes).", alias="formType")
    form: Optional[AddCatalogItemTypeRequestCatalogItemTypeOneOfForm] = None
    option_types: Optional[List[StrictInt]] = Field(default=None, description="Array of option type IDs, see Inputs. Only applies to formType 'optionTypes'.", alias="optionTypes")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "code", "category", "description", "labels", "type", "visibility", "layoutCode", "iconPath", "allowQuantity", "blueprint", "appSpec", "formType", "form", "optionTypes"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['blueprint']):
            raise ValueError("must be one of enum values ('blueprint')")
        return value

    @field_validator('form_type')
    def form_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['optionTypes', 'form']):
            raise ValueError("must be one of enum values ('optionTypes', 'form')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CatalogItemTypeBlueprintCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of blueprint
        if self.blueprint:
            _dict['blueprint'] = self.blueprint.to_dict()
        # override the default output from pydantic by calling `to_dict()` of form
        if self.form:
            _dict['form'] = self.form.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if code (nullable) is None
        # and model_fields_set contains the field
        if self.code is None and "code" in self.model_fields_set:
            _dict['code'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        # set to None if layout_code (nullable) is None
        # and model_fields_set contains the field
        if self.layout_code is None and "layout_code" in self.model_fields_set:
            _dict['layoutCode'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CatalogItemTypeBlueprintCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "code": obj.get("code"),
            "category": obj.get("category"),
            "description": obj.get("description"),
            "labels": obj.get("labels"),
            "type": obj.get("type"),
            "visibility": obj.get("visibility") if obj.get("visibility") is not None else 'private',
            "layoutCode": obj.get("layoutCode"),
            "iconPath": obj.get("iconPath"),
            "allowQuantity": obj.get("allowQuantity"),
            "blueprint": AddCatalogItemTypeRequestCatalogItemTypeOneOf1Blueprint.from_dict(obj["blueprint"]) if obj.get("blueprint") is not None else None,
            "appSpec": obj.get("appSpec"),
            "formType": obj.get("formType") if obj.get("formType") is not None else 'optionTypes',
            "form": AddCatalogItemTypeRequestCatalogItemTypeOneOfForm.from_dict(obj["form"]) if obj.get("form") is not None else None,
            "optionTypes": obj.get("optionTypes")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


