# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_catalog_item_type_request_catalog_item_type_one_of_config_cloud import AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigCloud
from morpheus.models.add_catalog_item_type_request_catalog_item_type_one_of_config_config import AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigConfig
from morpheus.models.add_catalog_item_type_request_catalog_item_type_one_of_config_evars_inner import AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner
from morpheus.models.add_catalog_item_type_request_catalog_item_type_one_of_config_group import AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigGroup
from morpheus.models.add_catalog_item_type_request_catalog_item_type_one_of_config_layout import AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigLayout
from morpheus.models.add_catalog_item_type_request_catalog_item_type_one_of_config_network_interfaces_inner import AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigNetworkInterfacesInner
from morpheus.models.add_catalog_item_type_request_catalog_item_type_one_of_config_plan import AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigPlan
from morpheus.models.add_catalog_item_type_request_catalog_item_type_one_of_config_ports_inner import AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigPortsInner
from morpheus.models.add_catalog_item_type_request_catalog_item_type_one_of_config_security_groups_inner import AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigSecurityGroupsInner
from morpheus.models.add_catalog_item_type_request_catalog_item_type_one_of_config_service_plan_options import AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigServicePlanOptions
from morpheus.models.add_catalog_item_type_request_catalog_item_type_one_of_config_volumes_inner import AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigVolumesInner
from typing import Optional, Set
from typing_extensions import Self

class CatalogItemTypeInstanceScribe(BaseModel):
    """
    CatalogItemTypeInstanceScribe
    """ # noqa: E501
    group: AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigGroup
    cloud: AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigCloud
    type: StrictStr = Field(description="The type of instance by code we want to fetch.")
    name: StrictStr = Field(description="Name of the instance to be created.")
    config: AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigConfig
    volumes: List[AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigVolumesInner] = Field(description="The (optional) volumes parameter is for LV configuration, can create additional LVs at provision It should be passed as an array of")
    host_name: Optional[StrictStr] = Field(default=None, description="Hostname of the instance to be created.  Can be the same as the instance name.", alias="hostName")
    environment: Optional[StrictStr] = Field(default=None, description="Environment code")
    layout: AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigLayout
    plan: AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigPlan
    version: Optional[StrictStr] = Field(default=None, description="Version of the layout to create.")
    evars: Optional[List[AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner]] = Field(default=None, description="Environment Variables, an array of objects that have name and value.")
    service_plan_options: Optional[AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigServicePlanOptions] = Field(default=None, alias="servicePlanOptions")
    security_groups: Optional[List[AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigSecurityGroupsInner]] = Field(default=None, description="Key for security group configuration. It should be passed as an array of objects containing the id of the security group to assign the instance to.", alias="securityGroups")
    network_interfaces: Optional[List[AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigNetworkInterfacesInner]] = Field(default=None, description="The networkInterfaces parameter is for network configuration.  The Options API `/api/options/zoneNetworkOptions?zoneId=5&provisionTypeId=10` can be used to see which options are available. ", alias="networkInterfaces")
    labels: Optional[List[StrictStr]] = Field(default=None, description="Array of strings (keywords).")
    tags: Optional[List[AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner]] = Field(default=None, description="Metadata tags, Array of objects having a name and value.")
    metadata: Optional[List[AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner]] = Field(default=None, description="Alias for `tags`.")
    ports: Optional[List[AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigPortsInner]] = Field(default=None, description="The ports parameter is for port configuration.  The layout may have default ports, which are defined in node types, that are always configured. This parameter will be for additional custom ports to be opened. ")
    task_set_id: Optional[StrictInt] = Field(default=None, description="The Workflow ID to execute.", alias="taskSetId")
    task_set_name: Optional[StrictStr] = Field(default=None, description="The Workflow Name to execute.", alias="taskSetName")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["group", "cloud", "type", "name", "config", "volumes", "hostName", "environment", "layout", "plan", "version", "evars", "servicePlanOptions", "securityGroups", "networkInterfaces", "labels", "tags", "metadata", "ports", "taskSetId", "taskSetName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CatalogItemTypeInstanceScribe from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of group
        if self.group:
            _dict['group'] = self.group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cloud
        if self.cloud:
            _dict['cloud'] = self.cloud.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in volumes (list)
        _items = []
        if self.volumes:
            for _item_volumes in self.volumes:
                if _item_volumes:
                    _items.append(_item_volumes.to_dict())
            _dict['volumes'] = _items
        # override the default output from pydantic by calling `to_dict()` of layout
        if self.layout:
            _dict['layout'] = self.layout.to_dict()
        # override the default output from pydantic by calling `to_dict()` of plan
        if self.plan:
            _dict['plan'] = self.plan.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in evars (list)
        _items = []
        if self.evars:
            for _item_evars in self.evars:
                if _item_evars:
                    _items.append(_item_evars.to_dict())
            _dict['evars'] = _items
        # override the default output from pydantic by calling `to_dict()` of service_plan_options
        if self.service_plan_options:
            _dict['servicePlanOptions'] = self.service_plan_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in security_groups (list)
        _items = []
        if self.security_groups:
            for _item_security_groups in self.security_groups:
                if _item_security_groups:
                    _items.append(_item_security_groups.to_dict())
            _dict['securityGroups'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in network_interfaces (list)
        _items = []
        if self.network_interfaces:
            for _item_network_interfaces in self.network_interfaces:
                if _item_network_interfaces:
                    _items.append(_item_network_interfaces.to_dict())
            _dict['networkInterfaces'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in metadata (list)
        _items = []
        if self.metadata:
            for _item_metadata in self.metadata:
                if _item_metadata:
                    _items.append(_item_metadata.to_dict())
            _dict['metadata'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in ports (list)
        _items = []
        if self.ports:
            for _item_ports in self.ports:
                if _item_ports:
                    _items.append(_item_ports.to_dict())
            _dict['ports'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if security_groups (nullable) is None
        # and model_fields_set contains the field
        if self.security_groups is None and "security_groups" in self.model_fields_set:
            _dict['securityGroups'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CatalogItemTypeInstanceScribe from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "group": AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigGroup.from_dict(obj["group"]) if obj.get("group") is not None else None,
            "cloud": AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigCloud.from_dict(obj["cloud"]) if obj.get("cloud") is not None else None,
            "type": obj.get("type"),
            "name": obj.get("name"),
            "config": AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "volumes": [AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigVolumesInner.from_dict(_item) for _item in obj["volumes"]] if obj.get("volumes") is not None else None,
            "hostName": obj.get("hostName"),
            "environment": obj.get("environment"),
            "layout": AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigLayout.from_dict(obj["layout"]) if obj.get("layout") is not None else None,
            "plan": AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigPlan.from_dict(obj["plan"]) if obj.get("plan") is not None else None,
            "version": obj.get("version"),
            "evars": [AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner.from_dict(_item) for _item in obj["evars"]] if obj.get("evars") is not None else None,
            "servicePlanOptions": AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigServicePlanOptions.from_dict(obj["servicePlanOptions"]) if obj.get("servicePlanOptions") is not None else None,
            "securityGroups": [AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigSecurityGroupsInner.from_dict(_item) for _item in obj["securityGroups"]] if obj.get("securityGroups") is not None else None,
            "networkInterfaces": [AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigNetworkInterfacesInner.from_dict(_item) for _item in obj["networkInterfaces"]] if obj.get("networkInterfaces") is not None else None,
            "labels": obj.get("labels"),
            "tags": [AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "metadata": [AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner.from_dict(_item) for _item in obj["metadata"]] if obj.get("metadata") is not None else None,
            "ports": [AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigPortsInner.from_dict(_item) for _item in obj["ports"]] if obj.get("ports") is not None else None,
            "taskSetId": obj.get("taskSetId"),
            "taskSetName": obj.get("taskSetName")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


