# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CheckSocketConfig(BaseModel):
    """
    CheckSocketConfig
    """ # noqa: E501
    host: StrictStr = Field(description="Hostname or IP address of the socket server")
    port: StrictStr = Field(description="TCP port")
    send: StrictStr = Field(description="Connection string you might want to send to the service")
    response_match: StrictStr = Field(description="Response from the service to match against", alias="responseMatch")
    check_user: Optional[StrictStr] = Field(default=None, alias="checkUser")
    text_check_on: Optional[StrictStr] = Field(default=None, alias="textCheckOn")
    check_password: Optional[StrictStr] = Field(default=None, alias="checkPassword")
    web_text_match: Optional[StrictStr] = Field(default=None, alias="webTextMatch")
    check_password_hash: Optional[StrictStr] = Field(default=None, alias="checkPasswordHash")
    tunnel_on: Optional[StrictStr] = Field(default='off', description="Set to on to turn on tunneling", alias="tunnelOn")
    ssh_host: Optional[StrictStr] = Field(default=None, description="Hostname or IP address of the proxy host", alias="sshHost")
    ssh_port: Optional[StrictInt] = Field(default=None, description="Port for SSH on the proxy host, defaults to 22", alias="sshPort")
    ssh_user: Optional[StrictStr] = Field(default=None, description="SSH user on the proxy host to login as", alias="sshUser")
    ssh_password: Optional[StrictStr] = Field(default=None, description="Password for user, if not using key based authentication", alias="sshPassword")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["host", "port", "send", "responseMatch", "checkUser", "textCheckOn", "checkPassword", "webTextMatch", "checkPasswordHash", "tunnelOn", "sshHost", "sshPort", "sshUser", "sshPassword"]

    @field_validator('tunnel_on')
    def tunnel_on_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['on', 'off']):
            raise ValueError("must be one of enum values ('on', 'off')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CheckSocketConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CheckSocketConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "host": obj.get("host"),
            "port": obj.get("port"),
            "send": obj.get("send"),
            "responseMatch": obj.get("responseMatch"),
            "checkUser": obj.get("checkUser"),
            "textCheckOn": obj.get("textCheckOn"),
            "checkPassword": obj.get("checkPassword"),
            "webTextMatch": obj.get("webTextMatch"),
            "checkPasswordHash": obj.get("checkPasswordHash"),
            "tunnelOn": obj.get("tunnelOn") if obj.get("tunnelOn") is not None else 'off',
            "sshHost": obj.get("sshHost"),
            "sshPort": obj.get("sshPort"),
            "sshUser": obj.get("sshUser"),
            "sshPassword": obj.get("sshPassword")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


