# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from morpheus.models.get_cluster_history200_response_all_of_processes_inner_created_by import GetClusterHistory200ResponseAllOfProcessesInnerCreatedBy
from morpheus.models.get_cluster_history200_response_all_of_processes_inner_events_inner import GetClusterHistory200ResponseAllOfProcessesInnerEventsInner
from morpheus.models.list_cluster_containers200_response_all_of_containers_inner_available_actions_inner import ListClusterContainers200ResponseAllOfContainersInnerAvailableActionsInner
from typing import Optional, Set
from typing_extensions import Self

class ClusterHistory(BaseModel):
    """
    ClusterHistory
    """ # noqa: E501
    id: Optional[StrictInt] = None
    account_id: Optional[StrictInt] = Field(default=None, alias="accountId")
    unique_id: Optional[StrictStr] = Field(default=None, alias="uniqueId")
    process_type: Optional[ListClusterContainers200ResponseAllOfContainersInnerAvailableActionsInner] = Field(default=None, alias="processType")
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    description: Optional[StrictStr] = None
    sub_type: Optional[StrictStr] = Field(default=None, alias="subType")
    sub_id: Optional[StrictStr] = Field(default=None, alias="subId")
    zone_id: Optional[StrictInt] = Field(default=None, alias="zoneId")
    integration_id: Optional[StrictInt] = Field(default=None, alias="integrationId")
    app_id: Optional[StrictInt] = Field(default=None, alias="appId")
    instance_id: Optional[StrictInt] = Field(default=None, alias="instanceId")
    container_id: Optional[StrictInt] = Field(default=None, alias="containerId")
    server_id: Optional[StrictInt] = Field(default=None, alias="serverId")
    container_name: Optional[StrictStr] = Field(default=None, alias="containerName")
    status: Optional[StrictStr] = None
    reason: Optional[StrictStr] = None
    percent: Optional[Union[StrictFloat, StrictInt]] = None
    status_eta: Optional[StrictInt] = Field(default=None, alias="statusEta")
    message: Optional[StrictStr] = None
    output: Optional[StrictStr] = None
    error: Optional[StrictStr] = None
    start_date: Optional[datetime] = Field(default=None, alias="startDate")
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    duration: Optional[StrictInt] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    created_by: Optional[GetClusterHistory200ResponseAllOfProcessesInnerCreatedBy] = Field(default=None, alias="createdBy")
    updated_by: Optional[GetClusterHistory200ResponseAllOfProcessesInnerCreatedBy] = Field(default=None, alias="updatedBy")
    events: Optional[List[GetClusterHistory200ResponseAllOfProcessesInnerEventsInner]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "accountId", "uniqueId", "processType", "displayName", "description", "subType", "subId", "zoneId", "integrationId", "appId", "instanceId", "containerId", "serverId", "containerName", "status", "reason", "percent", "statusEta", "message", "output", "error", "startDate", "endDate", "duration", "dateCreated", "lastUpdated", "createdBy", "updatedBy", "events"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClusterHistory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of process_type
        if self.process_type:
            _dict['processType'] = self.process_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of updated_by
        if self.updated_by:
            _dict['updatedBy'] = self.updated_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in events (list)
        _items = []
        if self.events:
            for _item_events in self.events:
                if _item_events:
                    _items.append(_item_events.to_dict())
            _dict['events'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if sub_type (nullable) is None
        # and model_fields_set contains the field
        if self.sub_type is None and "sub_type" in self.model_fields_set:
            _dict['subType'] = None

        # set to None if sub_id (nullable) is None
        # and model_fields_set contains the field
        if self.sub_id is None and "sub_id" in self.model_fields_set:
            _dict['subId'] = None

        # set to None if zone_id (nullable) is None
        # and model_fields_set contains the field
        if self.zone_id is None and "zone_id" in self.model_fields_set:
            _dict['zoneId'] = None

        # set to None if integration_id (nullable) is None
        # and model_fields_set contains the field
        if self.integration_id is None and "integration_id" in self.model_fields_set:
            _dict['integrationId'] = None

        # set to None if app_id (nullable) is None
        # and model_fields_set contains the field
        if self.app_id is None and "app_id" in self.model_fields_set:
            _dict['appId'] = None

        # set to None if instance_id (nullable) is None
        # and model_fields_set contains the field
        if self.instance_id is None and "instance_id" in self.model_fields_set:
            _dict['instanceId'] = None

        # set to None if container_id (nullable) is None
        # and model_fields_set contains the field
        if self.container_id is None and "container_id" in self.model_fields_set:
            _dict['containerId'] = None

        # set to None if server_id (nullable) is None
        # and model_fields_set contains the field
        if self.server_id is None and "server_id" in self.model_fields_set:
            _dict['serverId'] = None

        # set to None if container_name (nullable) is None
        # and model_fields_set contains the field
        if self.container_name is None and "container_name" in self.model_fields_set:
            _dict['containerName'] = None

        # set to None if reason (nullable) is None
        # and model_fields_set contains the field
        if self.reason is None and "reason" in self.model_fields_set:
            _dict['reason'] = None

        # set to None if message (nullable) is None
        # and model_fields_set contains the field
        if self.message is None and "message" in self.model_fields_set:
            _dict['message'] = None

        # set to None if output (nullable) is None
        # and model_fields_set contains the field
        if self.output is None and "output" in self.model_fields_set:
            _dict['output'] = None

        # set to None if error (nullable) is None
        # and model_fields_set contains the field
        if self.error is None and "error" in self.model_fields_set:
            _dict['error'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClusterHistory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "accountId": obj.get("accountId"),
            "uniqueId": obj.get("uniqueId"),
            "processType": ListClusterContainers200ResponseAllOfContainersInnerAvailableActionsInner.from_dict(obj["processType"]) if obj.get("processType") is not None else None,
            "displayName": obj.get("displayName"),
            "description": obj.get("description"),
            "subType": obj.get("subType"),
            "subId": obj.get("subId"),
            "zoneId": obj.get("zoneId"),
            "integrationId": obj.get("integrationId"),
            "appId": obj.get("appId"),
            "instanceId": obj.get("instanceId"),
            "containerId": obj.get("containerId"),
            "serverId": obj.get("serverId"),
            "containerName": obj.get("containerName"),
            "status": obj.get("status"),
            "reason": obj.get("reason"),
            "percent": obj.get("percent"),
            "statusEta": obj.get("statusEta"),
            "message": obj.get("message"),
            "output": obj.get("output"),
            "error": obj.get("error"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "duration": obj.get("duration"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "createdBy": GetClusterHistory200ResponseAllOfProcessesInnerCreatedBy.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None,
            "updatedBy": GetClusterHistory200ResponseAllOfProcessesInnerCreatedBy.from_dict(obj["updatedBy"]) if obj.get("updatedBy") is not None else None,
            "events": [GetClusterHistory200ResponseAllOfProcessesInnerEventsInner.from_dict(_item) for _item in obj["events"]] if obj.get("events") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


