# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_cluster_layouts_request_layout_environment_variables_inner import AddClusterLayoutsRequestLayoutEnvironmentVariablesInner
from morpheus.models.add_cluster_layouts_request_layout_group_type import AddClusterLayoutsRequestLayoutGroupType
from morpheus.models.add_cluster_layouts_request_layout_masters_inner import AddClusterLayoutsRequestLayoutMastersInner
from morpheus.models.add_cluster_layouts_request_layout_provision_type import AddClusterLayoutsRequestLayoutProvisionType
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from typing import Optional, Set
from typing_extensions import Self

class ClusterLayoutUpdate(BaseModel):
    """
    ClusterLayoutUpdate
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Cluster layout name")
    description: Optional[StrictStr] = Field(default=None, description="Cluster layout description")
    labels: Optional[List[StrictStr]] = Field(default=None, description="Array of label strings, can be used for filtering.")
    compute_version: Optional[StrictStr] = Field(default=None, description="Version of the cluster layout", alias="computeVersion")
    creatable: Optional[StrictBool] = Field(default=True, description="Can be used to enable / disable the creatability of the cluster layout.")
    has_auto_scale: Optional[StrictBool] = Field(default=False, description="Can be used to enable / disable the horizontal scaling.", alias="hasAutoScale")
    install_container_runtime: Optional[StrictBool] = Field(default=False, description="Install Docker (container runtime).", alias="installContainerRuntime")
    memory_requirement: Optional[StrictInt] = Field(default=None, description="Memory requirement in bytes", alias="memoryRequirement")
    group_type: Optional[AddClusterLayoutsRequestLayoutGroupType] = Field(default=None, alias="groupType")
    provision_type: Optional[AddClusterLayoutsRequestLayoutProvisionType] = Field(default=None, alias="provisionType")
    option_types: Optional[List[GetAlerts200ResponseAllOfChecksInnerAccount]] = Field(default=None, description="Array of cluster layout option types", alias="optionTypes")
    task_sets: Optional[List[GetAlerts200ResponseAllOfChecksInnerAccount]] = Field(default=None, description="Array of cluster layout task sets", alias="taskSets")
    environment_variables: Optional[List[AddClusterLayoutsRequestLayoutEnvironmentVariablesInner]] = Field(default=None, description="Array of cluster layout env variables", alias="environmentVariables")
    masters: Optional[List[AddClusterLayoutsRequestLayoutMastersInner]] = Field(default=None, description="Array of cluster layout master nodes")
    workers: Optional[List[AddClusterLayoutsRequestLayoutMastersInner]] = Field(default=None, description="Array of cluster layout worker nodes")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "description", "labels", "computeVersion", "creatable", "hasAutoScale", "installContainerRuntime", "memoryRequirement", "groupType", "provisionType", "optionTypes", "taskSets", "environmentVariables", "masters", "workers"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClusterLayoutUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of group_type
        if self.group_type:
            _dict['groupType'] = self.group_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of provision_type
        if self.provision_type:
            _dict['provisionType'] = self.provision_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in option_types (list)
        _items = []
        if self.option_types:
            for _item_option_types in self.option_types:
                if _item_option_types:
                    _items.append(_item_option_types.to_dict())
            _dict['optionTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in task_sets (list)
        _items = []
        if self.task_sets:
            for _item_task_sets in self.task_sets:
                if _item_task_sets:
                    _items.append(_item_task_sets.to_dict())
            _dict['taskSets'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in environment_variables (list)
        _items = []
        if self.environment_variables:
            for _item_environment_variables in self.environment_variables:
                if _item_environment_variables:
                    _items.append(_item_environment_variables.to_dict())
            _dict['environmentVariables'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in masters (list)
        _items = []
        if self.masters:
            for _item_masters in self.masters:
                if _item_masters:
                    _items.append(_item_masters.to_dict())
            _dict['masters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in workers (list)
        _items = []
        if self.workers:
            for _item_workers in self.workers:
                if _item_workers:
                    _items.append(_item_workers.to_dict())
            _dict['workers'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClusterLayoutUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "labels": obj.get("labels"),
            "computeVersion": obj.get("computeVersion"),
            "creatable": obj.get("creatable") if obj.get("creatable") is not None else True,
            "hasAutoScale": obj.get("hasAutoScale") if obj.get("hasAutoScale") is not None else False,
            "installContainerRuntime": obj.get("installContainerRuntime") if obj.get("installContainerRuntime") is not None else False,
            "memoryRequirement": obj.get("memoryRequirement"),
            "groupType": AddClusterLayoutsRequestLayoutGroupType.from_dict(obj["groupType"]) if obj.get("groupType") is not None else None,
            "provisionType": AddClusterLayoutsRequestLayoutProvisionType.from_dict(obj["provisionType"]) if obj.get("provisionType") is not None else None,
            "optionTypes": [GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(_item) for _item in obj["optionTypes"]] if obj.get("optionTypes") is not None else None,
            "taskSets": [GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(_item) for _item in obj["taskSets"]] if obj.get("taskSets") is not None else None,
            "environmentVariables": [AddClusterLayoutsRequestLayoutEnvironmentVariablesInner.from_dict(_item) for _item in obj["environmentVariables"]] if obj.get("environmentVariables") is not None else None,
            "masters": [AddClusterLayoutsRequestLayoutMastersInner.from_dict(_item) for _item in obj["masters"]] if obj.get("masters") is not None else None,
            "workers": [AddClusterLayoutsRequestLayoutMastersInner.from_dict(_item) for _item in obj["workers"]] if obj.get("workers") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


