# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from typing import Optional, Set
from typing_extensions import Self

class CreateNetworkDomain200ResponseNetworkDomain(BaseModel):
    """
    CreateNetworkDomain200ResponseNetworkDomain
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    active: Optional[StrictBool] = None
    fqdn: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    visibility: Optional[StrictStr] = None
    domain_controller: Optional[StrictBool] = Field(default=None, alias="domainController")
    public_zone: Optional[StrictBool] = Field(default=None, alias="publicZone")
    domain_username: Optional[StrictStr] = Field(default=None, alias="domainUsername")
    domain_password: Optional[StrictStr] = Field(default=None, alias="domainPassword")
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    ref_id: Optional[StrictInt] = Field(default=None, alias="refId")
    ref_source: Optional[StrictStr] = Field(default=None, alias="refSource")
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    ou_path: Optional[StrictStr] = Field(default=None, alias="ouPath")
    dc_server: Optional[StrictStr] = Field(default=None, alias="dcServer")
    zone_type: Optional[StrictStr] = Field(default=None, alias="zoneType")
    dnssec: Optional[StrictStr] = None
    domain_serial: Optional[StrictStr] = Field(default=None, alias="domainSerial")
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    owner: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "active", "fqdn", "description", "visibility", "domainController", "publicZone", "domainUsername", "domainPassword", "refType", "refId", "refSource", "internalId", "ouPath", "dcServer", "zoneType", "dnssec", "domainSerial", "account", "owner"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateNetworkDomain200ResponseNetworkDomain from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if fqdn (nullable) is None
        # and model_fields_set contains the field
        if self.fqdn is None and "fqdn" in self.model_fields_set:
            _dict['fqdn'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if domain_username (nullable) is None
        # and model_fields_set contains the field
        if self.domain_username is None and "domain_username" in self.model_fields_set:
            _dict['domainUsername'] = None

        # set to None if domain_password (nullable) is None
        # and model_fields_set contains the field
        if self.domain_password is None and "domain_password" in self.model_fields_set:
            _dict['domainPassword'] = None

        # set to None if ref_type (nullable) is None
        # and model_fields_set contains the field
        if self.ref_type is None and "ref_type" in self.model_fields_set:
            _dict['refType'] = None

        # set to None if ref_id (nullable) is None
        # and model_fields_set contains the field
        if self.ref_id is None and "ref_id" in self.model_fields_set:
            _dict['refId'] = None

        # set to None if ref_source (nullable) is None
        # and model_fields_set contains the field
        if self.ref_source is None and "ref_source" in self.model_fields_set:
            _dict['refSource'] = None

        # set to None if internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_id is None and "internal_id" in self.model_fields_set:
            _dict['internalId'] = None

        # set to None if ou_path (nullable) is None
        # and model_fields_set contains the field
        if self.ou_path is None and "ou_path" in self.model_fields_set:
            _dict['ouPath'] = None

        # set to None if dc_server (nullable) is None
        # and model_fields_set contains the field
        if self.dc_server is None and "dc_server" in self.model_fields_set:
            _dict['dcServer'] = None

        # set to None if zone_type (nullable) is None
        # and model_fields_set contains the field
        if self.zone_type is None and "zone_type" in self.model_fields_set:
            _dict['zoneType'] = None

        # set to None if dnssec (nullable) is None
        # and model_fields_set contains the field
        if self.dnssec is None and "dnssec" in self.model_fields_set:
            _dict['dnssec'] = None

        # set to None if domain_serial (nullable) is None
        # and model_fields_set contains the field
        if self.domain_serial is None and "domain_serial" in self.model_fields_set:
            _dict['domainSerial'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateNetworkDomain200ResponseNetworkDomain from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "active": obj.get("active"),
            "fqdn": obj.get("fqdn"),
            "description": obj.get("description"),
            "visibility": obj.get("visibility"),
            "domainController": obj.get("domainController"),
            "publicZone": obj.get("publicZone"),
            "domainUsername": obj.get("domainUsername"),
            "domainPassword": obj.get("domainPassword"),
            "refType": obj.get("refType"),
            "refId": obj.get("refId"),
            "refSource": obj.get("refSource"),
            "internalId": obj.get("internalId"),
            "ouPath": obj.get("ouPath"),
            "dcServer": obj.get("dcServer"),
            "zoneType": obj.get("zoneType"),
            "dnssec": obj.get("dnssec"),
            "domainSerial": obj.get("domainSerial"),
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "owner": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["owner"]) if obj.get("owner") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


