# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from typing import Optional, Set
from typing_extensions import Self

class CreateNetworkProxy200ResponseNetworkProxy(BaseModel):
    """
    CreateNetworkProxy200ResponseNetworkProxy
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    proxy_host: Optional[StrictStr] = Field(default=None, alias="proxyHost")
    proxy_port: Optional[StrictInt] = Field(default=None, alias="proxyPort")
    proxy_user: Optional[StrictStr] = Field(default=None, alias="proxyUser")
    proxy_password: Optional[StrictStr] = Field(default=None, alias="proxyPassword")
    proxy_domain: Optional[StrictStr] = Field(default=None, alias="proxyDomain")
    proxy_workstation: Optional[StrictStr] = Field(default=None, alias="proxyWorkstation")
    visibility: Optional[StrictStr] = None
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    owner: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "proxyHost", "proxyPort", "proxyUser", "proxyPassword", "proxyDomain", "proxyWorkstation", "visibility", "account", "owner"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateNetworkProxy200ResponseNetworkProxy from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if proxy_user (nullable) is None
        # and model_fields_set contains the field
        if self.proxy_user is None and "proxy_user" in self.model_fields_set:
            _dict['proxyUser'] = None

        # set to None if proxy_password (nullable) is None
        # and model_fields_set contains the field
        if self.proxy_password is None and "proxy_password" in self.model_fields_set:
            _dict['proxyPassword'] = None

        # set to None if proxy_workstation (nullable) is None
        # and model_fields_set contains the field
        if self.proxy_workstation is None and "proxy_workstation" in self.model_fields_set:
            _dict['proxyWorkstation'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateNetworkProxy200ResponseNetworkProxy from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "proxyHost": obj.get("proxyHost"),
            "proxyPort": obj.get("proxyPort"),
            "proxyUser": obj.get("proxyUser"),
            "proxyPassword": obj.get("proxyPassword"),
            "proxyDomain": obj.get("proxyDomain"),
            "proxyWorkstation": obj.get("proxyWorkstation"),
            "visibility": obj.get("visibility"),
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "owner": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["owner"]) if obj.get("owner") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


