# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.create_networks_request_network_config import CreateNetworksRequestNetworkConfig
from morpheus.models.create_networks_request_network_resource_permissions import CreateNetworksRequestNetworkResourcePermissions
from morpheus.models.create_networks_request_network_site import CreateNetworksRequestNetworkSite
from morpheus.models.create_networks_request_network_type import CreateNetworksRequestNetworkType
from morpheus.models.create_networks_request_network_zone import CreateNetworksRequestNetworkZone
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from morpheus.models.list_networks200_response_all_of_networks_inner_network_domain import ListNetworks200ResponseAllOfNetworksInnerNetworkDomain
from morpheus.models.list_networks200_response_all_of_networks_inner_network_proxy import ListNetworks200ResponseAllOfNetworksInnerNetworkProxy
from typing import Optional, Set
from typing_extensions import Self

class CreateNetworksRequestNetwork(BaseModel):
    """
    CreateNetworksRequestNetwork
    """ # noqa: E501
    name: StrictStr = Field(description="Name")
    display_name: Optional[StrictStr] = Field(default=None, description="Display Name", alias="displayName")
    labels: Optional[List[StrictStr]] = Field(default=None, description="Array of label strings, can be used for filtering.")
    description: Optional[StrictStr] = Field(default=None, description="Description")
    site: CreateNetworksRequestNetworkSite
    zone: CreateNetworksRequestNetworkZone
    type: Optional[CreateNetworksRequestNetworkType] = None
    ipv4_enabled: Optional[StrictBool] = Field(default=None, alias="ipv4Enabled")
    ipv6_enabled: Optional[StrictBool] = Field(default=None, alias="ipv6Enabled")
    cidr: Optional[StrictStr] = Field(default=None, description="CIDR Network")
    gateway: Optional[StrictStr] = Field(default=None, description="Network Gateway")
    dns_primary: Optional[StrictStr] = Field(default=None, description="Primary DNS Server", alias="dnsPrimary")
    dns_secondary: Optional[StrictStr] = Field(default=None, description="Secondary DNS Server", alias="dnsSecondary")
    gateway_ipv6: Optional[StrictStr] = Field(default=None, description="IPv6 Network Gateway", alias="gatewayIPv6")
    netmask_ipv6: Optional[StrictStr] = Field(default=None, alias="netmaskIPv6")
    dns_primary_ipv6: Optional[StrictStr] = Field(default=None, description="Primary IPv6 DNS Server", alias="dnsPrimaryIPv6")
    dns_secondary_ipv6: Optional[StrictStr] = Field(default=None, description="Secondary IPv6 DNS Server", alias="dnsSecondaryIPv6")
    cidr_ipv6: Optional[StrictStr] = Field(default=None, description="IPv6 Network CIDR", alias="cidrIPv6")
    vlan_id: Optional[StrictInt] = Field(default=None, alias="vlanId")
    pool: Optional[StrictInt] = Field(default=None, description="Network Pool ID")
    pool_ipv6: Optional[StrictInt] = Field(default=None, description="IPv6 Network Pool ID", alias="poolIPv6")
    allow_static_override: Optional[StrictBool] = Field(default=None, description="Allow IP Override", alias="allowStaticOverride")
    assign_public_ip: Optional[StrictBool] = Field(default=None, description="Assign Public IP", alias="assignPublicIp")
    active: Optional[StrictBool] = Field(default=None, description="Activate (true) or disable (false) the network")
    dhcp_server: Optional[StrictBool] = Field(default=None, description="DHCP Server enabled network", alias="dhcpServer")
    dhcp_server_ipv6: Optional[StrictBool] = Field(default=None, description="IPv6 DHCP Server enabled network", alias="dhcpServerIPv6")
    network_domain: Optional[ListNetworks200ResponseAllOfNetworksInnerNetworkDomain] = Field(default=None, alias="networkDomain")
    search_domains: Optional[StrictStr] = Field(default=None, description="Search Domains", alias="searchDomains")
    network_proxy: Optional[ListNetworks200ResponseAllOfNetworksInnerNetworkProxy] = Field(default=None, alias="networkProxy")
    appliance_url_proxy_bypass: Optional[StrictBool] = Field(default=None, description="Bypass Proxy for Appliance URL", alias="applianceUrlProxyBypass")
    no_proxy: Optional[StrictStr] = Field(default=None, description="Comma-separated list of ip addresses or name servers to exclude proxy traversal for. Typically locally routable servers are excluded.", alias="noProxy")
    visibility: Optional[StrictStr] = Field(default='private', description="Visibility, private or public.")
    config: Optional[CreateNetworksRequestNetworkConfig] = None
    tenants: Optional[List[GetAlerts200ResponseAllOfChecksInnerAccount]] = Field(default=None, description="Array of tenant account ids that are allowed access")
    resource_permissions: Optional[CreateNetworksRequestNetworkResourcePermissions] = Field(default=None, alias="resourcePermissions")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "displayName", "labels", "description", "site", "zone", "type", "ipv4Enabled", "ipv6Enabled", "cidr", "gateway", "dnsPrimary", "dnsSecondary", "gatewayIPv6", "netmaskIPv6", "dnsPrimaryIPv6", "dnsSecondaryIPv6", "cidrIPv6", "vlanId", "pool", "poolIPv6", "allowStaticOverride", "assignPublicIp", "active", "dhcpServer", "dhcpServerIPv6", "networkDomain", "searchDomains", "networkProxy", "applianceUrlProxyBypass", "noProxy", "visibility", "config", "tenants", "resourcePermissions"]

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['private', 'public']):
            raise ValueError("must be one of enum values ('private', 'public')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateNetworksRequestNetwork from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of site
        if self.site:
            _dict['site'] = self.site.to_dict()
        # override the default output from pydantic by calling `to_dict()` of zone
        if self.zone:
            _dict['zone'] = self.zone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network_domain
        if self.network_domain:
            _dict['networkDomain'] = self.network_domain.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network_proxy
        if self.network_proxy:
            _dict['networkProxy'] = self.network_proxy.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tenants (list)
        _items = []
        if self.tenants:
            for _item_tenants in self.tenants:
                if _item_tenants:
                    _items.append(_item_tenants.to_dict())
            _dict['tenants'] = _items
        # override the default output from pydantic by calling `to_dict()` of resource_permissions
        if self.resource_permissions:
            _dict['resourcePermissions'] = self.resource_permissions.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if gateway_ipv6 (nullable) is None
        # and model_fields_set contains the field
        if self.gateway_ipv6 is None and "gateway_ipv6" in self.model_fields_set:
            _dict['gatewayIPv6'] = None

        # set to None if netmask_ipv6 (nullable) is None
        # and model_fields_set contains the field
        if self.netmask_ipv6 is None and "netmask_ipv6" in self.model_fields_set:
            _dict['netmaskIPv6'] = None

        # set to None if dns_primary_ipv6 (nullable) is None
        # and model_fields_set contains the field
        if self.dns_primary_ipv6 is None and "dns_primary_ipv6" in self.model_fields_set:
            _dict['dnsPrimaryIPv6'] = None

        # set to None if dns_secondary_ipv6 (nullable) is None
        # and model_fields_set contains the field
        if self.dns_secondary_ipv6 is None and "dns_secondary_ipv6" in self.model_fields_set:
            _dict['dnsSecondaryIPv6'] = None

        # set to None if pool (nullable) is None
        # and model_fields_set contains the field
        if self.pool is None and "pool" in self.model_fields_set:
            _dict['pool'] = None

        # set to None if pool_ipv6 (nullable) is None
        # and model_fields_set contains the field
        if self.pool_ipv6 is None and "pool_ipv6" in self.model_fields_set:
            _dict['poolIPv6'] = None

        # set to None if no_proxy (nullable) is None
        # and model_fields_set contains the field
        if self.no_proxy is None and "no_proxy" in self.model_fields_set:
            _dict['noProxy'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateNetworksRequestNetwork from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "displayName": obj.get("displayName"),
            "labels": obj.get("labels"),
            "description": obj.get("description"),
            "site": CreateNetworksRequestNetworkSite.from_dict(obj["site"]) if obj.get("site") is not None else None,
            "zone": CreateNetworksRequestNetworkZone.from_dict(obj["zone"]) if obj.get("zone") is not None else None,
            "type": CreateNetworksRequestNetworkType.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "ipv4Enabled": obj.get("ipv4Enabled"),
            "ipv6Enabled": obj.get("ipv6Enabled"),
            "cidr": obj.get("cidr"),
            "gateway": obj.get("gateway"),
            "dnsPrimary": obj.get("dnsPrimary"),
            "dnsSecondary": obj.get("dnsSecondary"),
            "gatewayIPv6": obj.get("gatewayIPv6"),
            "netmaskIPv6": obj.get("netmaskIPv6"),
            "dnsPrimaryIPv6": obj.get("dnsPrimaryIPv6"),
            "dnsSecondaryIPv6": obj.get("dnsSecondaryIPv6"),
            "cidrIPv6": obj.get("cidrIPv6"),
            "vlanId": obj.get("vlanId"),
            "pool": obj.get("pool"),
            "poolIPv6": obj.get("poolIPv6"),
            "allowStaticOverride": obj.get("allowStaticOverride"),
            "assignPublicIp": obj.get("assignPublicIp"),
            "active": obj.get("active"),
            "dhcpServer": obj.get("dhcpServer"),
            "dhcpServerIPv6": obj.get("dhcpServerIPv6"),
            "networkDomain": ListNetworks200ResponseAllOfNetworksInnerNetworkDomain.from_dict(obj["networkDomain"]) if obj.get("networkDomain") is not None else None,
            "searchDomains": obj.get("searchDomains"),
            "networkProxy": ListNetworks200ResponseAllOfNetworksInnerNetworkProxy.from_dict(obj["networkProxy"]) if obj.get("networkProxy") is not None else None,
            "applianceUrlProxyBypass": obj.get("applianceUrlProxyBypass"),
            "noProxy": obj.get("noProxy"),
            "visibility": obj.get("visibility") if obj.get("visibility") is not None else 'private',
            "config": CreateNetworksRequestNetworkConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "tenants": [GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(_item) for _item in obj["tenants"]] if obj.get("tenants") is not None else None,
            "resourcePermissions": CreateNetworksRequestNetworkResourcePermissions.from_dict(obj["resourcePermissions"]) if obj.get("resourcePermissions") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


