# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from morpheus.models.get_alerts200_response_all_of_checks_inner_check_type import GetAlerts200ResponseAllOfChecksInnerCheckType
from morpheus.models.get_alerts200_response_all_of_checks_inner_config import GetAlerts200ResponseAllOfChecksInnerConfig
from morpheus.models.list_activity200_response_all_of_activity_inner_activity_inner_user import ListActivity200ResponseAllOfActivityInnerActivityInnerUser
from typing import Optional, Set
from typing_extensions import Self

class GetAlerts200ResponseAllOfChecksInner(BaseModel):
    """
    GetAlerts200ResponseAllOfChecksInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    account: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = None
    active: Optional[StrictBool] = None
    api_key: Optional[StrictStr] = Field(default=None, alias="apiKey")
    availability: Optional[Union[StrictFloat, StrictInt]] = None
    check_agent: Optional[StrictStr] = Field(default=None, alias="checkAgent")
    check_interval: Optional[StrictInt] = Field(default=None, alias="checkInterval")
    check_spec: Optional[StrictStr] = Field(default=None, alias="checkSpec")
    check_type: Optional[GetAlerts200ResponseAllOfChecksInnerCheckType] = Field(default=None, alias="checkType")
    config: Optional[GetAlerts200ResponseAllOfChecksInnerConfig] = None
    container: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = None
    create_incident: Optional[StrictBool] = Field(default=None, alias="createIncident")
    muted: Optional[StrictBool] = None
    created_by: Optional[ListActivity200ResponseAllOfActivityInnerActivityInnerUser] = Field(default=None, alias="createdBy")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    description: Optional[StrictStr] = None
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    health: Optional[StrictInt] = None
    in_uptime: Optional[StrictBool] = Field(default=None, alias="inUptime")
    last_box_stats: Optional[StrictStr] = Field(default=None, alias="lastBoxStats")
    last_check_status: Optional[StrictStr] = Field(default=None, alias="lastCheckStatus")
    last_error: Optional[StrictStr] = Field(default=None, alias="lastError")
    last_error_date: Optional[datetime] = Field(default=None, alias="lastErrorDate")
    last_message: Optional[StrictStr] = Field(default=None, alias="lastMessage")
    last_metric: Optional[StrictStr] = Field(default=None, alias="lastMetric")
    last_run_date: Optional[datetime] = Field(default=None, alias="lastRunDate")
    last_stats: Optional[StrictStr] = Field(default=None, alias="lastStats")
    last_success_date: Optional[datetime] = Field(default=None, alias="lastSuccessDate")
    last_timer: Optional[StrictInt] = Field(default=None, alias="lastTimer")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    last_warning_date: Optional[datetime] = Field(default=None, alias="lastWarningDate")
    name: Optional[StrictStr] = None
    next_run_date: Optional[datetime] = Field(default=None, alias="nextRunDate")
    outage_time: Optional[StrictInt] = Field(default=None, alias="outageTime")
    severity: Optional[StrictStr] = None
    start_date: Optional[datetime] = Field(default=None, alias="startDate")
    deleted: Optional[StrictBool] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "account", "active", "apiKey", "availability", "checkAgent", "checkInterval", "checkSpec", "checkType", "config", "container", "createIncident", "muted", "createdBy", "dateCreated", "description", "endDate", "health", "inUptime", "lastBoxStats", "lastCheckStatus", "lastError", "lastErrorDate", "lastMessage", "lastMetric", "lastRunDate", "lastStats", "lastSuccessDate", "lastTimer", "lastUpdated", "lastWarningDate", "name", "nextRunDate", "outageTime", "severity", "startDate", "deleted"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetAlerts200ResponseAllOfChecksInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of check_type
        if self.check_type:
            _dict['checkType'] = self.check_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of container
        if self.container:
            _dict['container'] = self.container.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if check_agent (nullable) is None
        # and model_fields_set contains the field
        if self.check_agent is None and "check_agent" in self.model_fields_set:
            _dict['checkAgent'] = None

        # set to None if check_interval (nullable) is None
        # and model_fields_set contains the field
        if self.check_interval is None and "check_interval" in self.model_fields_set:
            _dict['checkInterval'] = None

        # set to None if check_spec (nullable) is None
        # and model_fields_set contains the field
        if self.check_spec is None and "check_spec" in self.model_fields_set:
            _dict['checkSpec'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if end_date (nullable) is None
        # and model_fields_set contains the field
        if self.end_date is None and "end_date" in self.model_fields_set:
            _dict['endDate'] = None

        # set to None if last_box_stats (nullable) is None
        # and model_fields_set contains the field
        if self.last_box_stats is None and "last_box_stats" in self.model_fields_set:
            _dict['lastBoxStats'] = None

        # set to None if last_check_status (nullable) is None
        # and model_fields_set contains the field
        if self.last_check_status is None and "last_check_status" in self.model_fields_set:
            _dict['lastCheckStatus'] = None

        # set to None if last_error (nullable) is None
        # and model_fields_set contains the field
        if self.last_error is None and "last_error" in self.model_fields_set:
            _dict['lastError'] = None

        # set to None if last_error_date (nullable) is None
        # and model_fields_set contains the field
        if self.last_error_date is None and "last_error_date" in self.model_fields_set:
            _dict['lastErrorDate'] = None

        # set to None if last_message (nullable) is None
        # and model_fields_set contains the field
        if self.last_message is None and "last_message" in self.model_fields_set:
            _dict['lastMessage'] = None

        # set to None if last_metric (nullable) is None
        # and model_fields_set contains the field
        if self.last_metric is None and "last_metric" in self.model_fields_set:
            _dict['lastMetric'] = None

        # set to None if last_run_date (nullable) is None
        # and model_fields_set contains the field
        if self.last_run_date is None and "last_run_date" in self.model_fields_set:
            _dict['lastRunDate'] = None

        # set to None if last_stats (nullable) is None
        # and model_fields_set contains the field
        if self.last_stats is None and "last_stats" in self.model_fields_set:
            _dict['lastStats'] = None

        # set to None if last_success_date (nullable) is None
        # and model_fields_set contains the field
        if self.last_success_date is None and "last_success_date" in self.model_fields_set:
            _dict['lastSuccessDate'] = None

        # set to None if last_timer (nullable) is None
        # and model_fields_set contains the field
        if self.last_timer is None and "last_timer" in self.model_fields_set:
            _dict['lastTimer'] = None

        # set to None if last_updated (nullable) is None
        # and model_fields_set contains the field
        if self.last_updated is None and "last_updated" in self.model_fields_set:
            _dict['lastUpdated'] = None

        # set to None if last_warning_date (nullable) is None
        # and model_fields_set contains the field
        if self.last_warning_date is None and "last_warning_date" in self.model_fields_set:
            _dict['lastWarningDate'] = None

        # set to None if next_run_date (nullable) is None
        # and model_fields_set contains the field
        if self.next_run_date is None and "next_run_date" in self.model_fields_set:
            _dict['nextRunDate'] = None

        # set to None if start_date (nullable) is None
        # and model_fields_set contains the field
        if self.start_date is None and "start_date" in self.model_fields_set:
            _dict['startDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetAlerts200ResponseAllOfChecksInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "account": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "active": obj.get("active"),
            "apiKey": obj.get("apiKey"),
            "availability": obj.get("availability"),
            "checkAgent": obj.get("checkAgent"),
            "checkInterval": obj.get("checkInterval"),
            "checkSpec": obj.get("checkSpec"),
            "checkType": GetAlerts200ResponseAllOfChecksInnerCheckType.from_dict(obj["checkType"]) if obj.get("checkType") is not None else None,
            "config": GetAlerts200ResponseAllOfChecksInnerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "container": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["container"]) if obj.get("container") is not None else None,
            "createIncident": obj.get("createIncident"),
            "muted": obj.get("muted"),
            "createdBy": ListActivity200ResponseAllOfActivityInnerActivityInnerUser.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None,
            "dateCreated": obj.get("dateCreated"),
            "description": obj.get("description"),
            "endDate": obj.get("endDate"),
            "health": obj.get("health"),
            "inUptime": obj.get("inUptime"),
            "lastBoxStats": obj.get("lastBoxStats"),
            "lastCheckStatus": obj.get("lastCheckStatus"),
            "lastError": obj.get("lastError"),
            "lastErrorDate": obj.get("lastErrorDate"),
            "lastMessage": obj.get("lastMessage"),
            "lastMetric": obj.get("lastMetric"),
            "lastRunDate": obj.get("lastRunDate"),
            "lastStats": obj.get("lastStats"),
            "lastSuccessDate": obj.get("lastSuccessDate"),
            "lastTimer": obj.get("lastTimer"),
            "lastUpdated": obj.get("lastUpdated"),
            "lastWarningDate": obj.get("lastWarningDate"),
            "name": obj.get("name"),
            "nextRunDate": obj.get("nextRunDate"),
            "outageTime": obj.get("outageTime"),
            "severity": obj.get("severity"),
            "startDate": obj.get("startDate"),
            "deleted": obj.get("deleted")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


