# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_app_state200_response_all_of_input import GetAppState200ResponseAllOfInput
from morpheus.models.get_app_state200_response_all_of_output import GetAppState200ResponseAllOfOutput
from morpheus.models.get_app_state200_response_all_of_specs_inner import GetAppState200ResponseAllOfSpecsInner
from morpheus.models.get_app_state200_response_all_of_workloads_inner import GetAppState200ResponseAllOfWorkloadsInner
from typing import Optional, Set
from typing_extensions import Self

class GetAppState200Response(BaseModel):
    """
    GetAppState200Response
    """ # noqa: E501
    workloads: Optional[List[GetAppState200ResponseAllOfWorkloadsInner]] = None
    iac_drift: Optional[StrictBool] = Field(default=None, alias="iacDrift")
    plan_resources: Optional[List[Dict[str, Any]]] = Field(default=None, alias="planResources")
    specs: Optional[List[GetAppState200ResponseAllOfSpecsInner]] = None
    state_data: Optional[StrictStr] = Field(default=None, alias="stateData")
    plan_data: Optional[StrictStr] = Field(default=None, alias="planData")
    input: Optional[GetAppState200ResponseAllOfInput] = None
    output: Optional[GetAppState200ResponseAllOfOutput] = None
    success: Optional[StrictBool] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["workloads", "iacDrift", "planResources", "specs", "stateData", "planData", "input", "output", "success"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetAppState200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in workloads (list)
        _items = []
        if self.workloads:
            for _item_workloads in self.workloads:
                if _item_workloads:
                    _items.append(_item_workloads.to_dict())
            _dict['workloads'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in specs (list)
        _items = []
        if self.specs:
            for _item_specs in self.specs:
                if _item_specs:
                    _items.append(_item_specs.to_dict())
            _dict['specs'] = _items
        # override the default output from pydantic by calling `to_dict()` of input
        if self.input:
            _dict['input'] = self.input.to_dict()
        # override the default output from pydantic by calling `to_dict()` of output
        if self.output:
            _dict['output'] = self.output.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetAppState200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "workloads": [GetAppState200ResponseAllOfWorkloadsInner.from_dict(_item) for _item in obj["workloads"]] if obj.get("workloads") is not None else None,
            "iacDrift": obj.get("iacDrift"),
            "planResources": obj.get("planResources"),
            "specs": [GetAppState200ResponseAllOfSpecsInner.from_dict(_item) for _item in obj["specs"]] if obj.get("specs") is not None else None,
            "stateData": obj.get("stateData"),
            "planData": obj.get("planData"),
            "input": GetAppState200ResponseAllOfInput.from_dict(obj["input"]) if obj.get("input") is not None else None,
            "output": GetAppState200ResponseAllOfOutput.from_dict(obj["output"]) if obj.get("output") is not None else None,
            "success": obj.get("success")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


