# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from morpheus.models.get_approvals_item200_response_approval_item_reference import GetApprovalsItem200ResponseApprovalItemReference
from typing import Optional, Set
from typing_extensions import Self

class GetApprovalsItem200ResponseApprovalItem(BaseModel):
    """
    GetApprovalsItem200ResponseApprovalItem
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    external_name: Optional[StrictStr] = Field(default=None, alias="externalName")
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    approved_by: Optional[StrictStr] = Field(default=None, alias="approvedBy")
    denied_by: Optional[StrictStr] = Field(default=None, alias="deniedBy")
    status: Optional[StrictStr] = None
    error_message: Optional[StrictStr] = Field(default=None, alias="errorMessage")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    date_approved: Optional[datetime] = Field(default=None, alias="dateApproved")
    date_denied: Optional[datetime] = Field(default=None, alias="dateDenied")
    approval: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = None
    reference: Optional[GetApprovalsItem200ResponseApprovalItemReference] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "externalId", "externalName", "internalId", "approvedBy", "deniedBy", "status", "errorMessage", "dateCreated", "lastUpdated", "dateApproved", "dateDenied", "approval", "reference"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetApprovalsItem200ResponseApprovalItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of approval
        if self.approval:
            _dict['approval'] = self.approval.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reference
        if self.reference:
            _dict['reference'] = self.reference.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if external_name (nullable) is None
        # and model_fields_set contains the field
        if self.external_name is None and "external_name" in self.model_fields_set:
            _dict['externalName'] = None

        # set to None if internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_id is None and "internal_id" in self.model_fields_set:
            _dict['internalId'] = None

        # set to None if denied_by (nullable) is None
        # and model_fields_set contains the field
        if self.denied_by is None and "denied_by" in self.model_fields_set:
            _dict['deniedBy'] = None

        # set to None if error_message (nullable) is None
        # and model_fields_set contains the field
        if self.error_message is None and "error_message" in self.model_fields_set:
            _dict['errorMessage'] = None

        # set to None if date_denied (nullable) is None
        # and model_fields_set contains the field
        if self.date_denied is None and "date_denied" in self.model_fields_set:
            _dict['dateDenied'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetApprovalsItem200ResponseApprovalItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "externalId": obj.get("externalId"),
            "externalName": obj.get("externalName"),
            "internalId": obj.get("internalId"),
            "approvedBy": obj.get("approvedBy"),
            "deniedBy": obj.get("deniedBy"),
            "status": obj.get("status"),
            "errorMessage": obj.get("errorMessage"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "dateApproved": obj.get("dateApproved"),
            "dateDenied": obj.get("dateDenied"),
            "approval": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["approval"]) if obj.get("approval") is not None else None,
            "reference": GetApprovalsItem200ResponseApprovalItemReference.from_dict(obj["reference"]) if obj.get("reference") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


