# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from morpheus.models.get_billing_servers_identifier200_response_all_of_billing_info_usages_inner_applicable_prices_inner import GetBillingServersIdentifier200ResponseAllOfBillingInfoUsagesInnerApplicablePricesInner
from typing import Optional, Set
from typing_extensions import Self

class GetBillingServersIdentifier200ResponseAllOfBillingInfoUsagesInner(BaseModel):
    """
    GetBillingServersIdentifier200ResponseAllOfBillingInfoUsagesInner
    """ # noqa: E501
    cost: Optional[Union[StrictFloat, StrictInt]] = None
    price: Optional[Union[StrictFloat, StrictInt]] = None
    created_by_user: Optional[StrictStr] = Field(default=None, alias="createdByUser")
    created_by_user_id: Optional[StrictInt] = Field(default=None, alias="createdByUserId")
    site_id: Optional[StrictStr] = Field(default=None, alias="siteId")
    site_name: Optional[StrictStr] = Field(default=None, alias="siteName")
    site_uuid: Optional[StrictStr] = Field(default=None, alias="siteUUID")
    site_code: Optional[StrictStr] = Field(default=None, alias="siteCode")
    currency: Optional[StrictStr] = None
    start_date: Optional[datetime] = Field(default=None, alias="startDate")
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    status: Optional[StrictStr] = None
    tags: Optional[List[Dict[str, Any]]] = None
    applicable_prices: Optional[List[GetBillingServersIdentifier200ResponseAllOfBillingInfoUsagesInnerApplicablePricesInner]] = Field(default=None, alias="applicablePrices")
    service_plan_id: Optional[StrictInt] = Field(default=None, alias="servicePlanId")
    service_plan_name: Optional[StrictStr] = Field(default=None, alias="servicePlanName")
    resource_pool_id: Optional[StrictInt] = Field(default=None, alias="resourcePoolId")
    resource_pool_name: Optional[StrictStr] = Field(default=None, alias="resourcePoolName")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["cost", "price", "createdByUser", "createdByUserId", "siteId", "siteName", "siteUUID", "siteCode", "currency", "startDate", "endDate", "status", "tags", "applicablePrices", "servicePlanId", "servicePlanName", "resourcePoolId", "resourcePoolName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetBillingServersIdentifier200ResponseAllOfBillingInfoUsagesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in applicable_prices (list)
        _items = []
        if self.applicable_prices:
            for _item_applicable_prices in self.applicable_prices:
                if _item_applicable_prices:
                    _items.append(_item_applicable_prices.to_dict())
            _dict['applicablePrices'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if site_id (nullable) is None
        # and model_fields_set contains the field
        if self.site_id is None and "site_id" in self.model_fields_set:
            _dict['siteId'] = None

        # set to None if site_name (nullable) is None
        # and model_fields_set contains the field
        if self.site_name is None and "site_name" in self.model_fields_set:
            _dict['siteName'] = None

        # set to None if site_uuid (nullable) is None
        # and model_fields_set contains the field
        if self.site_uuid is None and "site_uuid" in self.model_fields_set:
            _dict['siteUUID'] = None

        # set to None if site_code (nullable) is None
        # and model_fields_set contains the field
        if self.site_code is None and "site_code" in self.model_fields_set:
            _dict['siteCode'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetBillingServersIdentifier200ResponseAllOfBillingInfoUsagesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cost": obj.get("cost"),
            "price": obj.get("price"),
            "createdByUser": obj.get("createdByUser"),
            "createdByUserId": obj.get("createdByUserId"),
            "siteId": obj.get("siteId"),
            "siteName": obj.get("siteName"),
            "siteUUID": obj.get("siteUUID"),
            "siteCode": obj.get("siteCode"),
            "currency": obj.get("currency"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "status": obj.get("status"),
            "tags": obj.get("tags"),
            "applicablePrices": [GetBillingServersIdentifier200ResponseAllOfBillingInfoUsagesInnerApplicablePricesInner.from_dict(_item) for _item in obj["applicablePrices"]] if obj.get("applicablePrices") is not None else None,
            "servicePlanId": obj.get("servicePlanId"),
            "servicePlanName": obj.get("servicePlanName"),
            "resourcePoolId": obj.get("resourcePoolId"),
            "resourcePoolName": obj.get("resourcePoolName")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


