# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_apps_inner import GetAlerts200ResponseAllOfAppsInner
from morpheus.models.get_alerts200_response_all_of_check_groups_inner import GetAlerts200ResponseAllOfCheckGroupsInner
from morpheus.models.get_alerts200_response_all_of_checks_inner import GetAlerts200ResponseAllOfChecksInner
from morpheus.models.get_check_apps200_response_open_incidents_inner import GetCheckApps200ResponseOpenIncidentsInner
from typing import Optional, Set
from typing_extensions import Self

class GetCheckApps200Response(BaseModel):
    """
    GetCheckApps200Response
    """ # noqa: E501
    monitor_app: Optional[GetAlerts200ResponseAllOfAppsInner] = Field(default=None, alias="monitorApp")
    check_groups: Optional[List[GetAlerts200ResponseAllOfCheckGroupsInner]] = Field(default=None, alias="checkGroups")
    checks: Optional[List[GetAlerts200ResponseAllOfChecksInner]] = None
    open_incidents: Optional[List[GetCheckApps200ResponseOpenIncidentsInner]] = Field(default=None, alias="openIncidents")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["monitorApp", "checkGroups", "checks", "openIncidents"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetCheckApps200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of monitor_app
        if self.monitor_app:
            _dict['monitorApp'] = self.monitor_app.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in check_groups (list)
        _items = []
        if self.check_groups:
            for _item_check_groups in self.check_groups:
                if _item_check_groups:
                    _items.append(_item_check_groups.to_dict())
            _dict['checkGroups'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in checks (list)
        _items = []
        if self.checks:
            for _item_checks in self.checks:
                if _item_checks:
                    _items.append(_item_checks.to_dict())
            _dict['checks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in open_incidents (list)
        _items = []
        if self.open_incidents:
            for _item_open_incidents in self.open_incidents:
                if _item_open_incidents:
                    _items.append(_item_open_incidents.to_dict())
            _dict['openIncidents'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetCheckApps200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "monitorApp": GetAlerts200ResponseAllOfAppsInner.from_dict(obj["monitorApp"]) if obj.get("monitorApp") is not None else None,
            "checkGroups": [GetAlerts200ResponseAllOfCheckGroupsInner.from_dict(_item) for _item in obj["checkGroups"]] if obj.get("checkGroups") is not None else None,
            "checks": [GetAlerts200ResponseAllOfChecksInner.from_dict(_item) for _item in obj["checks"]] if obj.get("checks") is not None else None,
            "openIncidents": [GetCheckApps200ResponseOpenIncidentsInner.from_dict(_item) for _item in obj["openIncidents"]] if obj.get("openIncidents") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


