# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class GetContainer200ResponseContainerPortsInner(BaseModel):
    """
    GetContainer200ResponseContainerPortsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    index: Optional[StrictInt] = None
    external: Optional[StrictInt] = None
    internal: Optional[StrictInt] = None
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    primary_port: Optional[StrictBool] = Field(default=None, alias="primaryPort")
    export: Optional[StrictBool] = None
    visible: Optional[StrictBool] = None
    export_name: Optional[StrictStr] = Field(default=None, alias="exportName")
    load_balance_protocol: Optional[StrictStr] = Field(default=None, alias="loadBalanceProtocol")
    load_balance: Optional[StrictBool] = Field(default=None, alias="loadBalance")
    protocol: Optional[StrictStr] = None
    link: Optional[StrictBool] = None
    external_ip: Optional[StrictStr] = Field(default=None, alias="externalIp")
    internal_ip: Optional[StrictStr] = Field(default=None, alias="internalIp")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "index", "external", "internal", "displayName", "primaryPort", "export", "visible", "exportName", "loadBalanceProtocol", "loadBalance", "protocol", "link", "externalIp", "internalIp"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetContainer200ResponseContainerPortsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if external_ip (nullable) is None
        # and model_fields_set contains the field
        if self.external_ip is None and "external_ip" in self.model_fields_set:
            _dict['externalIp'] = None

        # set to None if internal_ip (nullable) is None
        # and model_fields_set contains the field
        if self.internal_ip is None and "internal_ip" in self.model_fields_set:
            _dict['internalIp'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetContainer200ResponseContainerPortsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "index": obj.get("index"),
            "external": obj.get("external"),
            "internal": obj.get("internal"),
            "displayName": obj.get("displayName"),
            "primaryPort": obj.get("primaryPort"),
            "export": obj.get("export"),
            "visible": obj.get("visible"),
            "exportName": obj.get("exportName"),
            "loadBalanceProtocol": obj.get("loadBalanceProtocol"),
            "loadBalance": obj.get("loadBalance"),
            "protocol": obj.get("protocol"),
            "link": obj.get("link"),
            "externalIp": obj.get("externalIp"),
            "internalIp": obj.get("internalIp")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


