# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_instance_type_provisioning200_response_all_of_instance_type_instance_type_layouts_inner_container_types_inner_account import GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerAccount
from morpheus.models.list_instance_service_plans200_response_plans_inner_auto_options_inner import ListInstanceServicePlans200ResponsePlansInnerAutoOptionsInner
from typing import Optional, Set
from typing_extensions import Self

class GetNetworkFirewallRule200ResponseRule(BaseModel):
    """
    GetNetworkFirewallRule200ResponseRule
    """ # noqa: E501
    id: Optional[StrictInt] = None
    direction: Optional[StrictStr] = None
    source_type: Optional[StrictStr] = Field(default=None, alias="sourceType")
    destination_type: Optional[StrictStr] = Field(default=None, alias="destinationType")
    name: Optional[StrictStr] = None
    policy: Optional[StrictStr] = None
    priority: Optional[StrictInt] = None
    enabled: Optional[StrictBool] = None
    rule_group: Optional[GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerAccount] = Field(default=None, alias="ruleGroup")
    group_name: Optional[StrictStr] = Field(default=None, alias="groupName")
    config: Optional[Dict[str, Any]] = None
    sources: Optional[List[ListInstanceServicePlans200ResponsePlansInnerAutoOptionsInner]] = None
    destinations: Optional[List[ListInstanceServicePlans200ResponsePlansInnerAutoOptionsInner]] = None
    applications: Optional[List[ListInstanceServicePlans200ResponsePlansInnerAutoOptionsInner]] = None
    scopes: Optional[List[ListInstanceServicePlans200ResponsePlansInnerAutoOptionsInner]] = None
    profiles: Optional[List[ListInstanceServicePlans200ResponsePlansInnerAutoOptionsInner]] = None
    applied_targets: Optional[List[Dict[str, Any]]] = Field(default=None, alias="appliedTargets")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "direction", "sourceType", "destinationType", "name", "policy", "priority", "enabled", "ruleGroup", "groupName", "config", "sources", "destinations", "applications", "scopes", "profiles", "appliedTargets"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetNetworkFirewallRule200ResponseRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of rule_group
        if self.rule_group:
            _dict['ruleGroup'] = self.rule_group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in sources (list)
        _items = []
        if self.sources:
            for _item_sources in self.sources:
                if _item_sources:
                    _items.append(_item_sources.to_dict())
            _dict['sources'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in destinations (list)
        _items = []
        if self.destinations:
            for _item_destinations in self.destinations:
                if _item_destinations:
                    _items.append(_item_destinations.to_dict())
            _dict['destinations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in applications (list)
        _items = []
        if self.applications:
            for _item_applications in self.applications:
                if _item_applications:
                    _items.append(_item_applications.to_dict())
            _dict['applications'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in scopes (list)
        _items = []
        if self.scopes:
            for _item_scopes in self.scopes:
                if _item_scopes:
                    _items.append(_item_scopes.to_dict())
            _dict['scopes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in profiles (list)
        _items = []
        if self.profiles:
            for _item_profiles in self.profiles:
                if _item_profiles:
                    _items.append(_item_profiles.to_dict())
            _dict['profiles'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetNetworkFirewallRule200ResponseRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "direction": obj.get("direction"),
            "sourceType": obj.get("sourceType"),
            "destinationType": obj.get("destinationType"),
            "name": obj.get("name"),
            "policy": obj.get("policy"),
            "priority": obj.get("priority"),
            "enabled": obj.get("enabled"),
            "ruleGroup": GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerAccount.from_dict(obj["ruleGroup"]) if obj.get("ruleGroup") is not None else None,
            "groupName": obj.get("groupName"),
            "config": obj.get("config"),
            "sources": [ListInstanceServicePlans200ResponsePlansInnerAutoOptionsInner.from_dict(_item) for _item in obj["sources"]] if obj.get("sources") is not None else None,
            "destinations": [ListInstanceServicePlans200ResponsePlansInnerAutoOptionsInner.from_dict(_item) for _item in obj["destinations"]] if obj.get("destinations") is not None else None,
            "applications": [ListInstanceServicePlans200ResponsePlansInnerAutoOptionsInner.from_dict(_item) for _item in obj["applications"]] if obj.get("applications") is not None else None,
            "scopes": [ListInstanceServicePlans200ResponsePlansInnerAutoOptionsInner.from_dict(_item) for _item in obj["scopes"]] if obj.get("scopes") is not None else None,
            "profiles": [ListInstanceServicePlans200ResponsePlansInnerAutoOptionsInner.from_dict(_item) for _item in obj["profiles"]] if obj.get("profiles") is not None else None,
            "appliedTargets": obj.get("appliedTargets")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


