# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_network_router200_response_network_router_firewall_rule_groups_inner_rules_inner import GetNetworkRouter200ResponseNetworkRouterFirewallRuleGroupsInnerRulesInner
from typing import Optional, Set
from typing_extensions import Self

class GetNetworkRouter200ResponseNetworkRouterFirewallRuleGroupsInner(BaseModel):
    """
    GetNetworkRouter200ResponseNetworkRouterFirewallRuleGroupsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    iac_id: Optional[StrictStr] = Field(default=None, alias="iacId")
    zone: Optional[StrictStr] = None
    zone_pool: Optional[StrictStr] = Field(default=None, alias="zonePool")
    status: Optional[StrictStr] = None
    priority: Optional[StrictInt] = None
    group_layer: Optional[StrictStr] = Field(default=None, alias="groupLayer")
    rules: Optional[List[GetNetworkRouter200ResponseNetworkRouterFirewallRuleGroupsInnerRulesInner]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "description", "externalId", "iacId", "zone", "zonePool", "status", "priority", "groupLayer", "rules"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetNetworkRouter200ResponseNetworkRouterFirewallRuleGroupsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in rules (list)
        _items = []
        if self.rules:
            for _item_rules in self.rules:
                if _item_rules:
                    _items.append(_item_rules.to_dict())
            _dict['rules'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if iac_id (nullable) is None
        # and model_fields_set contains the field
        if self.iac_id is None and "iac_id" in self.model_fields_set:
            _dict['iacId'] = None

        # set to None if zone (nullable) is None
        # and model_fields_set contains the field
        if self.zone is None and "zone" in self.model_fields_set:
            _dict['zone'] = None

        # set to None if zone_pool (nullable) is None
        # and model_fields_set contains the field
        if self.zone_pool is None and "zone_pool" in self.model_fields_set:
            _dict['zonePool'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetNetworkRouter200ResponseNetworkRouterFirewallRuleGroupsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "externalId": obj.get("externalId"),
            "iacId": obj.get("iacId"),
            "zone": obj.get("zone"),
            "zonePool": obj.get("zonePool"),
            "status": obj.get("status"),
            "priority": obj.get("priority"),
            "groupLayer": obj.get("groupLayer"),
            "rules": [GetNetworkRouter200ResponseNetworkRouterFirewallRuleGroupsInnerRulesInner.from_dict(_item) for _item in obj["rules"]] if obj.get("rules") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


