# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_power_schedules200_response_all_of_instances_inner import GetPowerSchedules200ResponseAllOfInstancesInner
from morpheus.models.list_power_schedules200_response_all_of_schedules_inner import ListPowerSchedules200ResponseAllOfSchedulesInner
from typing import Optional, Set
from typing_extensions import Self

class GetPowerSchedules200Response(BaseModel):
    """
    GetPowerSchedules200Response
    """ # noqa: E501
    instances: Optional[List[GetPowerSchedules200ResponseAllOfInstancesInner]] = None
    servers: Optional[List[GetPowerSchedules200ResponseAllOfInstancesInner]] = None
    schedule: Optional[ListPowerSchedules200ResponseAllOfSchedulesInner] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["instances", "servers", "schedule"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetPowerSchedules200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in instances (list)
        _items = []
        if self.instances:
            for _item_instances in self.instances:
                if _item_instances:
                    _items.append(_item_instances.to_dict())
            _dict['instances'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in servers (list)
        _items = []
        if self.servers:
            for _item_servers in self.servers:
                if _item_servers:
                    _items.append(_item_servers.to_dict())
            _dict['servers'] = _items
        # override the default output from pydantic by calling `to_dict()` of schedule
        if self.schedule:
            _dict['schedule'] = self.schedule.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if instances (nullable) is None
        # and model_fields_set contains the field
        if self.instances is None and "instances" in self.model_fields_set:
            _dict['instances'] = None

        # set to None if servers (nullable) is None
        # and model_fields_set contains the field
        if self.servers is None and "servers" in self.model_fields_set:
            _dict['servers'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetPowerSchedules200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "instances": [GetPowerSchedules200ResponseAllOfInstancesInner.from_dict(_item) for _item in obj["instances"]] if obj.get("instances") is not None else None,
            "servers": [GetPowerSchedules200ResponseAllOfInstancesInner.from_dict(_item) for _item in obj["servers"]] if obj.get("servers") is not None else None,
            "schedule": ListPowerSchedules200ResponseAllOfSchedulesInner.from_dict(obj["schedule"]) if obj.get("schedule") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


