# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class GuidanceSettings(BaseModel):
    """
    GuidanceSettings
    """ # noqa: E501
    cpu_avg_cutoff_power: Optional[StrictInt] = Field(default=None, description="Power Shutdown Average CPU (%). Lower limit for average CPU usage", alias="cpuAvgCutoffPower")
    cpu_max_cutoff_power: Optional[StrictInt] = Field(default=None, description="Power Shutdown Maximum CPU (%). Lower limit for peak CPU usage", alias="cpuMaxCutoffPower")
    network_cutoff_power: Optional[StrictInt] = Field(default=None, description="Power Shutdown Network threshold (bytes). Lower limit for average network bandwidth", alias="networkCutoffPower")
    cpu_up_avg_standard_cutoff_right_size: Optional[StrictInt] = Field(default=None, description="CPU Up-size Average CPU (%). Upper limit for CPU usage", alias="cpuUpAvgStandardCutoffRightSize")
    cpu_up_max_standard_cutoff_right_size: Optional[StrictInt] = Field(default=None, description="CPU Up-size Maximum CPU (%). Upper limit for peak CPU usage", alias="cpuUpMaxStandardCutoffRightSize")
    memory_up_avg_standard_cutoff_right_size: Optional[StrictInt] = Field(default=None, description="Memory Up-size Minimum Free Memory (%). Lower limit for average free memory usage", alias="memoryUpAvgStandardCutoffRightSize")
    memory_down_avg_standard_cutoff_right_size: Optional[StrictInt] = Field(default=None, description="Memory Down-size Maximum Free Memory (%). Upper limit for average free memory", alias="memoryDownAvgStandardCutoffRightSize")
    memory_down_max_standard_cutoff_right_size: Optional[StrictInt] = Field(default=None, description="Memory Down-size Maximum Free Memory (%). Upper limit for peak memory usage", alias="memoryDownMaxStandardCutoffRightSize")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["cpuAvgCutoffPower", "cpuMaxCutoffPower", "networkCutoffPower", "cpuUpAvgStandardCutoffRightSize", "cpuUpMaxStandardCutoffRightSize", "memoryUpAvgStandardCutoffRightSize", "memoryDownAvgStandardCutoffRightSize", "memoryDownMaxStandardCutoffRightSize"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GuidanceSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if cpu_avg_cutoff_power (nullable) is None
        # and model_fields_set contains the field
        if self.cpu_avg_cutoff_power is None and "cpu_avg_cutoff_power" in self.model_fields_set:
            _dict['cpuAvgCutoffPower'] = None

        # set to None if cpu_max_cutoff_power (nullable) is None
        # and model_fields_set contains the field
        if self.cpu_max_cutoff_power is None and "cpu_max_cutoff_power" in self.model_fields_set:
            _dict['cpuMaxCutoffPower'] = None

        # set to None if network_cutoff_power (nullable) is None
        # and model_fields_set contains the field
        if self.network_cutoff_power is None and "network_cutoff_power" in self.model_fields_set:
            _dict['networkCutoffPower'] = None

        # set to None if cpu_up_avg_standard_cutoff_right_size (nullable) is None
        # and model_fields_set contains the field
        if self.cpu_up_avg_standard_cutoff_right_size is None and "cpu_up_avg_standard_cutoff_right_size" in self.model_fields_set:
            _dict['cpuUpAvgStandardCutoffRightSize'] = None

        # set to None if cpu_up_max_standard_cutoff_right_size (nullable) is None
        # and model_fields_set contains the field
        if self.cpu_up_max_standard_cutoff_right_size is None and "cpu_up_max_standard_cutoff_right_size" in self.model_fields_set:
            _dict['cpuUpMaxStandardCutoffRightSize'] = None

        # set to None if memory_up_avg_standard_cutoff_right_size (nullable) is None
        # and model_fields_set contains the field
        if self.memory_up_avg_standard_cutoff_right_size is None and "memory_up_avg_standard_cutoff_right_size" in self.model_fields_set:
            _dict['memoryUpAvgStandardCutoffRightSize'] = None

        # set to None if memory_down_avg_standard_cutoff_right_size (nullable) is None
        # and model_fields_set contains the field
        if self.memory_down_avg_standard_cutoff_right_size is None and "memory_down_avg_standard_cutoff_right_size" in self.model_fields_set:
            _dict['memoryDownAvgStandardCutoffRightSize'] = None

        # set to None if memory_down_max_standard_cutoff_right_size (nullable) is None
        # and model_fields_set contains the field
        if self.memory_down_max_standard_cutoff_right_size is None and "memory_down_max_standard_cutoff_right_size" in self.model_fields_set:
            _dict['memoryDownMaxStandardCutoffRightSize'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GuidanceSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cpuAvgCutoffPower": obj.get("cpuAvgCutoffPower"),
            "cpuMaxCutoffPower": obj.get("cpuMaxCutoffPower"),
            "networkCutoffPower": obj.get("networkCutoffPower"),
            "cpuUpAvgStandardCutoffRightSize": obj.get("cpuUpAvgStandardCutoffRightSize"),
            "cpuUpMaxStandardCutoffRightSize": obj.get("cpuUpMaxStandardCutoffRightSize"),
            "memoryUpAvgStandardCutoffRightSize": obj.get("memoryUpAvgStandardCutoffRightSize"),
            "memoryDownAvgStandardCutoffRightSize": obj.get("memoryDownAvgStandardCutoffRightSize"),
            "memoryDownMaxStandardCutoffRightSize": obj.get("memoryDownMaxStandardCutoffRightSize")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


