# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from morpheus.models.list_image_builds200_response_all_of_image_builds_inner_boot_script import ListImageBuilds200ResponseAllOfImageBuildsInnerBootScript
from morpheus.models.list_image_builds200_response_all_of_image_builds_inner_config import ListImageBuilds200ResponseAllOfImageBuildsInnerConfig
from morpheus.models.list_image_builds200_response_all_of_image_builds_inner_last_result import ListImageBuilds200ResponseAllOfImageBuildsInnerLastResult
from morpheus.models.list_image_builds200_response_all_of_image_builds_inner_scripts_inner import ListImageBuilds200ResponseAllOfImageBuildsInnerScriptsInner
from typing import Optional, Set
from typing_extensions import Self

class ImageBuilds(BaseModel):
    """
    ImageBuilds
    """ # noqa: E501
    id: Optional[StrictInt] = None
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = None
    site: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    zone: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    boot_script: Optional[ListImageBuilds200ResponseAllOfImageBuildsInnerBootScript] = Field(default=None, alias="bootScript")
    boot_command: Optional[StrictStr] = Field(default=None, alias="bootCommand")
    preseed_script: Optional[ListImageBuilds200ResponseAllOfImageBuildsInnerBootScript] = Field(default=None, alias="preseedScript")
    scripts: Optional[List[ListImageBuilds200ResponseAllOfImageBuildsInnerScriptsInner]] = None
    ssh_username: Optional[StrictStr] = Field(default=None, alias="sshUsername")
    ssh_password: Optional[StrictStr] = Field(default=None, alias="sshPassword")
    storage_provider: Optional[StrictStr] = Field(default=None, alias="storageProvider")
    build_output_name: Optional[StrictStr] = Field(default=None, alias="buildOutputName")
    conversion_formats: Optional[StrictStr] = Field(default=None, alias="conversionFormats")
    is_cloud_init: Optional[StrictBool] = Field(default=None, alias="isCloudInit")
    vm_tools_installed: Optional[StrictBool] = Field(default=None, alias="vmToolsInstalled")
    keep_results: Optional[StrictInt] = Field(default=None, alias="keepResults")
    config: Optional[ListImageBuilds200ResponseAllOfImageBuildsInnerConfig] = None
    last_result: Optional[ListImageBuilds200ResponseAllOfImageBuildsInnerLastResult] = Field(default=None, alias="lastResult")
    execution_count: Optional[StrictInt] = Field(default=None, alias="executionCount")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "account", "type", "site", "zone", "name", "description", "bootScript", "bootCommand", "preseedScript", "scripts", "sshUsername", "sshPassword", "storageProvider", "buildOutputName", "conversionFormats", "isCloudInit", "vmToolsInstalled", "keepResults", "config", "lastResult", "executionCount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ImageBuilds from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of site
        if self.site:
            _dict['site'] = self.site.to_dict()
        # override the default output from pydantic by calling `to_dict()` of zone
        if self.zone:
            _dict['zone'] = self.zone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of boot_script
        if self.boot_script:
            _dict['bootScript'] = self.boot_script.to_dict()
        # override the default output from pydantic by calling `to_dict()` of preseed_script
        if self.preseed_script:
            _dict['preseedScript'] = self.preseed_script.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in scripts (list)
        _items = []
        if self.scripts:
            for _item_scripts in self.scripts:
                if _item_scripts:
                    _items.append(_item_scripts.to_dict())
            _dict['scripts'] = _items
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_result
        if self.last_result:
            _dict['lastResult'] = self.last_result.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if boot_command (nullable) is None
        # and model_fields_set contains the field
        if self.boot_command is None and "boot_command" in self.model_fields_set:
            _dict['bootCommand'] = None

        # set to None if storage_provider (nullable) is None
        # and model_fields_set contains the field
        if self.storage_provider is None and "storage_provider" in self.model_fields_set:
            _dict['storageProvider'] = None

        # set to None if conversion_formats (nullable) is None
        # and model_fields_set contains the field
        if self.conversion_formats is None and "conversion_formats" in self.model_fields_set:
            _dict['conversionFormats'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ImageBuilds from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "type": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "site": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["site"]) if obj.get("site") is not None else None,
            "zone": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["zone"]) if obj.get("zone") is not None else None,
            "name": obj.get("name"),
            "description": obj.get("description"),
            "bootScript": ListImageBuilds200ResponseAllOfImageBuildsInnerBootScript.from_dict(obj["bootScript"]) if obj.get("bootScript") is not None else None,
            "bootCommand": obj.get("bootCommand"),
            "preseedScript": ListImageBuilds200ResponseAllOfImageBuildsInnerBootScript.from_dict(obj["preseedScript"]) if obj.get("preseedScript") is not None else None,
            "scripts": [ListImageBuilds200ResponseAllOfImageBuildsInnerScriptsInner.from_dict(_item) for _item in obj["scripts"]] if obj.get("scripts") is not None else None,
            "sshUsername": obj.get("sshUsername"),
            "sshPassword": obj.get("sshPassword"),
            "storageProvider": obj.get("storageProvider"),
            "buildOutputName": obj.get("buildOutputName"),
            "conversionFormats": obj.get("conversionFormats"),
            "isCloudInit": obj.get("isCloudInit"),
            "vmToolsInstalled": obj.get("vmToolsInstalled"),
            "keepResults": obj.get("keepResults"),
            "config": ListImageBuilds200ResponseAllOfImageBuildsInnerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "lastResult": ListImageBuilds200ResponseAllOfImageBuildsInnerLastResult.from_dict(obj["lastResult"]) if obj.get("lastResult") is not None else None,
            "executionCount": obj.get("executionCount")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


