# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_instance_types_provisioning200_response_all_of_instance_types_inner_instance_type_layouts_inner import ListInstanceTypesProvisioning200ResponseAllOfInstanceTypesInnerInstanceTypeLayoutsInner
from typing import Optional, Set
from typing_extensions import Self

class InstanceTypes(BaseModel):
    """
    InstanceTypes
    """ # noqa: E501
    id: Optional[StrictInt] = None
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    name: Optional[StrictStr] = None
    labels: Optional[List[StrictStr]] = None
    code: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    provision_type_code: Optional[StrictStr] = Field(default=None, alias="provisionTypeCode")
    category: Optional[StrictStr] = None
    active: Optional[StrictBool] = None
    environment_prefix: Optional[StrictStr] = Field(default=None, alias="environmentPrefix")
    visibility: Optional[StrictStr] = None
    featured: Optional[StrictBool] = None
    versions: Optional[List[StrictStr]] = None
    instance_type_layouts: Optional[List[ListInstanceTypesProvisioning200ResponseAllOfInstanceTypesInnerInstanceTypeLayoutsInner]] = Field(default=None, alias="instanceTypeLayouts")
    image_path: Optional[StrictStr] = Field(default=None, description="Logo image URL", alias="imagePath")
    dark_image_path: Optional[StrictStr] = Field(default=None, description="Dark logo image URL", alias="darkImagePath")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "account", "name", "labels", "code", "description", "provisionTypeCode", "category", "active", "environmentPrefix", "visibility", "featured", "versions", "instanceTypeLayouts", "imagePath", "darkImagePath"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InstanceTypes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in instance_type_layouts (list)
        _items = []
        if self.instance_type_layouts:
            for _item_instance_type_layouts in self.instance_type_layouts:
                if _item_instance_type_layouts:
                    _items.append(_item_instance_type_layouts.to_dict())
            _dict['instanceTypeLayouts'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if provision_type_code (nullable) is None
        # and model_fields_set contains the field
        if self.provision_type_code is None and "provision_type_code" in self.model_fields_set:
            _dict['provisionTypeCode'] = None

        # set to None if image_path (nullable) is None
        # and model_fields_set contains the field
        if self.image_path is None and "image_path" in self.model_fields_set:
            _dict['imagePath'] = None

        # set to None if dark_image_path (nullable) is None
        # and model_fields_set contains the field
        if self.dark_image_path is None and "dark_image_path" in self.model_fields_set:
            _dict['darkImagePath'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InstanceTypes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "name": obj.get("name"),
            "labels": obj.get("labels"),
            "code": obj.get("code"),
            "description": obj.get("description"),
            "provisionTypeCode": obj.get("provisionTypeCode"),
            "category": obj.get("category"),
            "active": obj.get("active"),
            "environmentPrefix": obj.get("environmentPrefix"),
            "visibility": obj.get("visibility"),
            "featured": obj.get("featured"),
            "versions": obj.get("versions"),
            "instanceTypeLayouts": [ListInstanceTypesProvisioning200ResponseAllOfInstanceTypesInnerInstanceTypeLayoutsInner.from_dict(_item) for _item in obj["instanceTypeLayouts"]] if obj.get("instanceTypeLayouts") is not None else None,
            "imagePath": obj.get("imagePath"),
            "darkImagePath": obj.get("darkImagePath")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


