# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_alerts200_response_all_of_alerts_inner_contacts_inner import ListAlerts200ResponseAllOfAlertsInnerContactsInner
from typing import Optional, Set
from typing_extensions import Self

class ListAlerts200ResponseAllOfAlertsInner(BaseModel):
    """
    ListAlerts200ResponseAllOfAlertsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    all_apps: Optional[StrictBool] = Field(default=None, alias="allApps")
    all_checks: Optional[StrictBool] = Field(default=None, alias="allChecks")
    all_groups: Optional[StrictBool] = Field(default=None, alias="allGroups")
    active: Optional[StrictBool] = None
    min_severity: Optional[StrictStr] = Field(default=None, alias="minSeverity")
    min_duration: Optional[StrictInt] = Field(default=None, alias="minDuration")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    checks: Optional[List[StrictInt]] = None
    check_groups: Optional[List[StrictInt]] = Field(default=None, alias="checkGroups")
    apps: Optional[List[StrictInt]] = None
    contacts: Optional[List[ListAlerts200ResponseAllOfAlertsInnerContactsInner]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "allApps", "allChecks", "allGroups", "active", "minSeverity", "minDuration", "dateCreated", "lastUpdated", "checks", "checkGroups", "apps", "contacts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListAlerts200ResponseAllOfAlertsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in contacts (list)
        _items = []
        if self.contacts:
            for _item_contacts in self.contacts:
                if _item_contacts:
                    _items.append(_item_contacts.to_dict())
            _dict['contacts'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if checks (nullable) is None
        # and model_fields_set contains the field
        if self.checks is None and "checks" in self.model_fields_set:
            _dict['checks'] = None

        # set to None if check_groups (nullable) is None
        # and model_fields_set contains the field
        if self.check_groups is None and "check_groups" in self.model_fields_set:
            _dict['checkGroups'] = None

        # set to None if apps (nullable) is None
        # and model_fields_set contains the field
        if self.apps is None and "apps" in self.model_fields_set:
            _dict['apps'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListAlerts200ResponseAllOfAlertsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "allApps": obj.get("allApps"),
            "allChecks": obj.get("allChecks"),
            "allGroups": obj.get("allGroups"),
            "active": obj.get("active"),
            "minSeverity": obj.get("minSeverity"),
            "minDuration": obj.get("minDuration"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "checks": obj.get("checks"),
            "checkGroups": obj.get("checkGroups"),
            "apps": obj.get("apps"),
            "contacts": [ListAlerts200ResponseAllOfAlertsInnerContactsInner.from_dict(_item) for _item in obj["contacts"]] if obj.get("contacts") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


