# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from typing import Optional, Set
from typing_extensions import Self

class ListApplianceSettings200ResponseApplianceSettings(BaseModel):
    """
    ListApplianceSettings200ResponseApplianceSettings
    """ # noqa: E501
    uuid: Optional[StrictStr] = None
    appliance_id: Optional[StrictStr] = Field(default=None, alias="applianceId")
    appliance_url: Optional[StrictStr] = Field(default=None, alias="applianceUrl")
    internal_appliance_url: Optional[StrictStr] = Field(default=None, alias="internalApplianceUrl")
    cors_allowed: Optional[StrictStr] = Field(default=None, alias="corsAllowed")
    registration_enabled: Optional[StrictBool] = Field(default=None, alias="registrationEnabled")
    default_role_id: Optional[StrictStr] = Field(default=None, alias="defaultRoleId")
    default_user_role_id: Optional[StrictStr] = Field(default=None, alias="defaultUserRoleId")
    docker_privileged_mode: Optional[StrictBool] = Field(default=None, alias="dockerPrivilegedMode")
    expire_pwd_days: Optional[StrictStr] = Field(default=None, alias="expirePwdDays")
    disable_after_attempts: Optional[StrictStr] = Field(default=None, alias="disableAfterAttempts")
    disable_after_days_inactive: Optional[StrictStr] = Field(default=None, alias="disableAfterDaysInactive")
    warn_user_days_before: Optional[StrictStr] = Field(default=None, alias="warnUserDaysBefore")
    smtp_mail_from: Optional[StrictStr] = Field(default=None, alias="smtpMailFrom")
    smtp_server: Optional[StrictStr] = Field(default=None, alias="smtpServer")
    smtp_port: Optional[StrictStr] = Field(default=None, alias="smtpPort")
    smtp_ssl: Optional[StrictBool] = Field(default=None, alias="smtpSSL")
    smtp_tls: Optional[StrictBool] = Field(default=None, alias="smtpTLS")
    smtp_user: Optional[StrictStr] = Field(default=None, alias="smtpUser")
    smtp_password: Optional[StrictStr] = Field(default=None, alias="smtpPassword")
    smtp_password_hash: Optional[StrictStr] = Field(default=None, alias="smtpPasswordHash")
    proxy_host: Optional[StrictStr] = Field(default=None, alias="proxyHost")
    proxy_port: Optional[StrictStr] = Field(default=None, alias="proxyPort")
    proxy_user: Optional[StrictStr] = Field(default=None, alias="proxyUser")
    proxy_password: Optional[StrictStr] = Field(default=None, alias="proxyPassword")
    proxy_password_hash: Optional[StrictStr] = Field(default=None, alias="proxyPasswordHash")
    proxy_domain: Optional[StrictStr] = Field(default=None, alias="proxyDomain")
    proxy_workstation: Optional[StrictStr] = Field(default=None, alias="proxyWorkstation")
    currency_provider: Optional[StrictStr] = Field(default=None, alias="currencyProvider")
    currency_key: Optional[StrictStr] = Field(default=None, alias="currencyKey")
    enabled_zone_types: Optional[List[GetAlerts200ResponseAllOfCheckGroupsInnerInstance]] = Field(default=None, alias="enabledZoneTypes")
    stats_retainment_period: Optional[StrictInt] = Field(default=None, alias="statsRetainmentPeriod")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["uuid", "applianceId", "applianceUrl", "internalApplianceUrl", "corsAllowed", "registrationEnabled", "defaultRoleId", "defaultUserRoleId", "dockerPrivilegedMode", "expirePwdDays", "disableAfterAttempts", "disableAfterDaysInactive", "warnUserDaysBefore", "smtpMailFrom", "smtpServer", "smtpPort", "smtpSSL", "smtpTLS", "smtpUser", "smtpPassword", "smtpPasswordHash", "proxyHost", "proxyPort", "proxyUser", "proxyPassword", "proxyPasswordHash", "proxyDomain", "proxyWorkstation", "currencyProvider", "currencyKey", "enabledZoneTypes", "statsRetainmentPeriod"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListApplianceSettings200ResponseApplianceSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in enabled_zone_types (list)
        _items = []
        if self.enabled_zone_types:
            for _item_enabled_zone_types in self.enabled_zone_types:
                if _item_enabled_zone_types:
                    _items.append(_item_enabled_zone_types.to_dict())
            _dict['enabledZoneTypes'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if default_user_role_id (nullable) is None
        # and model_fields_set contains the field
        if self.default_user_role_id is None and "default_user_role_id" in self.model_fields_set:
            _dict['defaultUserRoleId'] = None

        # set to None if expire_pwd_days (nullable) is None
        # and model_fields_set contains the field
        if self.expire_pwd_days is None and "expire_pwd_days" in self.model_fields_set:
            _dict['expirePwdDays'] = None

        # set to None if disable_after_attempts (nullable) is None
        # and model_fields_set contains the field
        if self.disable_after_attempts is None and "disable_after_attempts" in self.model_fields_set:
            _dict['disableAfterAttempts'] = None

        # set to None if disable_after_days_inactive (nullable) is None
        # and model_fields_set contains the field
        if self.disable_after_days_inactive is None and "disable_after_days_inactive" in self.model_fields_set:
            _dict['disableAfterDaysInactive'] = None

        # set to None if warn_user_days_before (nullable) is None
        # and model_fields_set contains the field
        if self.warn_user_days_before is None and "warn_user_days_before" in self.model_fields_set:
            _dict['warnUserDaysBefore'] = None

        # set to None if smtp_mail_from (nullable) is None
        # and model_fields_set contains the field
        if self.smtp_mail_from is None and "smtp_mail_from" in self.model_fields_set:
            _dict['smtpMailFrom'] = None

        # set to None if smtp_server (nullable) is None
        # and model_fields_set contains the field
        if self.smtp_server is None and "smtp_server" in self.model_fields_set:
            _dict['smtpServer'] = None

        # set to None if smtp_port (nullable) is None
        # and model_fields_set contains the field
        if self.smtp_port is None and "smtp_port" in self.model_fields_set:
            _dict['smtpPort'] = None

        # set to None if smtp_user (nullable) is None
        # and model_fields_set contains the field
        if self.smtp_user is None and "smtp_user" in self.model_fields_set:
            _dict['smtpUser'] = None

        # set to None if smtp_password (nullable) is None
        # and model_fields_set contains the field
        if self.smtp_password is None and "smtp_password" in self.model_fields_set:
            _dict['smtpPassword'] = None

        # set to None if smtp_password_hash (nullable) is None
        # and model_fields_set contains the field
        if self.smtp_password_hash is None and "smtp_password_hash" in self.model_fields_set:
            _dict['smtpPasswordHash'] = None

        # set to None if proxy_host (nullable) is None
        # and model_fields_set contains the field
        if self.proxy_host is None and "proxy_host" in self.model_fields_set:
            _dict['proxyHost'] = None

        # set to None if proxy_port (nullable) is None
        # and model_fields_set contains the field
        if self.proxy_port is None and "proxy_port" in self.model_fields_set:
            _dict['proxyPort'] = None

        # set to None if proxy_user (nullable) is None
        # and model_fields_set contains the field
        if self.proxy_user is None and "proxy_user" in self.model_fields_set:
            _dict['proxyUser'] = None

        # set to None if proxy_password (nullable) is None
        # and model_fields_set contains the field
        if self.proxy_password is None and "proxy_password" in self.model_fields_set:
            _dict['proxyPassword'] = None

        # set to None if proxy_password_hash (nullable) is None
        # and model_fields_set contains the field
        if self.proxy_password_hash is None and "proxy_password_hash" in self.model_fields_set:
            _dict['proxyPasswordHash'] = None

        # set to None if proxy_domain (nullable) is None
        # and model_fields_set contains the field
        if self.proxy_domain is None and "proxy_domain" in self.model_fields_set:
            _dict['proxyDomain'] = None

        # set to None if proxy_workstation (nullable) is None
        # and model_fields_set contains the field
        if self.proxy_workstation is None and "proxy_workstation" in self.model_fields_set:
            _dict['proxyWorkstation'] = None

        # set to None if currency_provider (nullable) is None
        # and model_fields_set contains the field
        if self.currency_provider is None and "currency_provider" in self.model_fields_set:
            _dict['currencyProvider'] = None

        # set to None if currency_key (nullable) is None
        # and model_fields_set contains the field
        if self.currency_key is None and "currency_key" in self.model_fields_set:
            _dict['currencyKey'] = None

        # set to None if enabled_zone_types (nullable) is None
        # and model_fields_set contains the field
        if self.enabled_zone_types is None and "enabled_zone_types" in self.model_fields_set:
            _dict['enabledZoneTypes'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListApplianceSettings200ResponseApplianceSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "uuid": obj.get("uuid"),
            "applianceId": obj.get("applianceId"),
            "applianceUrl": obj.get("applianceUrl"),
            "internalApplianceUrl": obj.get("internalApplianceUrl"),
            "corsAllowed": obj.get("corsAllowed"),
            "registrationEnabled": obj.get("registrationEnabled"),
            "defaultRoleId": obj.get("defaultRoleId"),
            "defaultUserRoleId": obj.get("defaultUserRoleId"),
            "dockerPrivilegedMode": obj.get("dockerPrivilegedMode"),
            "expirePwdDays": obj.get("expirePwdDays"),
            "disableAfterAttempts": obj.get("disableAfterAttempts"),
            "disableAfterDaysInactive": obj.get("disableAfterDaysInactive"),
            "warnUserDaysBefore": obj.get("warnUserDaysBefore"),
            "smtpMailFrom": obj.get("smtpMailFrom"),
            "smtpServer": obj.get("smtpServer"),
            "smtpPort": obj.get("smtpPort"),
            "smtpSSL": obj.get("smtpSSL"),
            "smtpTLS": obj.get("smtpTLS"),
            "smtpUser": obj.get("smtpUser"),
            "smtpPassword": obj.get("smtpPassword"),
            "smtpPasswordHash": obj.get("smtpPasswordHash"),
            "proxyHost": obj.get("proxyHost"),
            "proxyPort": obj.get("proxyPort"),
            "proxyUser": obj.get("proxyUser"),
            "proxyPassword": obj.get("proxyPassword"),
            "proxyPasswordHash": obj.get("proxyPasswordHash"),
            "proxyDomain": obj.get("proxyDomain"),
            "proxyWorkstation": obj.get("proxyWorkstation"),
            "currencyProvider": obj.get("currencyProvider"),
            "currencyKey": obj.get("currencyKey"),
            "enabledZoneTypes": [GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(_item) for _item in obj["enabledZoneTypes"]] if obj.get("enabledZoneTypes") is not None else None,
            "statsRetainmentPeriod": obj.get("statsRetainmentPeriod")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


