# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from morpheus.models.list_cloud_datastores200_response_all_of_datastores_inner_resource_permission_sites_inner import ListCloudDatastores200ResponseAllOfDatastoresInnerResourcePermissionSitesInner
from typing import Optional, Set
from typing_extensions import Self

class ListClusterDatastores200ResponseAllOfDatastoresInnerResourcePermissions(BaseModel):
    """
    ListClusterDatastores200ResponseAllOfDatastoresInnerResourcePermissions
    """ # noqa: E501
    default_store: Optional[StrictBool] = Field(default=None, alias="defaultStore")
    all_plans: Optional[StrictBool] = Field(default=None, alias="allPlans")
    default_target: Optional[StrictBool] = Field(default=None, alias="defaultTarget")
    can_manage: Optional[StrictBool] = Field(default=None, alias="canManage")
    all: Optional[StrictBool] = None
    account: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = None
    sites: Optional[List[ListCloudDatastores200ResponseAllOfDatastoresInnerResourcePermissionSitesInner]] = None
    plans: Optional[List[ListCloudDatastores200ResponseAllOfDatastoresInnerResourcePermissionSitesInner]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["defaultStore", "allPlans", "defaultTarget", "canManage", "all", "account", "sites", "plans"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListClusterDatastores200ResponseAllOfDatastoresInnerResourcePermissions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in sites (list)
        _items = []
        if self.sites:
            for _item_sites in self.sites:
                if _item_sites:
                    _items.append(_item_sites.to_dict())
            _dict['sites'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in plans (list)
        _items = []
        if self.plans:
            for _item_plans in self.plans:
                if _item_plans:
                    _items.append(_item_plans.to_dict())
            _dict['plans'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if sites (nullable) is None
        # and model_fields_set contains the field
        if self.sites is None and "sites" in self.model_fields_set:
            _dict['sites'] = None

        # set to None if plans (nullable) is None
        # and model_fields_set contains the field
        if self.plans is None and "plans" in self.model_fields_set:
            _dict['plans'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListClusterDatastores200ResponseAllOfDatastoresInnerResourcePermissions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "defaultStore": obj.get("defaultStore"),
            "allPlans": obj.get("allPlans"),
            "defaultTarget": obj.get("defaultTarget"),
            "canManage": obj.get("canManage"),
            "all": obj.get("all"),
            "account": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "sites": [ListCloudDatastores200ResponseAllOfDatastoresInnerResourcePermissionSitesInner.from_dict(_item) for _item in obj["sites"]] if obj.get("sites") is not None else None,
            "plans": [ListCloudDatastores200ResponseAllOfDatastoresInnerResourcePermissionSitesInner.from_dict(_item) for _item in obj["plans"]] if obj.get("plans") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


