# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_cluster_layouts200_response_all_of_layouts_inner_compute_servers_inner_compute_server_type import ListClusterLayouts200ResponseAllOfLayoutsInnerComputeServersInnerComputeServerType
from morpheus.models.list_cluster_layouts200_response_all_of_layouts_inner_compute_servers_inner_container_type import ListClusterLayouts200ResponseAllOfLayoutsInnerComputeServersInnerContainerType
from typing import Optional, Set
from typing_extensions import Self

class ListClusterLayouts200ResponseAllOfLayoutsInnerComputeServersInner(BaseModel):
    """
    ListClusterLayouts200ResponseAllOfLayoutsInnerComputeServersInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    priority_order: Optional[StrictInt] = Field(default=None, alias="priorityOrder")
    node_count: Optional[StrictInt] = Field(default=None, alias="nodeCount")
    node_type: Optional[StrictStr] = Field(default=None, alias="nodeType")
    min_node_count: Optional[StrictInt] = Field(default=None, alias="minNodeCount")
    max_node_count: Optional[StrictStr] = Field(default=None, alias="maxNodeCount")
    dynamic_count: Optional[StrictBool] = Field(default=None, alias="dynamicCount")
    install_container_runtime: Optional[StrictBool] = Field(default=None, alias="installContainerRuntime")
    install_storage_runtime: Optional[StrictBool] = Field(default=None, alias="installStorageRuntime")
    name: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    category: Optional[StrictStr] = None
    config: Optional[StrictStr] = None
    container_type: Optional[ListClusterLayouts200ResponseAllOfLayoutsInnerComputeServersInnerContainerType] = Field(default=None, alias="containerType")
    compute_server_type: Optional[ListClusterLayouts200ResponseAllOfLayoutsInnerComputeServersInnerComputeServerType] = Field(default=None, alias="computeServerType")
    provision_service: Optional[StrictStr] = Field(default=None, alias="provisionService")
    plan_category: Optional[StrictStr] = Field(default=None, alias="planCategory")
    name_prefix: Optional[StrictStr] = Field(default=None, alias="namePrefix")
    name_suffix: Optional[StrictStr] = Field(default=None, alias="nameSuffix")
    force_name_index: Optional[StrictBool] = Field(default=None, alias="forceNameIndex")
    load_balance: Optional[StrictBool] = Field(default=None, alias="loadBalance")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "priorityOrder", "nodeCount", "nodeType", "minNodeCount", "maxNodeCount", "dynamicCount", "installContainerRuntime", "installStorageRuntime", "name", "code", "category", "config", "containerType", "computeServerType", "provisionService", "planCategory", "namePrefix", "nameSuffix", "forceNameIndex", "loadBalance"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListClusterLayouts200ResponseAllOfLayoutsInnerComputeServersInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of container_type
        if self.container_type:
            _dict['containerType'] = self.container_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of compute_server_type
        if self.compute_server_type:
            _dict['computeServerType'] = self.compute_server_type.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if max_node_count (nullable) is None
        # and model_fields_set contains the field
        if self.max_node_count is None and "max_node_count" in self.model_fields_set:
            _dict['maxNodeCount'] = None

        # set to None if config (nullable) is None
        # and model_fields_set contains the field
        if self.config is None and "config" in self.model_fields_set:
            _dict['config'] = None

        # set to None if provision_service (nullable) is None
        # and model_fields_set contains the field
        if self.provision_service is None and "provision_service" in self.model_fields_set:
            _dict['provisionService'] = None

        # set to None if plan_category (nullable) is None
        # and model_fields_set contains the field
        if self.plan_category is None and "plan_category" in self.model_fields_set:
            _dict['planCategory'] = None

        # set to None if name_prefix (nullable) is None
        # and model_fields_set contains the field
        if self.name_prefix is None and "name_prefix" in self.model_fields_set:
            _dict['namePrefix'] = None

        # set to None if name_suffix (nullable) is None
        # and model_fields_set contains the field
        if self.name_suffix is None and "name_suffix" in self.model_fields_set:
            _dict['nameSuffix'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListClusterLayouts200ResponseAllOfLayoutsInnerComputeServersInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "priorityOrder": obj.get("priorityOrder"),
            "nodeCount": obj.get("nodeCount"),
            "nodeType": obj.get("nodeType"),
            "minNodeCount": obj.get("minNodeCount"),
            "maxNodeCount": obj.get("maxNodeCount"),
            "dynamicCount": obj.get("dynamicCount"),
            "installContainerRuntime": obj.get("installContainerRuntime"),
            "installStorageRuntime": obj.get("installStorageRuntime"),
            "name": obj.get("name"),
            "code": obj.get("code"),
            "category": obj.get("category"),
            "config": obj.get("config"),
            "containerType": ListClusterLayouts200ResponseAllOfLayoutsInnerComputeServersInnerContainerType.from_dict(obj["containerType"]) if obj.get("containerType") is not None else None,
            "computeServerType": ListClusterLayouts200ResponseAllOfLayoutsInnerComputeServersInnerComputeServerType.from_dict(obj["computeServerType"]) if obj.get("computeServerType") is not None else None,
            "provisionService": obj.get("provisionService"),
            "planCategory": obj.get("planCategory"),
            "namePrefix": obj.get("namePrefix"),
            "nameSuffix": obj.get("nameSuffix"),
            "forceNameIndex": obj.get("forceNameIndex"),
            "loadBalance": obj.get("loadBalance")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


