# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from typing import Optional, Set
from typing_extensions import Self

class ListClusterPackages200ResponseAllOfClusterPackagesInner(BaseModel):
    """
    ListClusterPackages200ResponseAllOfClusterPackagesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    account: Optional[StrictInt] = None
    code: Optional[StrictStr] = None
    repeat_install: Optional[StrictBool] = Field(default=None, alias="repeatInstall")
    type: Optional[StrictStr] = None
    package_type: Optional[StrictStr] = Field(default=None, alias="packageType")
    package_version: Optional[StrictStr] = Field(default=None, alias="packageVersion")
    enabled: Optional[StrictBool] = None
    icon_path: Optional[StrictStr] = Field(default=None, alias="iconPath")
    image_path: Optional[StrictStr] = Field(default=None, alias="imagePath")
    dark_image_path: Optional[StrictStr] = Field(default=None, alias="darkImagePath")
    spec_templates: Optional[List[ListBackupSettings200ResponseBackupSettingsDefaultSchedule]] = Field(default=None, alias="specTemplates")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "description", "account", "code", "repeatInstall", "type", "packageType", "packageVersion", "enabled", "iconPath", "imagePath", "darkImagePath", "specTemplates"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListClusterPackages200ResponseAllOfClusterPackagesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in spec_templates (list)
        _items = []
        if self.spec_templates:
            for _item_spec_templates in self.spec_templates:
                if _item_spec_templates:
                    _items.append(_item_spec_templates.to_dict())
            _dict['specTemplates'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if account (nullable) is None
        # and model_fields_set contains the field
        if self.account is None and "account" in self.model_fields_set:
            _dict['account'] = None

        # set to None if icon_path (nullable) is None
        # and model_fields_set contains the field
        if self.icon_path is None and "icon_path" in self.model_fields_set:
            _dict['iconPath'] = None

        # set to None if image_path (nullable) is None
        # and model_fields_set contains the field
        if self.image_path is None and "image_path" in self.model_fields_set:
            _dict['imagePath'] = None

        # set to None if dark_image_path (nullable) is None
        # and model_fields_set contains the field
        if self.dark_image_path is None and "dark_image_path" in self.model_fields_set:
            _dict['darkImagePath'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListClusterPackages200ResponseAllOfClusterPackagesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "account": obj.get("account"),
            "code": obj.get("code"),
            "repeatInstall": obj.get("repeatInstall"),
            "type": obj.get("type"),
            "packageType": obj.get("packageType"),
            "packageVersion": obj.get("packageVersion"),
            "enabled": obj.get("enabled"),
            "iconPath": obj.get("iconPath"),
            "imagePath": obj.get("imagePath"),
            "darkImagePath": obj.get("darkImagePath"),
            "specTemplates": [ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(_item) for _item in obj["specTemplates"]] if obj.get("specTemplates") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


