# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from typing import Optional, Set
from typing_extensions import Self

class ListClusterReplicasets200ResponseAllOfReplicasetsInner(BaseModel):
    """
    ListClusterReplicasets200ResponseAllOfReplicasetsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    category: Optional[StrictStr] = None
    resource_level: Optional[StrictStr] = Field(default=None, alias="resourceLevel")
    resource_type: Optional[StrictStr] = Field(default=None, alias="resourceType")
    managed: Optional[StrictBool] = None
    status: Optional[StrictStr] = None
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    owner: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = None
    total_cpu_usage: Optional[StrictInt] = Field(default=None, alias="totalCpuUsage")
    stats: Optional[Dict[str, Any]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "code", "description", "category", "resourceLevel", "resourceType", "managed", "status", "lastUpdated", "owner", "totalCpuUsage", "stats"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListClusterReplicasets200ResponseAllOfReplicasetsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if resource_level (nullable) is None
        # and model_fields_set contains the field
        if self.resource_level is None and "resource_level" in self.model_fields_set:
            _dict['resourceLevel'] = None

        # set to None if managed (nullable) is None
        # and model_fields_set contains the field
        if self.managed is None and "managed" in self.model_fields_set:
            _dict['managed'] = None

        # set to None if last_updated (nullable) is None
        # and model_fields_set contains the field
        if self.last_updated is None and "last_updated" in self.model_fields_set:
            _dict['lastUpdated'] = None

        # set to None if total_cpu_usage (nullable) is None
        # and model_fields_set contains the field
        if self.total_cpu_usage is None and "total_cpu_usage" in self.model_fields_set:
            _dict['totalCpuUsage'] = None

        # set to None if stats (nullable) is None
        # and model_fields_set contains the field
        if self.stats is None and "stats" in self.model_fields_set:
            _dict['stats'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListClusterReplicasets200ResponseAllOfReplicasetsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "code": obj.get("code"),
            "description": obj.get("description"),
            "category": obj.get("category"),
            "resourceLevel": obj.get("resourceLevel"),
            "resourceType": obj.get("resourceType"),
            "managed": obj.get("managed"),
            "status": obj.get("status"),
            "lastUpdated": obj.get("lastUpdated"),
            "owner": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "totalCpuUsage": obj.get("totalCpuUsage"),
            "stats": obj.get("stats")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


