# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ListCypherKeys200ResponseAllOfCyphersInner(BaseModel):
    """
    ListCypherKeys200ResponseAllOfCyphersInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    item_key: Optional[StrictStr] = Field(default=None, alias="itemKey")
    lease_timeout: Optional[StrictInt] = Field(default=None, alias="leaseTimeout")
    expire_date: Optional[datetime] = Field(default=None, alias="expireDate")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    last_accessed: Optional[datetime] = Field(default=None, alias="lastAccessed")
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "itemKey", "leaseTimeout", "expireDate", "dateCreated", "lastUpdated", "lastAccessed", "createdBy"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListCypherKeys200ResponseAllOfCyphersInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if expire_date (nullable) is None
        # and model_fields_set contains the field
        if self.expire_date is None and "expire_date" in self.model_fields_set:
            _dict['expireDate'] = None

        # set to None if date_created (nullable) is None
        # and model_fields_set contains the field
        if self.date_created is None and "date_created" in self.model_fields_set:
            _dict['dateCreated'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListCypherKeys200ResponseAllOfCyphersInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "itemKey": obj.get("itemKey"),
            "leaseTimeout": obj.get("leaseTimeout"),
            "expireDate": obj.get("expireDate"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "lastAccessed": obj.get("lastAccessed"),
            "createdBy": obj.get("createdBy")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


