# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_guidances200_response_all_of_discoveries_inner_any_of_config import ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfConfig
from morpheus.models.list_guidances200_response_all_of_discoveries_inner_any_of_plan_after_action import ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfPlanAfterAction
from morpheus.models.list_guidances200_response_all_of_discoveries_inner_any_of_plan_before_action import ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfPlanBeforeAction
from morpheus.models.list_guidances200_response_all_of_discoveries_inner_any_of_resource import ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResource
from morpheus.models.list_guidances200_response_all_of_discoveries_inner_any_of_savings import ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfSavings
from morpheus.models.list_guidances200_response_all_of_discoveries_inner_any_of_type import ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfType
from morpheus.models.list_guidances200_response_all_of_discoveries_inner_any_of_zone import ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfZone
from typing import Optional, Set
from typing_extensions import Self

class ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf(BaseModel):
    """
    ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf
    """ # noqa: E501
    id: Optional[StrictInt] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    action_category: Optional[StrictStr] = Field(default=None, alias="actionCategory")
    action_message: Optional[StrictStr] = Field(default=None, alias="actionMessage")
    action_title: Optional[StrictStr] = Field(default=None, alias="actionTitle")
    action_type: Optional[StrictStr] = Field(default=None, alias="actionType")
    action_value: Optional[StrictStr] = Field(default=None, alias="actionValue")
    action_value_type: Optional[StrictStr] = Field(default=None, alias="actionValueType")
    action_plan_id: Optional[StrictInt] = Field(default=None, alias="actionPlanId")
    status_message: Optional[StrictStr] = Field(default=None, alias="statusMessage")
    account_id: Optional[StrictInt] = Field(default=None, alias="accountId")
    user_id: Optional[StrictStr] = Field(default=None, alias="userId")
    site_id: Optional[StrictInt] = Field(default=None, alias="siteId")
    zone: Optional[ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfZone] = None
    state: Optional[StrictStr] = None
    state_message: Optional[StrictStr] = Field(default=None, alias="stateMessage")
    severity: Optional[StrictStr] = None
    resolved: Optional[StrictBool] = None
    resolved_message: Optional[StrictStr] = Field(default=None, alias="resolvedMessage")
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    ref_id: Optional[StrictInt] = Field(default=None, alias="refId")
    ref_name: Optional[StrictStr] = Field(default=None, alias="refName")
    type: Optional[ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfType] = None
    savings: Optional[ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfSavings] = None
    resource: Optional[ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResource] = None
    plan_before_action: Optional[ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfPlanBeforeAction] = Field(default=None, alias="planBeforeAction")
    plan_after_action: Optional[ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfPlanAfterAction] = Field(default=None, alias="planAfterAction")
    config: Optional[ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfConfig] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "dateCreated", "lastUpdated", "actionCategory", "actionMessage", "actionTitle", "actionType", "actionValue", "actionValueType", "actionPlanId", "statusMessage", "accountId", "userId", "siteId", "zone", "state", "stateMessage", "severity", "resolved", "resolvedMessage", "refType", "refId", "refName", "type", "savings", "resource", "planBeforeAction", "planAfterAction", "config"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of zone
        if self.zone:
            _dict['zone'] = self.zone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of savings
        if self.savings:
            _dict['savings'] = self.savings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of resource
        if self.resource:
            _dict['resource'] = self.resource.to_dict()
        # override the default output from pydantic by calling `to_dict()` of plan_before_action
        if self.plan_before_action:
            _dict['planBeforeAction'] = self.plan_before_action.to_dict()
        # override the default output from pydantic by calling `to_dict()` of plan_after_action
        if self.plan_after_action:
            _dict['planAfterAction'] = self.plan_after_action.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if user_id (nullable) is None
        # and model_fields_set contains the field
        if self.user_id is None and "user_id" in self.model_fields_set:
            _dict['userId'] = None

        # set to None if site_id (nullable) is None
        # and model_fields_set contains the field
        if self.site_id is None and "site_id" in self.model_fields_set:
            _dict['siteId'] = None

        # set to None if state_message (nullable) is None
        # and model_fields_set contains the field
        if self.state_message is None and "state_message" in self.model_fields_set:
            _dict['stateMessage'] = None

        # set to None if resolved_message (nullable) is None
        # and model_fields_set contains the field
        if self.resolved_message is None and "resolved_message" in self.model_fields_set:
            _dict['resolvedMessage'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "actionCategory": obj.get("actionCategory"),
            "actionMessage": obj.get("actionMessage"),
            "actionTitle": obj.get("actionTitle"),
            "actionType": obj.get("actionType"),
            "actionValue": obj.get("actionValue"),
            "actionValueType": obj.get("actionValueType"),
            "actionPlanId": obj.get("actionPlanId"),
            "statusMessage": obj.get("statusMessage"),
            "accountId": obj.get("accountId"),
            "userId": obj.get("userId"),
            "siteId": obj.get("siteId"),
            "zone": ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfZone.from_dict(obj["zone"]) if obj.get("zone") is not None else None,
            "state": obj.get("state"),
            "stateMessage": obj.get("stateMessage"),
            "severity": obj.get("severity"),
            "resolved": obj.get("resolved"),
            "resolvedMessage": obj.get("resolvedMessage"),
            "refType": obj.get("refType"),
            "refId": obj.get("refId"),
            "refName": obj.get("refName"),
            "type": ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfType.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "savings": ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfSavings.from_dict(obj["savings"]) if obj.get("savings") is not None else None,
            "resource": ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResource.from_dict(obj["resource"]) if obj.get("resource") is not None else None,
            "planBeforeAction": ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfPlanBeforeAction.from_dict(obj["planBeforeAction"]) if obj.get("planBeforeAction") is not None else None,
            "planAfterAction": ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfPlanAfterAction.from_dict(obj["planAfterAction"]) if obj.get("planAfterAction") is not None else None,
            "config": ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfConfig.from_dict(obj["config"]) if obj.get("config") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


