# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceStats(BaseModel):
    """
    ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceStats
    """ # noqa: E501
    ts: Optional[StrictStr] = None
    free_memory: Optional[StrictInt] = Field(default=None, alias="freeMemory")
    used_memory: Optional[StrictInt] = Field(default=None, alias="usedMemory")
    free_swap: Optional[StrictInt] = Field(default=None, alias="freeSwap")
    used_swap: Optional[StrictInt] = Field(default=None, alias="usedSwap")
    cpu_idle_time: Optional[StrictInt] = Field(default=None, alias="cpuIdleTime")
    cpu_system_time: Optional[StrictInt] = Field(default=None, alias="cpuSystemTime")
    cpu_user_time: Optional[StrictInt] = Field(default=None, alias="cpuUserTime")
    cpu_total_time: Optional[StrictInt] = Field(default=None, alias="cpuTotalTime")
    cpu_usage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="cpuUsage")
    used_storage: Optional[StrictInt] = Field(default=None, alias="usedStorage")
    reserved_storage: Optional[StrictInt] = Field(default=None, alias="reservedStorage")
    max_storage: Optional[StrictInt] = Field(default=None, alias="maxStorage")
    net_tx_usage: Optional[StrictInt] = Field(default=None, alias="netTxUsage")
    net_rx_usage: Optional[StrictInt] = Field(default=None, alias="netRxUsage")
    network_bandwidth: Optional[StrictInt] = Field(default=None, alias="networkBandwidth")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["ts", "freeMemory", "usedMemory", "freeSwap", "usedSwap", "cpuIdleTime", "cpuSystemTime", "cpuUserTime", "cpuTotalTime", "cpuUsage", "usedStorage", "reservedStorage", "maxStorage", "netTxUsage", "netRxUsage", "networkBandwidth"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceStats from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if free_memory (nullable) is None
        # and model_fields_set contains the field
        if self.free_memory is None and "free_memory" in self.model_fields_set:
            _dict['freeMemory'] = None

        # set to None if used_memory (nullable) is None
        # and model_fields_set contains the field
        if self.used_memory is None and "used_memory" in self.model_fields_set:
            _dict['usedMemory'] = None

        # set to None if free_swap (nullable) is None
        # and model_fields_set contains the field
        if self.free_swap is None and "free_swap" in self.model_fields_set:
            _dict['freeSwap'] = None

        # set to None if used_swap (nullable) is None
        # and model_fields_set contains the field
        if self.used_swap is None and "used_swap" in self.model_fields_set:
            _dict['usedSwap'] = None

        # set to None if cpu_idle_time (nullable) is None
        # and model_fields_set contains the field
        if self.cpu_idle_time is None and "cpu_idle_time" in self.model_fields_set:
            _dict['cpuIdleTime'] = None

        # set to None if cpu_system_time (nullable) is None
        # and model_fields_set contains the field
        if self.cpu_system_time is None and "cpu_system_time" in self.model_fields_set:
            _dict['cpuSystemTime'] = None

        # set to None if cpu_user_time (nullable) is None
        # and model_fields_set contains the field
        if self.cpu_user_time is None and "cpu_user_time" in self.model_fields_set:
            _dict['cpuUserTime'] = None

        # set to None if cpu_total_time (nullable) is None
        # and model_fields_set contains the field
        if self.cpu_total_time is None and "cpu_total_time" in self.model_fields_set:
            _dict['cpuTotalTime'] = None

        # set to None if cpu_usage (nullable) is None
        # and model_fields_set contains the field
        if self.cpu_usage is None and "cpu_usage" in self.model_fields_set:
            _dict['cpuUsage'] = None

        # set to None if used_storage (nullable) is None
        # and model_fields_set contains the field
        if self.used_storage is None and "used_storage" in self.model_fields_set:
            _dict['usedStorage'] = None

        # set to None if reserved_storage (nullable) is None
        # and model_fields_set contains the field
        if self.reserved_storage is None and "reserved_storage" in self.model_fields_set:
            _dict['reservedStorage'] = None

        # set to None if max_storage (nullable) is None
        # and model_fields_set contains the field
        if self.max_storage is None and "max_storage" in self.model_fields_set:
            _dict['maxStorage'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceStats from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ts": obj.get("ts"),
            "freeMemory": obj.get("freeMemory"),
            "usedMemory": obj.get("usedMemory"),
            "freeSwap": obj.get("freeSwap"),
            "usedSwap": obj.get("usedSwap"),
            "cpuIdleTime": obj.get("cpuIdleTime"),
            "cpuSystemTime": obj.get("cpuSystemTime"),
            "cpuUserTime": obj.get("cpuUserTime"),
            "cpuTotalTime": obj.get("cpuTotalTime"),
            "cpuUsage": obj.get("cpuUsage"),
            "usedStorage": obj.get("usedStorage"),
            "reservedStorage": obj.get("reservedStorage"),
            "maxStorage": obj.get("maxStorage"),
            "netTxUsage": obj.get("netTxUsage"),
            "netRxUsage": obj.get("netRxUsage"),
            "networkBandwidth": obj.get("networkBandwidth")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


