# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceVolumesInner(BaseModel):
    """
    ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceVolumesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    controller_id: Optional[StrictInt] = Field(default=None, alias="controllerId")
    controller_mount_point: Optional[StrictStr] = Field(default=None, alias="controllerMountPoint")
    resizeable: Optional[StrictBool] = None
    plan_resizable: Optional[StrictBool] = Field(default=None, alias="planResizable")
    root_volume: Optional[StrictBool] = Field(default=None, alias="rootVolume")
    unit_number: Optional[StrictStr] = Field(default=None, alias="unitNumber")
    type_id: Optional[StrictInt] = Field(default=None, alias="typeId")
    configurable_iops: Optional[StrictBool] = Field(default=None, alias="configurableIOPS")
    datastore_id: Optional[StrictInt] = Field(default=None, alias="datastoreId")
    max_storage: Optional[StrictInt] = Field(default=None, alias="maxStorage")
    display_order: Optional[StrictInt] = Field(default=None, alias="displayOrder")
    max_iops: Optional[StrictStr] = Field(default=None, alias="maxIOPS")
    uuid: Optional[StrictStr] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "controllerId", "controllerMountPoint", "resizeable", "planResizable", "rootVolume", "unitNumber", "typeId", "configurableIOPS", "datastoreId", "maxStorage", "displayOrder", "maxIOPS", "uuid"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceVolumesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if max_iops (nullable) is None
        # and model_fields_set contains the field
        if self.max_iops is None and "max_iops" in self.model_fields_set:
            _dict['maxIOPS'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceVolumesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "controllerId": obj.get("controllerId"),
            "controllerMountPoint": obj.get("controllerMountPoint"),
            "resizeable": obj.get("resizeable"),
            "planResizable": obj.get("planResizable"),
            "rootVolume": obj.get("rootVolume"),
            "unitNumber": obj.get("unitNumber"),
            "typeId": obj.get("typeId"),
            "configurableIOPS": obj.get("configurableIOPS"),
            "datastoreId": obj.get("datastoreId"),
            "maxStorage": obj.get("maxStorage"),
            "displayOrder": obj.get("displayOrder"),
            "maxIOPS": obj.get("maxIOPS"),
            "uuid": obj.get("uuid")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


