# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ListHealth200ResponseAllOfHealthDatabaseStats(BaseModel):
    """
    ListHealth200ResponseAllOfHealthDatabaseStats
    """ # noqa: E501
    aborted_clients: Optional[StrictStr] = Field(default=None, alias="Aborted_clients")
    aborted_connects: Optional[StrictStr] = Field(default=None, alias="Aborted_connects")
    binlog_snapshot_file: Optional[StrictStr] = Field(default=None, alias="Binlog_snapshot_file")
    binlog_snapshot_position: Optional[StrictStr] = Field(default=None, alias="Binlog_snapshot_position")
    binlog_cache_disk_use: Optional[StrictStr] = Field(default=None, alias="Binlog_cache_disk_use")
    binlog_cache_use: Optional[StrictStr] = Field(default=None, alias="Binlog_cache_use")
    binlog_snapshot_gtid_executed: Optional[StrictStr] = Field(default=None, alias="Binlog_snapshot_gtid_executed")
    binlog_stmt_cache_disk_use: Optional[StrictStr] = Field(default=None, alias="Binlog_stmt_cache_disk_use")
    binlog_stmt_cache_use: Optional[StrictStr] = Field(default=None, alias="Binlog_stmt_cache_use")
    bytes_received: Optional[StrictStr] = Field(default=None, alias="Bytes_received")
    bytes_sent: Optional[StrictStr] = Field(default=None, alias="Bytes_sent")
    com_admin_commands: Optional[StrictStr] = Field(default=None, alias="Com_admin_commands")
    com_assign_to_keycache: Optional[StrictStr] = Field(default=None, alias="Com_assign_to_keycache")
    com_alter_db: Optional[StrictStr] = Field(default=None, alias="Com_alter_db")
    com_alter_db_upgrade: Optional[StrictStr] = Field(default=None, alias="Com_alter_db_upgrade")
    com_alter_event: Optional[StrictStr] = Field(default=None, alias="Com_alter_event")
    com_alter_function: Optional[StrictStr] = Field(default=None, alias="Com_alter_function")
    com_alter_instance: Optional[StrictStr] = Field(default=None, alias="Com_alter_instance")
    com_alter_procedure: Optional[StrictStr] = Field(default=None, alias="Com_alter_procedure")
    com_alter_server: Optional[StrictStr] = Field(default=None, alias="Com_alter_server")
    com_alter_table: Optional[StrictStr] = Field(default=None, alias="Com_alter_table")
    com_alter_tablespace: Optional[StrictStr] = Field(default=None, alias="Com_alter_tablespace")
    com_alter_user: Optional[StrictStr] = Field(default=None, alias="Com_alter_user")
    com_analyze: Optional[StrictStr] = Field(default=None, alias="Com_analyze")
    com_begin: Optional[StrictStr] = Field(default=None, alias="Com_begin")
    com_binlog: Optional[StrictStr] = Field(default=None, alias="Com_binlog")
    com_call_procedure: Optional[StrictStr] = Field(default=None, alias="Com_call_procedure")
    com_change_db: Optional[StrictStr] = Field(default=None, alias="Com_change_db")
    com_change_master: Optional[StrictStr] = Field(default=None, alias="Com_change_master")
    com_change_repl_filter: Optional[StrictStr] = Field(default=None, alias="Com_change_repl_filter")
    com_check: Optional[StrictStr] = Field(default=None, alias="Com_check")
    com_checksum: Optional[StrictStr] = Field(default=None, alias="Com_checksum")
    com_commit: Optional[StrictStr] = Field(default=None, alias="Com_commit")
    com_create_compression_dictionary: Optional[StrictStr] = Field(default=None, alias="Com_create_compression_dictionary")
    com_create_db: Optional[StrictStr] = Field(default=None, alias="Com_create_db")
    com_create_event: Optional[StrictStr] = Field(default=None, alias="Com_create_event")
    com_create_function: Optional[StrictStr] = Field(default=None, alias="Com_create_function")
    com_create_index: Optional[StrictStr] = Field(default=None, alias="Com_create_index")
    com_create_procedure: Optional[StrictStr] = Field(default=None, alias="Com_create_procedure")
    com_create_server: Optional[StrictStr] = Field(default=None, alias="Com_create_server")
    com_create_table: Optional[StrictStr] = Field(default=None, alias="Com_create_table")
    com_create_trigger: Optional[StrictStr] = Field(default=None, alias="Com_create_trigger")
    com_create_udf: Optional[StrictStr] = Field(default=None, alias="Com_create_udf")
    com_create_user: Optional[StrictStr] = Field(default=None, alias="Com_create_user")
    com_create_view: Optional[StrictStr] = Field(default=None, alias="Com_create_view")
    com_dealloc_sql: Optional[StrictStr] = Field(default=None, alias="Com_dealloc_sql")
    com_delete: Optional[StrictStr] = Field(default=None, alias="Com_delete")
    com_delete_multi: Optional[StrictStr] = Field(default=None, alias="Com_delete_multi")
    com_do: Optional[StrictStr] = Field(default=None, alias="Com_do")
    com_drop_compression_dictionary: Optional[StrictStr] = Field(default=None, alias="Com_drop_compression_dictionary")
    com_drop_db: Optional[StrictStr] = Field(default=None, alias="Com_drop_db")
    com_drop_event: Optional[StrictStr] = Field(default=None, alias="Com_drop_event")
    com_drop_function: Optional[StrictStr] = Field(default=None, alias="Com_drop_function")
    com_drop_index: Optional[StrictStr] = Field(default=None, alias="Com_drop_index")
    com_drop_procedure: Optional[StrictStr] = Field(default=None, alias="Com_drop_procedure")
    com_drop_server: Optional[StrictStr] = Field(default=None, alias="Com_drop_server")
    com_drop_table: Optional[StrictStr] = Field(default=None, alias="Com_drop_table")
    com_drop_trigger: Optional[StrictStr] = Field(default=None, alias="Com_drop_trigger")
    com_drop_user: Optional[StrictStr] = Field(default=None, alias="Com_drop_user")
    com_drop_view: Optional[StrictStr] = Field(default=None, alias="Com_drop_view")
    com_empty_query: Optional[StrictStr] = Field(default=None, alias="Com_empty_query")
    com_execute_sql: Optional[StrictStr] = Field(default=None, alias="Com_execute_sql")
    com_explain_other: Optional[StrictStr] = Field(default=None, alias="Com_explain_other")
    com_flush: Optional[StrictStr] = Field(default=None, alias="Com_flush")
    com_get_diagnostics: Optional[StrictStr] = Field(default=None, alias="Com_get_diagnostics")
    com_grant: Optional[StrictStr] = Field(default=None, alias="Com_grant")
    com_ha_close: Optional[StrictStr] = Field(default=None, alias="Com_ha_close")
    com_ha_open: Optional[StrictStr] = Field(default=None, alias="Com_ha_open")
    com_ha_read: Optional[StrictStr] = Field(default=None, alias="Com_ha_read")
    com_help: Optional[StrictStr] = Field(default=None, alias="Com_help")
    com_insert: Optional[StrictStr] = Field(default=None, alias="Com_insert")
    com_insert_select: Optional[StrictStr] = Field(default=None, alias="Com_insert_select")
    com_install_plugin: Optional[StrictStr] = Field(default=None, alias="Com_install_plugin")
    com_kill: Optional[StrictStr] = Field(default=None, alias="Com_kill")
    com_load: Optional[StrictStr] = Field(default=None, alias="Com_load")
    com_lock_tables: Optional[StrictStr] = Field(default=None, alias="Com_lock_tables")
    com_lock_tables_for_backup: Optional[StrictStr] = Field(default=None, alias="Com_lock_tables_for_backup")
    com_lock_binlog_for_backup: Optional[StrictStr] = Field(default=None, alias="Com_lock_binlog_for_backup")
    com_optimize: Optional[StrictStr] = Field(default=None, alias="Com_optimize")
    com_preload_keys: Optional[StrictStr] = Field(default=None, alias="Com_preload_keys")
    com_prepare_sql: Optional[StrictStr] = Field(default=None, alias="Com_prepare_sql")
    com_purge: Optional[StrictStr] = Field(default=None, alias="Com_purge")
    com_purge_before_date: Optional[StrictStr] = Field(default=None, alias="Com_purge_before_date")
    com_release_savepoint: Optional[StrictStr] = Field(default=None, alias="Com_release_savepoint")
    com_rename_table: Optional[StrictStr] = Field(default=None, alias="Com_rename_table")
    com_rename_user: Optional[StrictStr] = Field(default=None, alias="Com_rename_user")
    com_repair: Optional[StrictStr] = Field(default=None, alias="Com_repair")
    com_replace: Optional[StrictStr] = Field(default=None, alias="Com_replace")
    com_replace_select: Optional[StrictStr] = Field(default=None, alias="Com_replace_select")
    com_reset: Optional[StrictStr] = Field(default=None, alias="Com_reset")
    com_resignal: Optional[StrictStr] = Field(default=None, alias="Com_resignal")
    com_revoke: Optional[StrictStr] = Field(default=None, alias="Com_revoke")
    com_revoke_all: Optional[StrictStr] = Field(default=None, alias="Com_revoke_all")
    com_rollback: Optional[StrictStr] = Field(default=None, alias="Com_rollback")
    com_rollback_to_savepoint: Optional[StrictStr] = Field(default=None, alias="Com_rollback_to_savepoint")
    com_savepoint: Optional[StrictStr] = Field(default=None, alias="Com_savepoint")
    com_select: Optional[StrictStr] = Field(default=None, alias="Com_select")
    com_set_option: Optional[StrictStr] = Field(default=None, alias="Com_set_option")
    com_signal: Optional[StrictStr] = Field(default=None, alias="Com_signal")
    com_show_binlog_events: Optional[StrictStr] = Field(default=None, alias="Com_show_binlog_events")
    com_show_binlogs: Optional[StrictStr] = Field(default=None, alias="Com_show_binlogs")
    com_show_charsets: Optional[StrictStr] = Field(default=None, alias="Com_show_charsets")
    com_show_client_statistics: Optional[StrictStr] = Field(default=None, alias="Com_show_client_statistics")
    com_show_collations: Optional[StrictStr] = Field(default=None, alias="Com_show_collations")
    com_show_create_db: Optional[StrictStr] = Field(default=None, alias="Com_show_create_db")
    com_show_create_event: Optional[StrictStr] = Field(default=None, alias="Com_show_create_event")
    com_show_create_func: Optional[StrictStr] = Field(default=None, alias="Com_show_create_func")
    com_show_create_proc: Optional[StrictStr] = Field(default=None, alias="Com_show_create_proc")
    com_show_create_table: Optional[StrictStr] = Field(default=None, alias="Com_show_create_table")
    com_show_create_trigger: Optional[StrictStr] = Field(default=None, alias="Com_show_create_trigger")
    com_show_databases: Optional[StrictStr] = Field(default=None, alias="Com_show_databases")
    com_show_engine_logs: Optional[StrictStr] = Field(default=None, alias="Com_show_engine_logs")
    com_show_engine_mutex: Optional[StrictStr] = Field(default=None, alias="Com_show_engine_mutex")
    com_show_engine_status: Optional[StrictStr] = Field(default=None, alias="Com_show_engine_status")
    com_show_events: Optional[StrictStr] = Field(default=None, alias="Com_show_events")
    com_show_errors: Optional[StrictStr] = Field(default=None, alias="Com_show_errors")
    com_show_fields: Optional[StrictStr] = Field(default=None, alias="Com_show_fields")
    com_show_function_code: Optional[StrictStr] = Field(default=None, alias="Com_show_function_code")
    com_show_function_status: Optional[StrictStr] = Field(default=None, alias="Com_show_function_status")
    com_show_grants: Optional[StrictStr] = Field(default=None, alias="Com_show_grants")
    com_show_index_statistics: Optional[StrictStr] = Field(default=None, alias="Com_show_index_statistics")
    com_show_keys: Optional[StrictStr] = Field(default=None, alias="Com_show_keys")
    com_show_master_status: Optional[StrictStr] = Field(default=None, alias="Com_show_master_status")
    com_show_open_tables: Optional[StrictStr] = Field(default=None, alias="Com_show_open_tables")
    com_show_plugins: Optional[StrictStr] = Field(default=None, alias="Com_show_plugins")
    com_show_privileges: Optional[StrictStr] = Field(default=None, alias="Com_show_privileges")
    com_show_procedure_code: Optional[StrictStr] = Field(default=None, alias="Com_show_procedure_code")
    com_show_procedure_status: Optional[StrictStr] = Field(default=None, alias="Com_show_procedure_status")
    com_show_processlist: Optional[StrictStr] = Field(default=None, alias="Com_show_processlist")
    com_show_profile: Optional[StrictStr] = Field(default=None, alias="Com_show_profile")
    com_show_profiles: Optional[StrictStr] = Field(default=None, alias="Com_show_profiles")
    com_show_relaylog_events: Optional[StrictStr] = Field(default=None, alias="Com_show_relaylog_events")
    com_show_slave_hosts: Optional[StrictStr] = Field(default=None, alias="Com_show_slave_hosts")
    com_show_slave_status: Optional[StrictStr] = Field(default=None, alias="Com_show_slave_status")
    com_show_status: Optional[StrictStr] = Field(default=None, alias="Com_show_status")
    com_show_storage_engines: Optional[StrictStr] = Field(default=None, alias="Com_show_storage_engines")
    com_show_table_statistics: Optional[StrictStr] = Field(default=None, alias="Com_show_table_statistics")
    com_show_table_status: Optional[StrictStr] = Field(default=None, alias="Com_show_table_status")
    com_show_tables: Optional[StrictStr] = Field(default=None, alias="Com_show_tables")
    com_show_thread_statistics: Optional[StrictStr] = Field(default=None, alias="Com_show_thread_statistics")
    com_show_triggers: Optional[StrictStr] = Field(default=None, alias="Com_show_triggers")
    com_show_user_statistics: Optional[StrictStr] = Field(default=None, alias="Com_show_user_statistics")
    com_show_variables: Optional[StrictStr] = Field(default=None, alias="Com_show_variables")
    com_show_warnings: Optional[StrictStr] = Field(default=None, alias="Com_show_warnings")
    com_show_create_user: Optional[StrictStr] = Field(default=None, alias="Com_show_create_user")
    com_shutdown: Optional[StrictStr] = Field(default=None, alias="Com_shutdown")
    com_slave_start: Optional[StrictStr] = Field(default=None, alias="Com_slave_start")
    com_slave_stop: Optional[StrictStr] = Field(default=None, alias="Com_slave_stop")
    com_group_replication_start: Optional[StrictStr] = Field(default=None, alias="Com_group_replication_start")
    com_group_replication_stop: Optional[StrictStr] = Field(default=None, alias="Com_group_replication_stop")
    com_stmt_execute: Optional[StrictStr] = Field(default=None, alias="Com_stmt_execute")
    com_stmt_close: Optional[StrictStr] = Field(default=None, alias="Com_stmt_close")
    com_stmt_fetch: Optional[StrictStr] = Field(default=None, alias="Com_stmt_fetch")
    com_stmt_prepare: Optional[StrictStr] = Field(default=None, alias="Com_stmt_prepare")
    com_stmt_reset: Optional[StrictStr] = Field(default=None, alias="Com_stmt_reset")
    com_stmt_send_long_data: Optional[StrictStr] = Field(default=None, alias="Com_stmt_send_long_data")
    com_truncate: Optional[StrictStr] = Field(default=None, alias="Com_truncate")
    com_uninstall_plugin: Optional[StrictStr] = Field(default=None, alias="Com_uninstall_plugin")
    com_unlock_binlog: Optional[StrictStr] = Field(default=None, alias="Com_unlock_binlog")
    com_unlock_tables: Optional[StrictStr] = Field(default=None, alias="Com_unlock_tables")
    com_update: Optional[StrictStr] = Field(default=None, alias="Com_update")
    com_update_multi: Optional[StrictStr] = Field(default=None, alias="Com_update_multi")
    com_xa_commit: Optional[StrictStr] = Field(default=None, alias="Com_xa_commit")
    com_xa_end: Optional[StrictStr] = Field(default=None, alias="Com_xa_end")
    com_xa_prepare: Optional[StrictStr] = Field(default=None, alias="Com_xa_prepare")
    com_xa_recover: Optional[StrictStr] = Field(default=None, alias="Com_xa_recover")
    com_xa_rollback: Optional[StrictStr] = Field(default=None, alias="Com_xa_rollback")
    com_xa_start: Optional[StrictStr] = Field(default=None, alias="Com_xa_start")
    com_stmt_reprepare: Optional[StrictStr] = Field(default=None, alias="Com_stmt_reprepare")
    compression: Optional[StrictStr] = Field(default=None, alias="Compression")
    connection_errors_accept: Optional[StrictStr] = Field(default=None, alias="Connection_errors_accept")
    connection_errors_internal: Optional[StrictStr] = Field(default=None, alias="Connection_errors_internal")
    connection_errors_max_connections: Optional[StrictStr] = Field(default=None, alias="Connection_errors_max_connections")
    connection_errors_peer_address: Optional[StrictStr] = Field(default=None, alias="Connection_errors_peer_address")
    connection_errors_select: Optional[StrictStr] = Field(default=None, alias="Connection_errors_select")
    connection_errors_tcpwrap: Optional[StrictStr] = Field(default=None, alias="Connection_errors_tcpwrap")
    connections: Optional[StrictStr] = Field(default=None, alias="Connections")
    created_tmp_disk_tables: Optional[StrictStr] = Field(default=None, alias="Created_tmp_disk_tables")
    created_tmp_files: Optional[StrictStr] = Field(default=None, alias="Created_tmp_files")
    created_tmp_tables: Optional[StrictStr] = Field(default=None, alias="Created_tmp_tables")
    delayed_errors: Optional[StrictStr] = Field(default=None, alias="Delayed_errors")
    delayed_insert_threads: Optional[StrictStr] = Field(default=None, alias="Delayed_insert_threads")
    delayed_writes: Optional[StrictStr] = Field(default=None, alias="Delayed_writes")
    flush_commands: Optional[StrictStr] = Field(default=None, alias="Flush_commands")
    handler_commit: Optional[StrictStr] = Field(default=None, alias="Handler_commit")
    handler_delete: Optional[StrictStr] = Field(default=None, alias="Handler_delete")
    handler_discover: Optional[StrictStr] = Field(default=None, alias="Handler_discover")
    handler_external_lock: Optional[StrictStr] = Field(default=None, alias="Handler_external_lock")
    handler_mrr_init: Optional[StrictStr] = Field(default=None, alias="Handler_mrr_init")
    handler_prepare: Optional[StrictStr] = Field(default=None, alias="Handler_prepare")
    handler_read_first: Optional[StrictStr] = Field(default=None, alias="Handler_read_first")
    handler_read_key: Optional[StrictStr] = Field(default=None, alias="Handler_read_key")
    handler_read_last: Optional[StrictStr] = Field(default=None, alias="Handler_read_last")
    handler_read_next: Optional[StrictStr] = Field(default=None, alias="Handler_read_next")
    handler_read_prev: Optional[StrictStr] = Field(default=None, alias="Handler_read_prev")
    handler_read_rnd: Optional[StrictStr] = Field(default=None, alias="Handler_read_rnd")
    handler_read_rnd_next: Optional[StrictStr] = Field(default=None, alias="Handler_read_rnd_next")
    handler_rollback: Optional[StrictStr] = Field(default=None, alias="Handler_rollback")
    handler_savepoint: Optional[StrictStr] = Field(default=None, alias="Handler_savepoint")
    handler_savepoint_rollback: Optional[StrictStr] = Field(default=None, alias="Handler_savepoint_rollback")
    handler_update: Optional[StrictStr] = Field(default=None, alias="Handler_update")
    handler_write: Optional[StrictStr] = Field(default=None, alias="Handler_write")
    innodb_background_log_sync: Optional[StrictStr] = Field(default=None, alias="Innodb_background_log_sync")
    innodb_buffer_pool_dump_status: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_dump_status")
    innodb_buffer_pool_load_status: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_load_status")
    innodb_buffer_pool_resize_status: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_resize_status")
    innodb_buffer_pool_pages_data: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_pages_data")
    innodb_buffer_pool_bytes_data: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_bytes_data")
    innodb_buffer_pool_pages_dirty: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_pages_dirty")
    innodb_buffer_pool_bytes_dirty: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_bytes_dirty")
    innodb_buffer_pool_pages_flushed: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_pages_flushed")
    innodb_buffer_pool_pages_free: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_pages_free")
    innodb_buffer_pool_pages_lru_flushed: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_pages_LRU_flushed")
    innodb_buffer_pool_pages_made_not_young: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_pages_made_not_young")
    innodb_buffer_pool_pages_made_young: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_pages_made_young")
    innodb_buffer_pool_pages_misc: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_pages_misc")
    innodb_buffer_pool_pages_old: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_pages_old")
    innodb_buffer_pool_pages_total: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_pages_total")
    innodb_buffer_pool_read_ahead_rnd: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_read_ahead_rnd")
    innodb_buffer_pool_read_ahead: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_read_ahead")
    innodb_buffer_pool_read_ahead_evicted: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_read_ahead_evicted")
    innodb_buffer_pool_read_requests: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_read_requests")
    innodb_buffer_pool_reads: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_reads")
    innodb_buffer_pool_wait_free: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_wait_free")
    innodb_buffer_pool_write_requests: Optional[StrictStr] = Field(default=None, alias="Innodb_buffer_pool_write_requests")
    innodb_checkpoint_age: Optional[StrictStr] = Field(default=None, alias="Innodb_checkpoint_age")
    innodb_checkpoint_max_age: Optional[StrictStr] = Field(default=None, alias="Innodb_checkpoint_max_age")
    innodb_data_fsyncs: Optional[StrictStr] = Field(default=None, alias="Innodb_data_fsyncs")
    innodb_data_pending_fsyncs: Optional[StrictStr] = Field(default=None, alias="Innodb_data_pending_fsyncs")
    innodb_data_pending_reads: Optional[StrictStr] = Field(default=None, alias="Innodb_data_pending_reads")
    innodb_data_pending_writes: Optional[StrictStr] = Field(default=None, alias="Innodb_data_pending_writes")
    innodb_data_read: Optional[StrictStr] = Field(default=None, alias="Innodb_data_read")
    innodb_data_reads: Optional[StrictStr] = Field(default=None, alias="Innodb_data_reads")
    innodb_data_writes: Optional[StrictStr] = Field(default=None, alias="Innodb_data_writes")
    innodb_data_written: Optional[StrictStr] = Field(default=None, alias="Innodb_data_written")
    innodb_dblwr_pages_written: Optional[StrictStr] = Field(default=None, alias="Innodb_dblwr_pages_written")
    innodb_dblwr_writes: Optional[StrictStr] = Field(default=None, alias="Innodb_dblwr_writes")
    innodb_ibuf_free_list: Optional[StrictStr] = Field(default=None, alias="Innodb_ibuf_free_list")
    innodb_ibuf_segment_size: Optional[StrictStr] = Field(default=None, alias="Innodb_ibuf_segment_size")
    innodb_log_waits: Optional[StrictStr] = Field(default=None, alias="Innodb_log_waits")
    innodb_log_write_requests: Optional[StrictStr] = Field(default=None, alias="Innodb_log_write_requests")
    innodb_log_writes: Optional[StrictStr] = Field(default=None, alias="Innodb_log_writes")
    innodb_lsn_current: Optional[StrictStr] = Field(default=None, alias="Innodb_lsn_current")
    innodb_lsn_flushed: Optional[StrictStr] = Field(default=None, alias="Innodb_lsn_flushed")
    innodb_lsn_last_checkpoint: Optional[StrictStr] = Field(default=None, alias="Innodb_lsn_last_checkpoint")
    innodb_master_thread_active_loops: Optional[StrictStr] = Field(default=None, alias="Innodb_master_thread_active_loops")
    innodb_master_thread_idle_loops: Optional[StrictStr] = Field(default=None, alias="Innodb_master_thread_idle_loops")
    innodb_max_trx_id: Optional[StrictStr] = Field(default=None, alias="Innodb_max_trx_id")
    innodb_mem_adaptive_hash: Optional[StrictStr] = Field(default=None, alias="Innodb_mem_adaptive_hash")
    innodb_mem_dictionary: Optional[StrictStr] = Field(default=None, alias="Innodb_mem_dictionary")
    innodb_oldest_view_low_limit_trx_id: Optional[StrictStr] = Field(default=None, alias="Innodb_oldest_view_low_limit_trx_id")
    innodb_os_log_fsyncs: Optional[StrictStr] = Field(default=None, alias="Innodb_os_log_fsyncs")
    innodb_os_log_pending_fsyncs: Optional[StrictStr] = Field(default=None, alias="Innodb_os_log_pending_fsyncs")
    innodb_os_log_pending_writes: Optional[StrictStr] = Field(default=None, alias="Innodb_os_log_pending_writes")
    innodb_os_log_written: Optional[StrictStr] = Field(default=None, alias="Innodb_os_log_written")
    innodb_page_size: Optional[StrictStr] = Field(default=None, alias="Innodb_page_size")
    innodb_pages_created: Optional[StrictStr] = Field(default=None, alias="Innodb_pages_created")
    innodb_pages_read: Optional[StrictStr] = Field(default=None, alias="Innodb_pages_read")
    innodb_pages0_read: Optional[StrictStr] = Field(default=None, alias="Innodb_pages0_read")
    innodb_pages_written: Optional[StrictStr] = Field(default=None, alias="Innodb_pages_written")
    innodb_purge_trx_id: Optional[StrictStr] = Field(default=None, alias="Innodb_purge_trx_id")
    innodb_purge_undo_no: Optional[StrictStr] = Field(default=None, alias="Innodb_purge_undo_no")
    innodb_row_lock_current_waits: Optional[StrictStr] = Field(default=None, alias="Innodb_row_lock_current_waits")
    innodb_row_lock_time: Optional[StrictStr] = Field(default=None, alias="Innodb_row_lock_time")
    innodb_row_lock_time_avg: Optional[StrictStr] = Field(default=None, alias="Innodb_row_lock_time_avg")
    innodb_row_lock_time_max: Optional[StrictStr] = Field(default=None, alias="Innodb_row_lock_time_max")
    innodb_row_lock_waits: Optional[StrictStr] = Field(default=None, alias="Innodb_row_lock_waits")
    innodb_rows_deleted: Optional[StrictStr] = Field(default=None, alias="Innodb_rows_deleted")
    innodb_rows_inserted: Optional[StrictStr] = Field(default=None, alias="Innodb_rows_inserted")
    innodb_rows_read: Optional[StrictStr] = Field(default=None, alias="Innodb_rows_read")
    innodb_rows_updated: Optional[StrictStr] = Field(default=None, alias="Innodb_rows_updated")
    innodb_num_open_files: Optional[StrictStr] = Field(default=None, alias="Innodb_num_open_files")
    innodb_truncated_status_writes: Optional[StrictStr] = Field(default=None, alias="Innodb_truncated_status_writes")
    innodb_available_undo_logs: Optional[StrictStr] = Field(default=None, alias="Innodb_available_undo_logs")
    innodb_secondary_index_triggered_cluster_reads: Optional[StrictStr] = Field(default=None, alias="Innodb_secondary_index_triggered_cluster_reads")
    innodb_secondary_index_triggered_cluster_reads_avoided: Optional[StrictStr] = Field(default=None, alias="Innodb_secondary_index_triggered_cluster_reads_avoided")
    innodb_buffered_aio_submitted: Optional[StrictStr] = Field(default=None, alias="Innodb_buffered_aio_submitted")
    innodb_scan_pages_contiguous: Optional[StrictStr] = Field(default=None, alias="Innodb_scan_pages_contiguous")
    innodb_scan_pages_disjointed: Optional[StrictStr] = Field(default=None, alias="Innodb_scan_pages_disjointed")
    innodb_scan_pages_total_seek_distance: Optional[StrictStr] = Field(default=None, alias="Innodb_scan_pages_total_seek_distance")
    innodb_scan_data_size: Optional[StrictStr] = Field(default=None, alias="Innodb_scan_data_size")
    innodb_scan_deleted_recs_size: Optional[StrictStr] = Field(default=None, alias="Innodb_scan_deleted_recs_size")
    innodb_scrub_background_page_reorganizations: Optional[StrictStr] = Field(default=None, alias="Innodb_scrub_background_page_reorganizations")
    innodb_scrub_background_page_splits: Optional[StrictStr] = Field(default=None, alias="Innodb_scrub_background_page_splits")
    innodb_scrub_background_page_split_failures_underflow: Optional[StrictStr] = Field(default=None, alias="Innodb_scrub_background_page_split_failures_underflow")
    innodb_scrub_background_page_split_failures_out_of_filespace: Optional[StrictStr] = Field(default=None, alias="Innodb_scrub_background_page_split_failures_out_of_filespace")
    innodb_scrub_background_page_split_failures_missing_index: Optional[StrictStr] = Field(default=None, alias="Innodb_scrub_background_page_split_failures_missing_index")
    innodb_scrub_background_page_split_failures_unknown: Optional[StrictStr] = Field(default=None, alias="Innodb_scrub_background_page_split_failures_unknown")
    innodb_scrub_log: Optional[StrictStr] = Field(default=None, alias="Innodb_scrub_log")
    innodb_encryption_rotation_pages_read_from_cache: Optional[StrictStr] = Field(default=None, alias="Innodb_encryption_rotation_pages_read_from_cache")
    innodb_encryption_rotation_pages_read_from_disk: Optional[StrictStr] = Field(default=None, alias="Innodb_encryption_rotation_pages_read_from_disk")
    innodb_encryption_rotation_pages_modified: Optional[StrictStr] = Field(default=None, alias="Innodb_encryption_rotation_pages_modified")
    innodb_encryption_rotation_pages_flushed: Optional[StrictStr] = Field(default=None, alias="Innodb_encryption_rotation_pages_flushed")
    innodb_encryption_rotation_estimated_iops: Optional[StrictStr] = Field(default=None, alias="Innodb_encryption_rotation_estimated_iops")
    innodb_encryption_key_rotation_list_length: Optional[StrictStr] = Field(default=None, alias="Innodb_encryption_key_rotation_list_length")
    innodb_encryption_n_merge_blocks_encrypted: Optional[StrictStr] = Field(default=None, alias="Innodb_encryption_n_merge_blocks_encrypted")
    innodb_encryption_n_merge_blocks_decrypted: Optional[StrictStr] = Field(default=None, alias="Innodb_encryption_n_merge_blocks_decrypted")
    innodb_encryption_n_rowlog_blocks_encrypted: Optional[StrictStr] = Field(default=None, alias="Innodb_encryption_n_rowlog_blocks_encrypted")
    innodb_encryption_n_rowlog_blocks_decrypted: Optional[StrictStr] = Field(default=None, alias="Innodb_encryption_n_rowlog_blocks_decrypted")
    innodb_num_pages_encrypted: Optional[StrictStr] = Field(default=None, alias="Innodb_num_pages_encrypted")
    innodb_num_pages_decrypted: Optional[StrictStr] = Field(default=None, alias="Innodb_num_pages_decrypted")
    innodb_encryption_redo_key_version: Optional[StrictStr] = Field(default=None, alias="Innodb_encryption_redo_key_version")
    key_blocks_not_flushed: Optional[StrictStr] = Field(default=None, alias="Key_blocks_not_flushed")
    key_blocks_unused: Optional[StrictStr] = Field(default=None, alias="Key_blocks_unused")
    key_blocks_used: Optional[StrictStr] = Field(default=None, alias="Key_blocks_used")
    key_read_requests: Optional[StrictStr] = Field(default=None, alias="Key_read_requests")
    key_reads: Optional[StrictStr] = Field(default=None, alias="Key_reads")
    key_write_requests: Optional[StrictStr] = Field(default=None, alias="Key_write_requests")
    key_writes: Optional[StrictStr] = Field(default=None, alias="Key_writes")
    last_query_cost: Optional[StrictStr] = Field(default=None, alias="Last_query_cost")
    last_query_partial_plans: Optional[StrictStr] = Field(default=None, alias="Last_query_partial_plans")
    locked_connects: Optional[StrictStr] = Field(default=None, alias="Locked_connects")
    max_execution_time_exceeded: Optional[StrictStr] = Field(default=None, alias="Max_execution_time_exceeded")
    max_execution_time_set: Optional[StrictStr] = Field(default=None, alias="Max_execution_time_set")
    max_execution_time_set_failed: Optional[StrictStr] = Field(default=None, alias="Max_execution_time_set_failed")
    max_used_connections: Optional[StrictStr] = Field(default=None, alias="Max_used_connections")
    max_used_connections_time: Optional[StrictStr] = Field(default=None, alias="Max_used_connections_time")
    not_flushed_delayed_rows: Optional[StrictStr] = Field(default=None, alias="Not_flushed_delayed_rows")
    ongoing_anonymous_transaction_count: Optional[StrictStr] = Field(default=None, alias="Ongoing_anonymous_transaction_count")
    open_files: Optional[StrictStr] = Field(default=None, alias="Open_files")
    open_streams: Optional[StrictStr] = Field(default=None, alias="Open_streams")
    open_table_definitions: Optional[StrictStr] = Field(default=None, alias="Open_table_definitions")
    open_tables: Optional[StrictStr] = Field(default=None, alias="Open_tables")
    opened_files: Optional[StrictStr] = Field(default=None, alias="Opened_files")
    opened_table_definitions: Optional[StrictStr] = Field(default=None, alias="Opened_table_definitions")
    opened_tables: Optional[StrictStr] = Field(default=None, alias="Opened_tables")
    performance_schema_accounts_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_accounts_lost")
    performance_schema_cond_classes_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_cond_classes_lost")
    performance_schema_cond_instances_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_cond_instances_lost")
    performance_schema_digest_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_digest_lost")
    performance_schema_file_classes_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_file_classes_lost")
    performance_schema_file_handles_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_file_handles_lost")
    performance_schema_file_instances_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_file_instances_lost")
    performance_schema_hosts_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_hosts_lost")
    performance_schema_index_stat_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_index_stat_lost")
    performance_schema_locker_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_locker_lost")
    performance_schema_memory_classes_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_memory_classes_lost")
    performance_schema_metadata_lock_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_metadata_lock_lost")
    performance_schema_mutex_classes_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_mutex_classes_lost")
    performance_schema_mutex_instances_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_mutex_instances_lost")
    performance_schema_nested_statement_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_nested_statement_lost")
    performance_schema_prepared_statements_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_prepared_statements_lost")
    performance_schema_program_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_program_lost")
    performance_schema_rwlock_classes_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_rwlock_classes_lost")
    performance_schema_rwlock_instances_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_rwlock_instances_lost")
    performance_schema_session_connect_attrs_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_session_connect_attrs_lost")
    performance_schema_socket_classes_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_socket_classes_lost")
    performance_schema_socket_instances_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_socket_instances_lost")
    performance_schema_stage_classes_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_stage_classes_lost")
    performance_schema_statement_classes_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_statement_classes_lost")
    performance_schema_table_handles_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_table_handles_lost")
    performance_schema_table_instances_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_table_instances_lost")
    performance_schema_table_lock_stat_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_table_lock_stat_lost")
    performance_schema_thread_classes_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_thread_classes_lost")
    performance_schema_thread_instances_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_thread_instances_lost")
    performance_schema_users_lost: Optional[StrictStr] = Field(default=None, alias="Performance_schema_users_lost")
    prepared_stmt_count: Optional[StrictStr] = Field(default=None, alias="Prepared_stmt_count")
    qcache_free_blocks: Optional[StrictStr] = Field(default=None, alias="Qcache_free_blocks")
    qcache_free_memory: Optional[StrictStr] = Field(default=None, alias="Qcache_free_memory")
    qcache_hits: Optional[StrictStr] = Field(default=None, alias="Qcache_hits")
    qcache_inserts: Optional[StrictStr] = Field(default=None, alias="Qcache_inserts")
    qcache_lowmem_prunes: Optional[StrictStr] = Field(default=None, alias="Qcache_lowmem_prunes")
    qcache_not_cached: Optional[StrictStr] = Field(default=None, alias="Qcache_not_cached")
    qcache_queries_in_cache: Optional[StrictStr] = Field(default=None, alias="Qcache_queries_in_cache")
    qcache_total_blocks: Optional[StrictStr] = Field(default=None, alias="Qcache_total_blocks")
    queries: Optional[StrictStr] = Field(default=None, alias="Queries")
    questions: Optional[StrictStr] = Field(default=None, alias="Questions")
    rsa_public_key: Optional[StrictStr] = Field(default=None, alias="Rsa_public_key")
    select_full_join: Optional[StrictStr] = Field(default=None, alias="Select_full_join")
    select_full_range_join: Optional[StrictStr] = Field(default=None, alias="Select_full_range_join")
    select_range: Optional[StrictStr] = Field(default=None, alias="Select_range")
    select_range_check: Optional[StrictStr] = Field(default=None, alias="Select_range_check")
    select_scan: Optional[StrictStr] = Field(default=None, alias="Select_scan")
    slave_open_temp_tables: Optional[StrictStr] = Field(default=None, alias="Slave_open_temp_tables")
    slow_launch_threads: Optional[StrictStr] = Field(default=None, alias="Slow_launch_threads")
    slow_queries: Optional[StrictStr] = Field(default=None, alias="Slow_queries")
    sort_merge_passes: Optional[StrictStr] = Field(default=None, alias="Sort_merge_passes")
    sort_range: Optional[StrictStr] = Field(default=None, alias="Sort_range")
    sort_rows: Optional[StrictStr] = Field(default=None, alias="Sort_rows")
    sort_scan: Optional[StrictStr] = Field(default=None, alias="Sort_scan")
    ssl_accept_renegotiates: Optional[StrictStr] = Field(default=None, alias="Ssl_accept_renegotiates")
    ssl_accepts: Optional[StrictStr] = Field(default=None, alias="Ssl_accepts")
    ssl_callback_cache_hits: Optional[StrictStr] = Field(default=None, alias="Ssl_callback_cache_hits")
    ssl_cipher: Optional[StrictStr] = Field(default=None, alias="Ssl_cipher")
    ssl_cipher_list: Optional[StrictStr] = Field(default=None, alias="Ssl_cipher_list")
    ssl_client_connects: Optional[StrictStr] = Field(default=None, alias="Ssl_client_connects")
    ssl_connect_renegotiates: Optional[StrictStr] = Field(default=None, alias="Ssl_connect_renegotiates")
    ssl_ctx_verify_depth: Optional[StrictStr] = Field(default=None, alias="Ssl_ctx_verify_depth")
    ssl_ctx_verify_mode: Optional[StrictStr] = Field(default=None, alias="Ssl_ctx_verify_mode")
    ssl_default_timeout: Optional[StrictStr] = Field(default=None, alias="Ssl_default_timeout")
    ssl_finished_accepts: Optional[StrictStr] = Field(default=None, alias="Ssl_finished_accepts")
    ssl_finished_connects: Optional[StrictStr] = Field(default=None, alias="Ssl_finished_connects")
    ssl_server_not_after: Optional[StrictStr] = Field(default=None, alias="Ssl_server_not_after")
    ssl_server_not_before: Optional[StrictStr] = Field(default=None, alias="Ssl_server_not_before")
    ssl_session_cache_hits: Optional[StrictStr] = Field(default=None, alias="Ssl_session_cache_hits")
    ssl_session_cache_misses: Optional[StrictStr] = Field(default=None, alias="Ssl_session_cache_misses")
    ssl_session_cache_mode: Optional[StrictStr] = Field(default=None, alias="Ssl_session_cache_mode")
    ssl_session_cache_overflows: Optional[StrictStr] = Field(default=None, alias="Ssl_session_cache_overflows")
    ssl_session_cache_size: Optional[StrictStr] = Field(default=None, alias="Ssl_session_cache_size")
    ssl_session_cache_timeouts: Optional[StrictStr] = Field(default=None, alias="Ssl_session_cache_timeouts")
    ssl_sessions_reused: Optional[StrictStr] = Field(default=None, alias="Ssl_sessions_reused")
    ssl_used_session_cache_entries: Optional[StrictStr] = Field(default=None, alias="Ssl_used_session_cache_entries")
    ssl_verify_depth: Optional[StrictStr] = Field(default=None, alias="Ssl_verify_depth")
    ssl_verify_mode: Optional[StrictStr] = Field(default=None, alias="Ssl_verify_mode")
    ssl_version: Optional[StrictStr] = Field(default=None, alias="Ssl_version")
    table_locks_immediate: Optional[StrictStr] = Field(default=None, alias="Table_locks_immediate")
    table_locks_waited: Optional[StrictStr] = Field(default=None, alias="Table_locks_waited")
    table_open_cache_hits: Optional[StrictStr] = Field(default=None, alias="Table_open_cache_hits")
    table_open_cache_misses: Optional[StrictStr] = Field(default=None, alias="Table_open_cache_misses")
    table_open_cache_overflows: Optional[StrictStr] = Field(default=None, alias="Table_open_cache_overflows")
    tc_log_max_pages_used: Optional[StrictStr] = Field(default=None, alias="Tc_log_max_pages_used")
    tc_log_page_size: Optional[StrictStr] = Field(default=None, alias="Tc_log_page_size")
    tc_log_page_waits: Optional[StrictStr] = Field(default=None, alias="Tc_log_page_waits")
    threadpool_idle_threads: Optional[StrictStr] = Field(default=None, alias="Threadpool_idle_threads")
    threadpool_threads: Optional[StrictStr] = Field(default=None, alias="Threadpool_threads")
    threads_cached: Optional[StrictStr] = Field(default=None, alias="Threads_cached")
    threads_connected: Optional[StrictStr] = Field(default=None, alias="Threads_connected")
    threads_created: Optional[StrictStr] = Field(default=None, alias="Threads_created")
    threads_running: Optional[StrictStr] = Field(default=None, alias="Threads_running")
    uptime: Optional[StrictStr] = Field(default=None, alias="Uptime")
    uptime_since_flush_status: Optional[StrictStr] = Field(default=None, alias="Uptime_since_flush_status")
    wsrep_local_state_uuid: Optional[StrictStr] = None
    wsrep_protocol_version: Optional[StrictStr] = None
    wsrep_last_applied: Optional[StrictStr] = None
    wsrep_last_committed: Optional[StrictStr] = None
    wsrep_replicated: Optional[StrictStr] = None
    wsrep_replicated_bytes: Optional[StrictStr] = None
    wsrep_repl_keys: Optional[StrictStr] = None
    wsrep_repl_keys_bytes: Optional[StrictStr] = None
    wsrep_repl_data_bytes: Optional[StrictStr] = None
    wsrep_repl_other_bytes: Optional[StrictStr] = None
    wsrep_received: Optional[StrictStr] = None
    wsrep_received_bytes: Optional[StrictStr] = None
    wsrep_local_commits: Optional[StrictStr] = None
    wsrep_local_cert_failures: Optional[StrictStr] = None
    wsrep_local_replays: Optional[StrictStr] = None
    wsrep_local_send_queue: Optional[StrictStr] = None
    wsrep_local_send_queue_max: Optional[StrictStr] = None
    wsrep_local_send_queue_min: Optional[StrictStr] = None
    wsrep_local_send_queue_avg: Optional[StrictStr] = None
    wsrep_local_recv_queue: Optional[StrictStr] = None
    wsrep_local_recv_queue_max: Optional[StrictStr] = None
    wsrep_local_recv_queue_min: Optional[StrictStr] = None
    wsrep_local_recv_queue_avg: Optional[StrictStr] = None
    wsrep_local_cached_downto: Optional[StrictStr] = None
    wsrep_flow_control_paused_ns: Optional[StrictStr] = None
    wsrep_flow_control_paused: Optional[StrictStr] = None
    wsrep_flow_control_sent: Optional[StrictStr] = None
    wsrep_flow_control_recv: Optional[StrictStr] = None
    wsrep_flow_control_interval: Optional[StrictStr] = None
    wsrep_flow_control_interval_low: Optional[StrictStr] = None
    wsrep_flow_control_interval_high: Optional[StrictStr] = None
    wsrep_flow_control_status: Optional[StrictStr] = None
    wsrep_flow_control_active: Optional[StrictStr] = None
    wsrep_flow_control_requested: Optional[StrictStr] = None
    wsrep_cert_deps_distance: Optional[StrictStr] = None
    wsrep_apply_oooe: Optional[StrictStr] = None
    wsrep_apply_oool: Optional[StrictStr] = None
    wsrep_apply_window: Optional[StrictStr] = None
    wsrep_commit_oooe: Optional[StrictStr] = None
    wsrep_commit_oool: Optional[StrictStr] = None
    wsrep_commit_window: Optional[StrictStr] = None
    wsrep_local_state: Optional[StrictStr] = None
    wsrep_local_state_comment: Optional[StrictStr] = None
    wsrep_cert_index_size: Optional[StrictStr] = None
    wsrep_cert_bucket_count: Optional[StrictStr] = None
    wsrep_gcache_pool_size: Optional[StrictStr] = None
    wsrep_causal_reads: Optional[StrictStr] = None
    wsrep_cert_interval: Optional[StrictStr] = None
    wsrep_open_transactions: Optional[StrictStr] = None
    wsrep_open_connections: Optional[StrictStr] = None
    wsrep_ist_receive_status: Optional[StrictStr] = None
    wsrep_ist_receive_seqno_start: Optional[StrictStr] = None
    wsrep_ist_receive_seqno_current: Optional[StrictStr] = None
    wsrep_ist_receive_seqno_end: Optional[StrictStr] = None
    wsrep_incoming_addresses: Optional[StrictStr] = None
    wsrep_cluster_weight: Optional[StrictStr] = None
    wsrep_desync_count: Optional[StrictStr] = None
    wsrep_evs_delayed: Optional[StrictStr] = None
    wsrep_evs_evict_list: Optional[StrictStr] = None
    wsrep_evs_repl_latency: Optional[StrictStr] = None
    wsrep_evs_state: Optional[StrictStr] = None
    wsrep_gcomm_uuid: Optional[StrictStr] = None
    wsrep_gmcast_segment: Optional[StrictStr] = None
    wsrep_cluster_conf_id: Optional[StrictStr] = None
    wsrep_cluster_size: Optional[StrictStr] = None
    wsrep_cluster_state_uuid: Optional[StrictStr] = None
    wsrep_cluster_status: Optional[StrictStr] = None
    wsrep_connected: Optional[StrictStr] = None
    wsrep_local_bf_aborts: Optional[StrictStr] = None
    wsrep_local_index: Optional[StrictStr] = None
    wsrep_provider_name: Optional[StrictStr] = None
    wsrep_provider_vendor: Optional[StrictStr] = None
    wsrep_provider_version: Optional[StrictStr] = None
    wsrep_ready: Optional[StrictStr] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["Aborted_clients", "Aborted_connects", "Binlog_snapshot_file", "Binlog_snapshot_position", "Binlog_cache_disk_use", "Binlog_cache_use", "Binlog_snapshot_gtid_executed", "Binlog_stmt_cache_disk_use", "Binlog_stmt_cache_use", "Bytes_received", "Bytes_sent", "Com_admin_commands", "Com_assign_to_keycache", "Com_alter_db", "Com_alter_db_upgrade", "Com_alter_event", "Com_alter_function", "Com_alter_instance", "Com_alter_procedure", "Com_alter_server", "Com_alter_table", "Com_alter_tablespace", "Com_alter_user", "Com_analyze", "Com_begin", "Com_binlog", "Com_call_procedure", "Com_change_db", "Com_change_master", "Com_change_repl_filter", "Com_check", "Com_checksum", "Com_commit", "Com_create_compression_dictionary", "Com_create_db", "Com_create_event", "Com_create_function", "Com_create_index", "Com_create_procedure", "Com_create_server", "Com_create_table", "Com_create_trigger", "Com_create_udf", "Com_create_user", "Com_create_view", "Com_dealloc_sql", "Com_delete", "Com_delete_multi", "Com_do", "Com_drop_compression_dictionary", "Com_drop_db", "Com_drop_event", "Com_drop_function", "Com_drop_index", "Com_drop_procedure", "Com_drop_server", "Com_drop_table", "Com_drop_trigger", "Com_drop_user", "Com_drop_view", "Com_empty_query", "Com_execute_sql", "Com_explain_other", "Com_flush", "Com_get_diagnostics", "Com_grant", "Com_ha_close", "Com_ha_open", "Com_ha_read", "Com_help", "Com_insert", "Com_insert_select", "Com_install_plugin", "Com_kill", "Com_load", "Com_lock_tables", "Com_lock_tables_for_backup", "Com_lock_binlog_for_backup", "Com_optimize", "Com_preload_keys", "Com_prepare_sql", "Com_purge", "Com_purge_before_date", "Com_release_savepoint", "Com_rename_table", "Com_rename_user", "Com_repair", "Com_replace", "Com_replace_select", "Com_reset", "Com_resignal", "Com_revoke", "Com_revoke_all", "Com_rollback", "Com_rollback_to_savepoint", "Com_savepoint", "Com_select", "Com_set_option", "Com_signal", "Com_show_binlog_events", "Com_show_binlogs", "Com_show_charsets", "Com_show_client_statistics", "Com_show_collations", "Com_show_create_db", "Com_show_create_event", "Com_show_create_func", "Com_show_create_proc", "Com_show_create_table", "Com_show_create_trigger", "Com_show_databases", "Com_show_engine_logs", "Com_show_engine_mutex", "Com_show_engine_status", "Com_show_events", "Com_show_errors", "Com_show_fields", "Com_show_function_code", "Com_show_function_status", "Com_show_grants", "Com_show_index_statistics", "Com_show_keys", "Com_show_master_status", "Com_show_open_tables", "Com_show_plugins", "Com_show_privileges", "Com_show_procedure_code", "Com_show_procedure_status", "Com_show_processlist", "Com_show_profile", "Com_show_profiles", "Com_show_relaylog_events", "Com_show_slave_hosts", "Com_show_slave_status", "Com_show_status", "Com_show_storage_engines", "Com_show_table_statistics", "Com_show_table_status", "Com_show_tables", "Com_show_thread_statistics", "Com_show_triggers", "Com_show_user_statistics", "Com_show_variables", "Com_show_warnings", "Com_show_create_user", "Com_shutdown", "Com_slave_start", "Com_slave_stop", "Com_group_replication_start", "Com_group_replication_stop", "Com_stmt_execute", "Com_stmt_close", "Com_stmt_fetch", "Com_stmt_prepare", "Com_stmt_reset", "Com_stmt_send_long_data", "Com_truncate", "Com_uninstall_plugin", "Com_unlock_binlog", "Com_unlock_tables", "Com_update", "Com_update_multi", "Com_xa_commit", "Com_xa_end", "Com_xa_prepare", "Com_xa_recover", "Com_xa_rollback", "Com_xa_start", "Com_stmt_reprepare", "Compression", "Connection_errors_accept", "Connection_errors_internal", "Connection_errors_max_connections", "Connection_errors_peer_address", "Connection_errors_select", "Connection_errors_tcpwrap", "Connections", "Created_tmp_disk_tables", "Created_tmp_files", "Created_tmp_tables", "Delayed_errors", "Delayed_insert_threads", "Delayed_writes", "Flush_commands", "Handler_commit", "Handler_delete", "Handler_discover", "Handler_external_lock", "Handler_mrr_init", "Handler_prepare", "Handler_read_first", "Handler_read_key", "Handler_read_last", "Handler_read_next", "Handler_read_prev", "Handler_read_rnd", "Handler_read_rnd_next", "Handler_rollback", "Handler_savepoint", "Handler_savepoint_rollback", "Handler_update", "Handler_write", "Innodb_background_log_sync", "Innodb_buffer_pool_dump_status", "Innodb_buffer_pool_load_status", "Innodb_buffer_pool_resize_status", "Innodb_buffer_pool_pages_data", "Innodb_buffer_pool_bytes_data", "Innodb_buffer_pool_pages_dirty", "Innodb_buffer_pool_bytes_dirty", "Innodb_buffer_pool_pages_flushed", "Innodb_buffer_pool_pages_free", "Innodb_buffer_pool_pages_LRU_flushed", "Innodb_buffer_pool_pages_made_not_young", "Innodb_buffer_pool_pages_made_young", "Innodb_buffer_pool_pages_misc", "Innodb_buffer_pool_pages_old", "Innodb_buffer_pool_pages_total", "Innodb_buffer_pool_read_ahead_rnd", "Innodb_buffer_pool_read_ahead", "Innodb_buffer_pool_read_ahead_evicted", "Innodb_buffer_pool_read_requests", "Innodb_buffer_pool_reads", "Innodb_buffer_pool_wait_free", "Innodb_buffer_pool_write_requests", "Innodb_checkpoint_age", "Innodb_checkpoint_max_age", "Innodb_data_fsyncs", "Innodb_data_pending_fsyncs", "Innodb_data_pending_reads", "Innodb_data_pending_writes", "Innodb_data_read", "Innodb_data_reads", "Innodb_data_writes", "Innodb_data_written", "Innodb_dblwr_pages_written", "Innodb_dblwr_writes", "Innodb_ibuf_free_list", "Innodb_ibuf_segment_size", "Innodb_log_waits", "Innodb_log_write_requests", "Innodb_log_writes", "Innodb_lsn_current", "Innodb_lsn_flushed", "Innodb_lsn_last_checkpoint", "Innodb_master_thread_active_loops", "Innodb_master_thread_idle_loops", "Innodb_max_trx_id", "Innodb_mem_adaptive_hash", "Innodb_mem_dictionary", "Innodb_oldest_view_low_limit_trx_id", "Innodb_os_log_fsyncs", "Innodb_os_log_pending_fsyncs", "Innodb_os_log_pending_writes", "Innodb_os_log_written", "Innodb_page_size", "Innodb_pages_created", "Innodb_pages_read", "Innodb_pages0_read", "Innodb_pages_written", "Innodb_purge_trx_id", "Innodb_purge_undo_no", "Innodb_row_lock_current_waits", "Innodb_row_lock_time", "Innodb_row_lock_time_avg", "Innodb_row_lock_time_max", "Innodb_row_lock_waits", "Innodb_rows_deleted", "Innodb_rows_inserted", "Innodb_rows_read", "Innodb_rows_updated", "Innodb_num_open_files", "Innodb_truncated_status_writes", "Innodb_available_undo_logs", "Innodb_secondary_index_triggered_cluster_reads", "Innodb_secondary_index_triggered_cluster_reads_avoided", "Innodb_buffered_aio_submitted", "Innodb_scan_pages_contiguous", "Innodb_scan_pages_disjointed", "Innodb_scan_pages_total_seek_distance", "Innodb_scan_data_size", "Innodb_scan_deleted_recs_size", "Innodb_scrub_background_page_reorganizations", "Innodb_scrub_background_page_splits", "Innodb_scrub_background_page_split_failures_underflow", "Innodb_scrub_background_page_split_failures_out_of_filespace", "Innodb_scrub_background_page_split_failures_missing_index", "Innodb_scrub_background_page_split_failures_unknown", "Innodb_scrub_log", "Innodb_encryption_rotation_pages_read_from_cache", "Innodb_encryption_rotation_pages_read_from_disk", "Innodb_encryption_rotation_pages_modified", "Innodb_encryption_rotation_pages_flushed", "Innodb_encryption_rotation_estimated_iops", "Innodb_encryption_key_rotation_list_length", "Innodb_encryption_n_merge_blocks_encrypted", "Innodb_encryption_n_merge_blocks_decrypted", "Innodb_encryption_n_rowlog_blocks_encrypted", "Innodb_encryption_n_rowlog_blocks_decrypted", "Innodb_num_pages_encrypted", "Innodb_num_pages_decrypted", "Innodb_encryption_redo_key_version", "Key_blocks_not_flushed", "Key_blocks_unused", "Key_blocks_used", "Key_read_requests", "Key_reads", "Key_write_requests", "Key_writes", "Last_query_cost", "Last_query_partial_plans", "Locked_connects", "Max_execution_time_exceeded", "Max_execution_time_set", "Max_execution_time_set_failed", "Max_used_connections", "Max_used_connections_time", "Not_flushed_delayed_rows", "Ongoing_anonymous_transaction_count", "Open_files", "Open_streams", "Open_table_definitions", "Open_tables", "Opened_files", "Opened_table_definitions", "Opened_tables", "Performance_schema_accounts_lost", "Performance_schema_cond_classes_lost", "Performance_schema_cond_instances_lost", "Performance_schema_digest_lost", "Performance_schema_file_classes_lost", "Performance_schema_file_handles_lost", "Performance_schema_file_instances_lost", "Performance_schema_hosts_lost", "Performance_schema_index_stat_lost", "Performance_schema_locker_lost", "Performance_schema_memory_classes_lost", "Performance_schema_metadata_lock_lost", "Performance_schema_mutex_classes_lost", "Performance_schema_mutex_instances_lost", "Performance_schema_nested_statement_lost", "Performance_schema_prepared_statements_lost", "Performance_schema_program_lost", "Performance_schema_rwlock_classes_lost", "Performance_schema_rwlock_instances_lost", "Performance_schema_session_connect_attrs_lost", "Performance_schema_socket_classes_lost", "Performance_schema_socket_instances_lost", "Performance_schema_stage_classes_lost", "Performance_schema_statement_classes_lost", "Performance_schema_table_handles_lost", "Performance_schema_table_instances_lost", "Performance_schema_table_lock_stat_lost", "Performance_schema_thread_classes_lost", "Performance_schema_thread_instances_lost", "Performance_schema_users_lost", "Prepared_stmt_count", "Qcache_free_blocks", "Qcache_free_memory", "Qcache_hits", "Qcache_inserts", "Qcache_lowmem_prunes", "Qcache_not_cached", "Qcache_queries_in_cache", "Qcache_total_blocks", "Queries", "Questions", "Rsa_public_key", "Select_full_join", "Select_full_range_join", "Select_range", "Select_range_check", "Select_scan", "Slave_open_temp_tables", "Slow_launch_threads", "Slow_queries", "Sort_merge_passes", "Sort_range", "Sort_rows", "Sort_scan", "Ssl_accept_renegotiates", "Ssl_accepts", "Ssl_callback_cache_hits", "Ssl_cipher", "Ssl_cipher_list", "Ssl_client_connects", "Ssl_connect_renegotiates", "Ssl_ctx_verify_depth", "Ssl_ctx_verify_mode", "Ssl_default_timeout", "Ssl_finished_accepts", "Ssl_finished_connects", "Ssl_server_not_after", "Ssl_server_not_before", "Ssl_session_cache_hits", "Ssl_session_cache_misses", "Ssl_session_cache_mode", "Ssl_session_cache_overflows", "Ssl_session_cache_size", "Ssl_session_cache_timeouts", "Ssl_sessions_reused", "Ssl_used_session_cache_entries", "Ssl_verify_depth", "Ssl_verify_mode", "Ssl_version", "Table_locks_immediate", "Table_locks_waited", "Table_open_cache_hits", "Table_open_cache_misses", "Table_open_cache_overflows", "Tc_log_max_pages_used", "Tc_log_page_size", "Tc_log_page_waits", "Threadpool_idle_threads", "Threadpool_threads", "Threads_cached", "Threads_connected", "Threads_created", "Threads_running", "Uptime", "Uptime_since_flush_status", "wsrep_local_state_uuid", "wsrep_protocol_version", "wsrep_last_applied", "wsrep_last_committed", "wsrep_replicated", "wsrep_replicated_bytes", "wsrep_repl_keys", "wsrep_repl_keys_bytes", "wsrep_repl_data_bytes", "wsrep_repl_other_bytes", "wsrep_received", "wsrep_received_bytes", "wsrep_local_commits", "wsrep_local_cert_failures", "wsrep_local_replays", "wsrep_local_send_queue", "wsrep_local_send_queue_max", "wsrep_local_send_queue_min", "wsrep_local_send_queue_avg", "wsrep_local_recv_queue", "wsrep_local_recv_queue_max", "wsrep_local_recv_queue_min", "wsrep_local_recv_queue_avg", "wsrep_local_cached_downto", "wsrep_flow_control_paused_ns", "wsrep_flow_control_paused", "wsrep_flow_control_sent", "wsrep_flow_control_recv", "wsrep_flow_control_interval", "wsrep_flow_control_interval_low", "wsrep_flow_control_interval_high", "wsrep_flow_control_status", "wsrep_flow_control_active", "wsrep_flow_control_requested", "wsrep_cert_deps_distance", "wsrep_apply_oooe", "wsrep_apply_oool", "wsrep_apply_window", "wsrep_commit_oooe", "wsrep_commit_oool", "wsrep_commit_window", "wsrep_local_state", "wsrep_local_state_comment", "wsrep_cert_index_size", "wsrep_cert_bucket_count", "wsrep_gcache_pool_size", "wsrep_causal_reads", "wsrep_cert_interval", "wsrep_open_transactions", "wsrep_open_connections", "wsrep_ist_receive_status", "wsrep_ist_receive_seqno_start", "wsrep_ist_receive_seqno_current", "wsrep_ist_receive_seqno_end", "wsrep_incoming_addresses", "wsrep_cluster_weight", "wsrep_desync_count", "wsrep_evs_delayed", "wsrep_evs_evict_list", "wsrep_evs_repl_latency", "wsrep_evs_state", "wsrep_gcomm_uuid", "wsrep_gmcast_segment", "wsrep_cluster_conf_id", "wsrep_cluster_size", "wsrep_cluster_state_uuid", "wsrep_cluster_status", "wsrep_connected", "wsrep_local_bf_aborts", "wsrep_local_index", "wsrep_provider_name", "wsrep_provider_vendor", "wsrep_provider_version", "wsrep_ready"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListHealth200ResponseAllOfHealthDatabaseStats from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListHealth200ResponseAllOfHealthDatabaseStats from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Aborted_clients": obj.get("Aborted_clients"),
            "Aborted_connects": obj.get("Aborted_connects"),
            "Binlog_snapshot_file": obj.get("Binlog_snapshot_file"),
            "Binlog_snapshot_position": obj.get("Binlog_snapshot_position"),
            "Binlog_cache_disk_use": obj.get("Binlog_cache_disk_use"),
            "Binlog_cache_use": obj.get("Binlog_cache_use"),
            "Binlog_snapshot_gtid_executed": obj.get("Binlog_snapshot_gtid_executed"),
            "Binlog_stmt_cache_disk_use": obj.get("Binlog_stmt_cache_disk_use"),
            "Binlog_stmt_cache_use": obj.get("Binlog_stmt_cache_use"),
            "Bytes_received": obj.get("Bytes_received"),
            "Bytes_sent": obj.get("Bytes_sent"),
            "Com_admin_commands": obj.get("Com_admin_commands"),
            "Com_assign_to_keycache": obj.get("Com_assign_to_keycache"),
            "Com_alter_db": obj.get("Com_alter_db"),
            "Com_alter_db_upgrade": obj.get("Com_alter_db_upgrade"),
            "Com_alter_event": obj.get("Com_alter_event"),
            "Com_alter_function": obj.get("Com_alter_function"),
            "Com_alter_instance": obj.get("Com_alter_instance"),
            "Com_alter_procedure": obj.get("Com_alter_procedure"),
            "Com_alter_server": obj.get("Com_alter_server"),
            "Com_alter_table": obj.get("Com_alter_table"),
            "Com_alter_tablespace": obj.get("Com_alter_tablespace"),
            "Com_alter_user": obj.get("Com_alter_user"),
            "Com_analyze": obj.get("Com_analyze"),
            "Com_begin": obj.get("Com_begin"),
            "Com_binlog": obj.get("Com_binlog"),
            "Com_call_procedure": obj.get("Com_call_procedure"),
            "Com_change_db": obj.get("Com_change_db"),
            "Com_change_master": obj.get("Com_change_master"),
            "Com_change_repl_filter": obj.get("Com_change_repl_filter"),
            "Com_check": obj.get("Com_check"),
            "Com_checksum": obj.get("Com_checksum"),
            "Com_commit": obj.get("Com_commit"),
            "Com_create_compression_dictionary": obj.get("Com_create_compression_dictionary"),
            "Com_create_db": obj.get("Com_create_db"),
            "Com_create_event": obj.get("Com_create_event"),
            "Com_create_function": obj.get("Com_create_function"),
            "Com_create_index": obj.get("Com_create_index"),
            "Com_create_procedure": obj.get("Com_create_procedure"),
            "Com_create_server": obj.get("Com_create_server"),
            "Com_create_table": obj.get("Com_create_table"),
            "Com_create_trigger": obj.get("Com_create_trigger"),
            "Com_create_udf": obj.get("Com_create_udf"),
            "Com_create_user": obj.get("Com_create_user"),
            "Com_create_view": obj.get("Com_create_view"),
            "Com_dealloc_sql": obj.get("Com_dealloc_sql"),
            "Com_delete": obj.get("Com_delete"),
            "Com_delete_multi": obj.get("Com_delete_multi"),
            "Com_do": obj.get("Com_do"),
            "Com_drop_compression_dictionary": obj.get("Com_drop_compression_dictionary"),
            "Com_drop_db": obj.get("Com_drop_db"),
            "Com_drop_event": obj.get("Com_drop_event"),
            "Com_drop_function": obj.get("Com_drop_function"),
            "Com_drop_index": obj.get("Com_drop_index"),
            "Com_drop_procedure": obj.get("Com_drop_procedure"),
            "Com_drop_server": obj.get("Com_drop_server"),
            "Com_drop_table": obj.get("Com_drop_table"),
            "Com_drop_trigger": obj.get("Com_drop_trigger"),
            "Com_drop_user": obj.get("Com_drop_user"),
            "Com_drop_view": obj.get("Com_drop_view"),
            "Com_empty_query": obj.get("Com_empty_query"),
            "Com_execute_sql": obj.get("Com_execute_sql"),
            "Com_explain_other": obj.get("Com_explain_other"),
            "Com_flush": obj.get("Com_flush"),
            "Com_get_diagnostics": obj.get("Com_get_diagnostics"),
            "Com_grant": obj.get("Com_grant"),
            "Com_ha_close": obj.get("Com_ha_close"),
            "Com_ha_open": obj.get("Com_ha_open"),
            "Com_ha_read": obj.get("Com_ha_read"),
            "Com_help": obj.get("Com_help"),
            "Com_insert": obj.get("Com_insert"),
            "Com_insert_select": obj.get("Com_insert_select"),
            "Com_install_plugin": obj.get("Com_install_plugin"),
            "Com_kill": obj.get("Com_kill"),
            "Com_load": obj.get("Com_load"),
            "Com_lock_tables": obj.get("Com_lock_tables"),
            "Com_lock_tables_for_backup": obj.get("Com_lock_tables_for_backup"),
            "Com_lock_binlog_for_backup": obj.get("Com_lock_binlog_for_backup"),
            "Com_optimize": obj.get("Com_optimize"),
            "Com_preload_keys": obj.get("Com_preload_keys"),
            "Com_prepare_sql": obj.get("Com_prepare_sql"),
            "Com_purge": obj.get("Com_purge"),
            "Com_purge_before_date": obj.get("Com_purge_before_date"),
            "Com_release_savepoint": obj.get("Com_release_savepoint"),
            "Com_rename_table": obj.get("Com_rename_table"),
            "Com_rename_user": obj.get("Com_rename_user"),
            "Com_repair": obj.get("Com_repair"),
            "Com_replace": obj.get("Com_replace"),
            "Com_replace_select": obj.get("Com_replace_select"),
            "Com_reset": obj.get("Com_reset"),
            "Com_resignal": obj.get("Com_resignal"),
            "Com_revoke": obj.get("Com_revoke"),
            "Com_revoke_all": obj.get("Com_revoke_all"),
            "Com_rollback": obj.get("Com_rollback"),
            "Com_rollback_to_savepoint": obj.get("Com_rollback_to_savepoint"),
            "Com_savepoint": obj.get("Com_savepoint"),
            "Com_select": obj.get("Com_select"),
            "Com_set_option": obj.get("Com_set_option"),
            "Com_signal": obj.get("Com_signal"),
            "Com_show_binlog_events": obj.get("Com_show_binlog_events"),
            "Com_show_binlogs": obj.get("Com_show_binlogs"),
            "Com_show_charsets": obj.get("Com_show_charsets"),
            "Com_show_client_statistics": obj.get("Com_show_client_statistics"),
            "Com_show_collations": obj.get("Com_show_collations"),
            "Com_show_create_db": obj.get("Com_show_create_db"),
            "Com_show_create_event": obj.get("Com_show_create_event"),
            "Com_show_create_func": obj.get("Com_show_create_func"),
            "Com_show_create_proc": obj.get("Com_show_create_proc"),
            "Com_show_create_table": obj.get("Com_show_create_table"),
            "Com_show_create_trigger": obj.get("Com_show_create_trigger"),
            "Com_show_databases": obj.get("Com_show_databases"),
            "Com_show_engine_logs": obj.get("Com_show_engine_logs"),
            "Com_show_engine_mutex": obj.get("Com_show_engine_mutex"),
            "Com_show_engine_status": obj.get("Com_show_engine_status"),
            "Com_show_events": obj.get("Com_show_events"),
            "Com_show_errors": obj.get("Com_show_errors"),
            "Com_show_fields": obj.get("Com_show_fields"),
            "Com_show_function_code": obj.get("Com_show_function_code"),
            "Com_show_function_status": obj.get("Com_show_function_status"),
            "Com_show_grants": obj.get("Com_show_grants"),
            "Com_show_index_statistics": obj.get("Com_show_index_statistics"),
            "Com_show_keys": obj.get("Com_show_keys"),
            "Com_show_master_status": obj.get("Com_show_master_status"),
            "Com_show_open_tables": obj.get("Com_show_open_tables"),
            "Com_show_plugins": obj.get("Com_show_plugins"),
            "Com_show_privileges": obj.get("Com_show_privileges"),
            "Com_show_procedure_code": obj.get("Com_show_procedure_code"),
            "Com_show_procedure_status": obj.get("Com_show_procedure_status"),
            "Com_show_processlist": obj.get("Com_show_processlist"),
            "Com_show_profile": obj.get("Com_show_profile"),
            "Com_show_profiles": obj.get("Com_show_profiles"),
            "Com_show_relaylog_events": obj.get("Com_show_relaylog_events"),
            "Com_show_slave_hosts": obj.get("Com_show_slave_hosts"),
            "Com_show_slave_status": obj.get("Com_show_slave_status"),
            "Com_show_status": obj.get("Com_show_status"),
            "Com_show_storage_engines": obj.get("Com_show_storage_engines"),
            "Com_show_table_statistics": obj.get("Com_show_table_statistics"),
            "Com_show_table_status": obj.get("Com_show_table_status"),
            "Com_show_tables": obj.get("Com_show_tables"),
            "Com_show_thread_statistics": obj.get("Com_show_thread_statistics"),
            "Com_show_triggers": obj.get("Com_show_triggers"),
            "Com_show_user_statistics": obj.get("Com_show_user_statistics"),
            "Com_show_variables": obj.get("Com_show_variables"),
            "Com_show_warnings": obj.get("Com_show_warnings"),
            "Com_show_create_user": obj.get("Com_show_create_user"),
            "Com_shutdown": obj.get("Com_shutdown"),
            "Com_slave_start": obj.get("Com_slave_start"),
            "Com_slave_stop": obj.get("Com_slave_stop"),
            "Com_group_replication_start": obj.get("Com_group_replication_start"),
            "Com_group_replication_stop": obj.get("Com_group_replication_stop"),
            "Com_stmt_execute": obj.get("Com_stmt_execute"),
            "Com_stmt_close": obj.get("Com_stmt_close"),
            "Com_stmt_fetch": obj.get("Com_stmt_fetch"),
            "Com_stmt_prepare": obj.get("Com_stmt_prepare"),
            "Com_stmt_reset": obj.get("Com_stmt_reset"),
            "Com_stmt_send_long_data": obj.get("Com_stmt_send_long_data"),
            "Com_truncate": obj.get("Com_truncate"),
            "Com_uninstall_plugin": obj.get("Com_uninstall_plugin"),
            "Com_unlock_binlog": obj.get("Com_unlock_binlog"),
            "Com_unlock_tables": obj.get("Com_unlock_tables"),
            "Com_update": obj.get("Com_update"),
            "Com_update_multi": obj.get("Com_update_multi"),
            "Com_xa_commit": obj.get("Com_xa_commit"),
            "Com_xa_end": obj.get("Com_xa_end"),
            "Com_xa_prepare": obj.get("Com_xa_prepare"),
            "Com_xa_recover": obj.get("Com_xa_recover"),
            "Com_xa_rollback": obj.get("Com_xa_rollback"),
            "Com_xa_start": obj.get("Com_xa_start"),
            "Com_stmt_reprepare": obj.get("Com_stmt_reprepare"),
            "Compression": obj.get("Compression"),
            "Connection_errors_accept": obj.get("Connection_errors_accept"),
            "Connection_errors_internal": obj.get("Connection_errors_internal"),
            "Connection_errors_max_connections": obj.get("Connection_errors_max_connections"),
            "Connection_errors_peer_address": obj.get("Connection_errors_peer_address"),
            "Connection_errors_select": obj.get("Connection_errors_select"),
            "Connection_errors_tcpwrap": obj.get("Connection_errors_tcpwrap"),
            "Connections": obj.get("Connections"),
            "Created_tmp_disk_tables": obj.get("Created_tmp_disk_tables"),
            "Created_tmp_files": obj.get("Created_tmp_files"),
            "Created_tmp_tables": obj.get("Created_tmp_tables"),
            "Delayed_errors": obj.get("Delayed_errors"),
            "Delayed_insert_threads": obj.get("Delayed_insert_threads"),
            "Delayed_writes": obj.get("Delayed_writes"),
            "Flush_commands": obj.get("Flush_commands"),
            "Handler_commit": obj.get("Handler_commit"),
            "Handler_delete": obj.get("Handler_delete"),
            "Handler_discover": obj.get("Handler_discover"),
            "Handler_external_lock": obj.get("Handler_external_lock"),
            "Handler_mrr_init": obj.get("Handler_mrr_init"),
            "Handler_prepare": obj.get("Handler_prepare"),
            "Handler_read_first": obj.get("Handler_read_first"),
            "Handler_read_key": obj.get("Handler_read_key"),
            "Handler_read_last": obj.get("Handler_read_last"),
            "Handler_read_next": obj.get("Handler_read_next"),
            "Handler_read_prev": obj.get("Handler_read_prev"),
            "Handler_read_rnd": obj.get("Handler_read_rnd"),
            "Handler_read_rnd_next": obj.get("Handler_read_rnd_next"),
            "Handler_rollback": obj.get("Handler_rollback"),
            "Handler_savepoint": obj.get("Handler_savepoint"),
            "Handler_savepoint_rollback": obj.get("Handler_savepoint_rollback"),
            "Handler_update": obj.get("Handler_update"),
            "Handler_write": obj.get("Handler_write"),
            "Innodb_background_log_sync": obj.get("Innodb_background_log_sync"),
            "Innodb_buffer_pool_dump_status": obj.get("Innodb_buffer_pool_dump_status"),
            "Innodb_buffer_pool_load_status": obj.get("Innodb_buffer_pool_load_status"),
            "Innodb_buffer_pool_resize_status": obj.get("Innodb_buffer_pool_resize_status"),
            "Innodb_buffer_pool_pages_data": obj.get("Innodb_buffer_pool_pages_data"),
            "Innodb_buffer_pool_bytes_data": obj.get("Innodb_buffer_pool_bytes_data"),
            "Innodb_buffer_pool_pages_dirty": obj.get("Innodb_buffer_pool_pages_dirty"),
            "Innodb_buffer_pool_bytes_dirty": obj.get("Innodb_buffer_pool_bytes_dirty"),
            "Innodb_buffer_pool_pages_flushed": obj.get("Innodb_buffer_pool_pages_flushed"),
            "Innodb_buffer_pool_pages_free": obj.get("Innodb_buffer_pool_pages_free"),
            "Innodb_buffer_pool_pages_LRU_flushed": obj.get("Innodb_buffer_pool_pages_LRU_flushed"),
            "Innodb_buffer_pool_pages_made_not_young": obj.get("Innodb_buffer_pool_pages_made_not_young"),
            "Innodb_buffer_pool_pages_made_young": obj.get("Innodb_buffer_pool_pages_made_young"),
            "Innodb_buffer_pool_pages_misc": obj.get("Innodb_buffer_pool_pages_misc"),
            "Innodb_buffer_pool_pages_old": obj.get("Innodb_buffer_pool_pages_old"),
            "Innodb_buffer_pool_pages_total": obj.get("Innodb_buffer_pool_pages_total"),
            "Innodb_buffer_pool_read_ahead_rnd": obj.get("Innodb_buffer_pool_read_ahead_rnd"),
            "Innodb_buffer_pool_read_ahead": obj.get("Innodb_buffer_pool_read_ahead"),
            "Innodb_buffer_pool_read_ahead_evicted": obj.get("Innodb_buffer_pool_read_ahead_evicted"),
            "Innodb_buffer_pool_read_requests": obj.get("Innodb_buffer_pool_read_requests"),
            "Innodb_buffer_pool_reads": obj.get("Innodb_buffer_pool_reads"),
            "Innodb_buffer_pool_wait_free": obj.get("Innodb_buffer_pool_wait_free"),
            "Innodb_buffer_pool_write_requests": obj.get("Innodb_buffer_pool_write_requests"),
            "Innodb_checkpoint_age": obj.get("Innodb_checkpoint_age"),
            "Innodb_checkpoint_max_age": obj.get("Innodb_checkpoint_max_age"),
            "Innodb_data_fsyncs": obj.get("Innodb_data_fsyncs"),
            "Innodb_data_pending_fsyncs": obj.get("Innodb_data_pending_fsyncs"),
            "Innodb_data_pending_reads": obj.get("Innodb_data_pending_reads"),
            "Innodb_data_pending_writes": obj.get("Innodb_data_pending_writes"),
            "Innodb_data_read": obj.get("Innodb_data_read"),
            "Innodb_data_reads": obj.get("Innodb_data_reads"),
            "Innodb_data_writes": obj.get("Innodb_data_writes"),
            "Innodb_data_written": obj.get("Innodb_data_written"),
            "Innodb_dblwr_pages_written": obj.get("Innodb_dblwr_pages_written"),
            "Innodb_dblwr_writes": obj.get("Innodb_dblwr_writes"),
            "Innodb_ibuf_free_list": obj.get("Innodb_ibuf_free_list"),
            "Innodb_ibuf_segment_size": obj.get("Innodb_ibuf_segment_size"),
            "Innodb_log_waits": obj.get("Innodb_log_waits"),
            "Innodb_log_write_requests": obj.get("Innodb_log_write_requests"),
            "Innodb_log_writes": obj.get("Innodb_log_writes"),
            "Innodb_lsn_current": obj.get("Innodb_lsn_current"),
            "Innodb_lsn_flushed": obj.get("Innodb_lsn_flushed"),
            "Innodb_lsn_last_checkpoint": obj.get("Innodb_lsn_last_checkpoint"),
            "Innodb_master_thread_active_loops": obj.get("Innodb_master_thread_active_loops"),
            "Innodb_master_thread_idle_loops": obj.get("Innodb_master_thread_idle_loops"),
            "Innodb_max_trx_id": obj.get("Innodb_max_trx_id"),
            "Innodb_mem_adaptive_hash": obj.get("Innodb_mem_adaptive_hash"),
            "Innodb_mem_dictionary": obj.get("Innodb_mem_dictionary"),
            "Innodb_oldest_view_low_limit_trx_id": obj.get("Innodb_oldest_view_low_limit_trx_id"),
            "Innodb_os_log_fsyncs": obj.get("Innodb_os_log_fsyncs"),
            "Innodb_os_log_pending_fsyncs": obj.get("Innodb_os_log_pending_fsyncs"),
            "Innodb_os_log_pending_writes": obj.get("Innodb_os_log_pending_writes"),
            "Innodb_os_log_written": obj.get("Innodb_os_log_written"),
            "Innodb_page_size": obj.get("Innodb_page_size"),
            "Innodb_pages_created": obj.get("Innodb_pages_created"),
            "Innodb_pages_read": obj.get("Innodb_pages_read"),
            "Innodb_pages0_read": obj.get("Innodb_pages0_read"),
            "Innodb_pages_written": obj.get("Innodb_pages_written"),
            "Innodb_purge_trx_id": obj.get("Innodb_purge_trx_id"),
            "Innodb_purge_undo_no": obj.get("Innodb_purge_undo_no"),
            "Innodb_row_lock_current_waits": obj.get("Innodb_row_lock_current_waits"),
            "Innodb_row_lock_time": obj.get("Innodb_row_lock_time"),
            "Innodb_row_lock_time_avg": obj.get("Innodb_row_lock_time_avg"),
            "Innodb_row_lock_time_max": obj.get("Innodb_row_lock_time_max"),
            "Innodb_row_lock_waits": obj.get("Innodb_row_lock_waits"),
            "Innodb_rows_deleted": obj.get("Innodb_rows_deleted"),
            "Innodb_rows_inserted": obj.get("Innodb_rows_inserted"),
            "Innodb_rows_read": obj.get("Innodb_rows_read"),
            "Innodb_rows_updated": obj.get("Innodb_rows_updated"),
            "Innodb_num_open_files": obj.get("Innodb_num_open_files"),
            "Innodb_truncated_status_writes": obj.get("Innodb_truncated_status_writes"),
            "Innodb_available_undo_logs": obj.get("Innodb_available_undo_logs"),
            "Innodb_secondary_index_triggered_cluster_reads": obj.get("Innodb_secondary_index_triggered_cluster_reads"),
            "Innodb_secondary_index_triggered_cluster_reads_avoided": obj.get("Innodb_secondary_index_triggered_cluster_reads_avoided"),
            "Innodb_buffered_aio_submitted": obj.get("Innodb_buffered_aio_submitted"),
            "Innodb_scan_pages_contiguous": obj.get("Innodb_scan_pages_contiguous"),
            "Innodb_scan_pages_disjointed": obj.get("Innodb_scan_pages_disjointed"),
            "Innodb_scan_pages_total_seek_distance": obj.get("Innodb_scan_pages_total_seek_distance"),
            "Innodb_scan_data_size": obj.get("Innodb_scan_data_size"),
            "Innodb_scan_deleted_recs_size": obj.get("Innodb_scan_deleted_recs_size"),
            "Innodb_scrub_background_page_reorganizations": obj.get("Innodb_scrub_background_page_reorganizations"),
            "Innodb_scrub_background_page_splits": obj.get("Innodb_scrub_background_page_splits"),
            "Innodb_scrub_background_page_split_failures_underflow": obj.get("Innodb_scrub_background_page_split_failures_underflow"),
            "Innodb_scrub_background_page_split_failures_out_of_filespace": obj.get("Innodb_scrub_background_page_split_failures_out_of_filespace"),
            "Innodb_scrub_background_page_split_failures_missing_index": obj.get("Innodb_scrub_background_page_split_failures_missing_index"),
            "Innodb_scrub_background_page_split_failures_unknown": obj.get("Innodb_scrub_background_page_split_failures_unknown"),
            "Innodb_scrub_log": obj.get("Innodb_scrub_log"),
            "Innodb_encryption_rotation_pages_read_from_cache": obj.get("Innodb_encryption_rotation_pages_read_from_cache"),
            "Innodb_encryption_rotation_pages_read_from_disk": obj.get("Innodb_encryption_rotation_pages_read_from_disk"),
            "Innodb_encryption_rotation_pages_modified": obj.get("Innodb_encryption_rotation_pages_modified"),
            "Innodb_encryption_rotation_pages_flushed": obj.get("Innodb_encryption_rotation_pages_flushed"),
            "Innodb_encryption_rotation_estimated_iops": obj.get("Innodb_encryption_rotation_estimated_iops"),
            "Innodb_encryption_key_rotation_list_length": obj.get("Innodb_encryption_key_rotation_list_length"),
            "Innodb_encryption_n_merge_blocks_encrypted": obj.get("Innodb_encryption_n_merge_blocks_encrypted"),
            "Innodb_encryption_n_merge_blocks_decrypted": obj.get("Innodb_encryption_n_merge_blocks_decrypted"),
            "Innodb_encryption_n_rowlog_blocks_encrypted": obj.get("Innodb_encryption_n_rowlog_blocks_encrypted"),
            "Innodb_encryption_n_rowlog_blocks_decrypted": obj.get("Innodb_encryption_n_rowlog_blocks_decrypted"),
            "Innodb_num_pages_encrypted": obj.get("Innodb_num_pages_encrypted"),
            "Innodb_num_pages_decrypted": obj.get("Innodb_num_pages_decrypted"),
            "Innodb_encryption_redo_key_version": obj.get("Innodb_encryption_redo_key_version"),
            "Key_blocks_not_flushed": obj.get("Key_blocks_not_flushed"),
            "Key_blocks_unused": obj.get("Key_blocks_unused"),
            "Key_blocks_used": obj.get("Key_blocks_used"),
            "Key_read_requests": obj.get("Key_read_requests"),
            "Key_reads": obj.get("Key_reads"),
            "Key_write_requests": obj.get("Key_write_requests"),
            "Key_writes": obj.get("Key_writes"),
            "Last_query_cost": obj.get("Last_query_cost"),
            "Last_query_partial_plans": obj.get("Last_query_partial_plans"),
            "Locked_connects": obj.get("Locked_connects"),
            "Max_execution_time_exceeded": obj.get("Max_execution_time_exceeded"),
            "Max_execution_time_set": obj.get("Max_execution_time_set"),
            "Max_execution_time_set_failed": obj.get("Max_execution_time_set_failed"),
            "Max_used_connections": obj.get("Max_used_connections"),
            "Max_used_connections_time": obj.get("Max_used_connections_time"),
            "Not_flushed_delayed_rows": obj.get("Not_flushed_delayed_rows"),
            "Ongoing_anonymous_transaction_count": obj.get("Ongoing_anonymous_transaction_count"),
            "Open_files": obj.get("Open_files"),
            "Open_streams": obj.get("Open_streams"),
            "Open_table_definitions": obj.get("Open_table_definitions"),
            "Open_tables": obj.get("Open_tables"),
            "Opened_files": obj.get("Opened_files"),
            "Opened_table_definitions": obj.get("Opened_table_definitions"),
            "Opened_tables": obj.get("Opened_tables"),
            "Performance_schema_accounts_lost": obj.get("Performance_schema_accounts_lost"),
            "Performance_schema_cond_classes_lost": obj.get("Performance_schema_cond_classes_lost"),
            "Performance_schema_cond_instances_lost": obj.get("Performance_schema_cond_instances_lost"),
            "Performance_schema_digest_lost": obj.get("Performance_schema_digest_lost"),
            "Performance_schema_file_classes_lost": obj.get("Performance_schema_file_classes_lost"),
            "Performance_schema_file_handles_lost": obj.get("Performance_schema_file_handles_lost"),
            "Performance_schema_file_instances_lost": obj.get("Performance_schema_file_instances_lost"),
            "Performance_schema_hosts_lost": obj.get("Performance_schema_hosts_lost"),
            "Performance_schema_index_stat_lost": obj.get("Performance_schema_index_stat_lost"),
            "Performance_schema_locker_lost": obj.get("Performance_schema_locker_lost"),
            "Performance_schema_memory_classes_lost": obj.get("Performance_schema_memory_classes_lost"),
            "Performance_schema_metadata_lock_lost": obj.get("Performance_schema_metadata_lock_lost"),
            "Performance_schema_mutex_classes_lost": obj.get("Performance_schema_mutex_classes_lost"),
            "Performance_schema_mutex_instances_lost": obj.get("Performance_schema_mutex_instances_lost"),
            "Performance_schema_nested_statement_lost": obj.get("Performance_schema_nested_statement_lost"),
            "Performance_schema_prepared_statements_lost": obj.get("Performance_schema_prepared_statements_lost"),
            "Performance_schema_program_lost": obj.get("Performance_schema_program_lost"),
            "Performance_schema_rwlock_classes_lost": obj.get("Performance_schema_rwlock_classes_lost"),
            "Performance_schema_rwlock_instances_lost": obj.get("Performance_schema_rwlock_instances_lost"),
            "Performance_schema_session_connect_attrs_lost": obj.get("Performance_schema_session_connect_attrs_lost"),
            "Performance_schema_socket_classes_lost": obj.get("Performance_schema_socket_classes_lost"),
            "Performance_schema_socket_instances_lost": obj.get("Performance_schema_socket_instances_lost"),
            "Performance_schema_stage_classes_lost": obj.get("Performance_schema_stage_classes_lost"),
            "Performance_schema_statement_classes_lost": obj.get("Performance_schema_statement_classes_lost"),
            "Performance_schema_table_handles_lost": obj.get("Performance_schema_table_handles_lost"),
            "Performance_schema_table_instances_lost": obj.get("Performance_schema_table_instances_lost"),
            "Performance_schema_table_lock_stat_lost": obj.get("Performance_schema_table_lock_stat_lost"),
            "Performance_schema_thread_classes_lost": obj.get("Performance_schema_thread_classes_lost"),
            "Performance_schema_thread_instances_lost": obj.get("Performance_schema_thread_instances_lost"),
            "Performance_schema_users_lost": obj.get("Performance_schema_users_lost"),
            "Prepared_stmt_count": obj.get("Prepared_stmt_count"),
            "Qcache_free_blocks": obj.get("Qcache_free_blocks"),
            "Qcache_free_memory": obj.get("Qcache_free_memory"),
            "Qcache_hits": obj.get("Qcache_hits"),
            "Qcache_inserts": obj.get("Qcache_inserts"),
            "Qcache_lowmem_prunes": obj.get("Qcache_lowmem_prunes"),
            "Qcache_not_cached": obj.get("Qcache_not_cached"),
            "Qcache_queries_in_cache": obj.get("Qcache_queries_in_cache"),
            "Qcache_total_blocks": obj.get("Qcache_total_blocks"),
            "Queries": obj.get("Queries"),
            "Questions": obj.get("Questions"),
            "Rsa_public_key": obj.get("Rsa_public_key"),
            "Select_full_join": obj.get("Select_full_join"),
            "Select_full_range_join": obj.get("Select_full_range_join"),
            "Select_range": obj.get("Select_range"),
            "Select_range_check": obj.get("Select_range_check"),
            "Select_scan": obj.get("Select_scan"),
            "Slave_open_temp_tables": obj.get("Slave_open_temp_tables"),
            "Slow_launch_threads": obj.get("Slow_launch_threads"),
            "Slow_queries": obj.get("Slow_queries"),
            "Sort_merge_passes": obj.get("Sort_merge_passes"),
            "Sort_range": obj.get("Sort_range"),
            "Sort_rows": obj.get("Sort_rows"),
            "Sort_scan": obj.get("Sort_scan"),
            "Ssl_accept_renegotiates": obj.get("Ssl_accept_renegotiates"),
            "Ssl_accepts": obj.get("Ssl_accepts"),
            "Ssl_callback_cache_hits": obj.get("Ssl_callback_cache_hits"),
            "Ssl_cipher": obj.get("Ssl_cipher"),
            "Ssl_cipher_list": obj.get("Ssl_cipher_list"),
            "Ssl_client_connects": obj.get("Ssl_client_connects"),
            "Ssl_connect_renegotiates": obj.get("Ssl_connect_renegotiates"),
            "Ssl_ctx_verify_depth": obj.get("Ssl_ctx_verify_depth"),
            "Ssl_ctx_verify_mode": obj.get("Ssl_ctx_verify_mode"),
            "Ssl_default_timeout": obj.get("Ssl_default_timeout"),
            "Ssl_finished_accepts": obj.get("Ssl_finished_accepts"),
            "Ssl_finished_connects": obj.get("Ssl_finished_connects"),
            "Ssl_server_not_after": obj.get("Ssl_server_not_after"),
            "Ssl_server_not_before": obj.get("Ssl_server_not_before"),
            "Ssl_session_cache_hits": obj.get("Ssl_session_cache_hits"),
            "Ssl_session_cache_misses": obj.get("Ssl_session_cache_misses"),
            "Ssl_session_cache_mode": obj.get("Ssl_session_cache_mode"),
            "Ssl_session_cache_overflows": obj.get("Ssl_session_cache_overflows"),
            "Ssl_session_cache_size": obj.get("Ssl_session_cache_size"),
            "Ssl_session_cache_timeouts": obj.get("Ssl_session_cache_timeouts"),
            "Ssl_sessions_reused": obj.get("Ssl_sessions_reused"),
            "Ssl_used_session_cache_entries": obj.get("Ssl_used_session_cache_entries"),
            "Ssl_verify_depth": obj.get("Ssl_verify_depth"),
            "Ssl_verify_mode": obj.get("Ssl_verify_mode"),
            "Ssl_version": obj.get("Ssl_version"),
            "Table_locks_immediate": obj.get("Table_locks_immediate"),
            "Table_locks_waited": obj.get("Table_locks_waited"),
            "Table_open_cache_hits": obj.get("Table_open_cache_hits"),
            "Table_open_cache_misses": obj.get("Table_open_cache_misses"),
            "Table_open_cache_overflows": obj.get("Table_open_cache_overflows"),
            "Tc_log_max_pages_used": obj.get("Tc_log_max_pages_used"),
            "Tc_log_page_size": obj.get("Tc_log_page_size"),
            "Tc_log_page_waits": obj.get("Tc_log_page_waits"),
            "Threadpool_idle_threads": obj.get("Threadpool_idle_threads"),
            "Threadpool_threads": obj.get("Threadpool_threads"),
            "Threads_cached": obj.get("Threads_cached"),
            "Threads_connected": obj.get("Threads_connected"),
            "Threads_created": obj.get("Threads_created"),
            "Threads_running": obj.get("Threads_running"),
            "Uptime": obj.get("Uptime"),
            "Uptime_since_flush_status": obj.get("Uptime_since_flush_status"),
            "wsrep_local_state_uuid": obj.get("wsrep_local_state_uuid"),
            "wsrep_protocol_version": obj.get("wsrep_protocol_version"),
            "wsrep_last_applied": obj.get("wsrep_last_applied"),
            "wsrep_last_committed": obj.get("wsrep_last_committed"),
            "wsrep_replicated": obj.get("wsrep_replicated"),
            "wsrep_replicated_bytes": obj.get("wsrep_replicated_bytes"),
            "wsrep_repl_keys": obj.get("wsrep_repl_keys"),
            "wsrep_repl_keys_bytes": obj.get("wsrep_repl_keys_bytes"),
            "wsrep_repl_data_bytes": obj.get("wsrep_repl_data_bytes"),
            "wsrep_repl_other_bytes": obj.get("wsrep_repl_other_bytes"),
            "wsrep_received": obj.get("wsrep_received"),
            "wsrep_received_bytes": obj.get("wsrep_received_bytes"),
            "wsrep_local_commits": obj.get("wsrep_local_commits"),
            "wsrep_local_cert_failures": obj.get("wsrep_local_cert_failures"),
            "wsrep_local_replays": obj.get("wsrep_local_replays"),
            "wsrep_local_send_queue": obj.get("wsrep_local_send_queue"),
            "wsrep_local_send_queue_max": obj.get("wsrep_local_send_queue_max"),
            "wsrep_local_send_queue_min": obj.get("wsrep_local_send_queue_min"),
            "wsrep_local_send_queue_avg": obj.get("wsrep_local_send_queue_avg"),
            "wsrep_local_recv_queue": obj.get("wsrep_local_recv_queue"),
            "wsrep_local_recv_queue_max": obj.get("wsrep_local_recv_queue_max"),
            "wsrep_local_recv_queue_min": obj.get("wsrep_local_recv_queue_min"),
            "wsrep_local_recv_queue_avg": obj.get("wsrep_local_recv_queue_avg"),
            "wsrep_local_cached_downto": obj.get("wsrep_local_cached_downto"),
            "wsrep_flow_control_paused_ns": obj.get("wsrep_flow_control_paused_ns"),
            "wsrep_flow_control_paused": obj.get("wsrep_flow_control_paused"),
            "wsrep_flow_control_sent": obj.get("wsrep_flow_control_sent"),
            "wsrep_flow_control_recv": obj.get("wsrep_flow_control_recv"),
            "wsrep_flow_control_interval": obj.get("wsrep_flow_control_interval"),
            "wsrep_flow_control_interval_low": obj.get("wsrep_flow_control_interval_low"),
            "wsrep_flow_control_interval_high": obj.get("wsrep_flow_control_interval_high"),
            "wsrep_flow_control_status": obj.get("wsrep_flow_control_status"),
            "wsrep_flow_control_active": obj.get("wsrep_flow_control_active"),
            "wsrep_flow_control_requested": obj.get("wsrep_flow_control_requested"),
            "wsrep_cert_deps_distance": obj.get("wsrep_cert_deps_distance"),
            "wsrep_apply_oooe": obj.get("wsrep_apply_oooe"),
            "wsrep_apply_oool": obj.get("wsrep_apply_oool"),
            "wsrep_apply_window": obj.get("wsrep_apply_window"),
            "wsrep_commit_oooe": obj.get("wsrep_commit_oooe"),
            "wsrep_commit_oool": obj.get("wsrep_commit_oool"),
            "wsrep_commit_window": obj.get("wsrep_commit_window"),
            "wsrep_local_state": obj.get("wsrep_local_state"),
            "wsrep_local_state_comment": obj.get("wsrep_local_state_comment"),
            "wsrep_cert_index_size": obj.get("wsrep_cert_index_size"),
            "wsrep_cert_bucket_count": obj.get("wsrep_cert_bucket_count"),
            "wsrep_gcache_pool_size": obj.get("wsrep_gcache_pool_size"),
            "wsrep_causal_reads": obj.get("wsrep_causal_reads"),
            "wsrep_cert_interval": obj.get("wsrep_cert_interval"),
            "wsrep_open_transactions": obj.get("wsrep_open_transactions"),
            "wsrep_open_connections": obj.get("wsrep_open_connections"),
            "wsrep_ist_receive_status": obj.get("wsrep_ist_receive_status"),
            "wsrep_ist_receive_seqno_start": obj.get("wsrep_ist_receive_seqno_start"),
            "wsrep_ist_receive_seqno_current": obj.get("wsrep_ist_receive_seqno_current"),
            "wsrep_ist_receive_seqno_end": obj.get("wsrep_ist_receive_seqno_end"),
            "wsrep_incoming_addresses": obj.get("wsrep_incoming_addresses"),
            "wsrep_cluster_weight": obj.get("wsrep_cluster_weight"),
            "wsrep_desync_count": obj.get("wsrep_desync_count"),
            "wsrep_evs_delayed": obj.get("wsrep_evs_delayed"),
            "wsrep_evs_evict_list": obj.get("wsrep_evs_evict_list"),
            "wsrep_evs_repl_latency": obj.get("wsrep_evs_repl_latency"),
            "wsrep_evs_state": obj.get("wsrep_evs_state"),
            "wsrep_gcomm_uuid": obj.get("wsrep_gcomm_uuid"),
            "wsrep_gmcast_segment": obj.get("wsrep_gmcast_segment"),
            "wsrep_cluster_conf_id": obj.get("wsrep_cluster_conf_id"),
            "wsrep_cluster_size": obj.get("wsrep_cluster_size"),
            "wsrep_cluster_state_uuid": obj.get("wsrep_cluster_state_uuid"),
            "wsrep_cluster_status": obj.get("wsrep_cluster_status"),
            "wsrep_connected": obj.get("wsrep_connected"),
            "wsrep_local_bf_aborts": obj.get("wsrep_local_bf_aborts"),
            "wsrep_local_index": obj.get("wsrep_local_index"),
            "wsrep_provider_name": obj.get("wsrep_provider_name"),
            "wsrep_provider_vendor": obj.get("wsrep_provider_vendor"),
            "wsrep_provider_version": obj.get("wsrep_provider_version"),
            "wsrep_ready": obj.get("wsrep_ready")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


