# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_hosts200_response_all_of_servers_inner_config_create_user import ListHosts200ResponseAllOfServersInnerConfigCreateUser
from typing import Optional, Set
from typing_extensions import Self

class ListHosts200ResponseAllOfServersInnerConfig(BaseModel):
    """
    ListHosts200ResponseAllOfServersInnerConfig
    """ # noqa: E501
    pool_provider_type: Optional[StrictStr] = Field(default=None, alias="poolProviderType")
    is_vpc_selectable: Optional[StrictBool] = Field(default=None, alias="isVpcSelectable")
    smbios_asset_tag: Optional[StrictStr] = Field(default=None, alias="smbiosAssetTag")
    is_ec2: Optional[StrictBool] = Field(default=None, alias="isEC2")
    resource_pool_id: Optional[StrictInt] = Field(default=None, alias="resourcePoolId")
    host_id: Optional[StrictInt] = Field(default=None, alias="hostId")
    create_user: Optional[ListHosts200ResponseAllOfServersInnerConfigCreateUser] = Field(default=None, alias="createUser")
    nested_virtualization: Optional[StrictStr] = Field(default=None, alias="nestedVirtualization")
    vmware_folder_id: Optional[StrictStr] = Field(default=None, alias="vmwareFolderId")
    no_agent: Optional[StrictBool] = Field(default=None, alias="noAgent")
    power_schedule_type: Optional[StrictInt] = Field(default=None, alias="powerScheduleType")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["poolProviderType", "isVpcSelectable", "smbiosAssetTag", "isEC2", "resourcePoolId", "hostId", "createUser", "nestedVirtualization", "vmwareFolderId", "noAgent", "powerScheduleType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListHosts200ResponseAllOfServersInnerConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of create_user
        if self.create_user:
            _dict['createUser'] = self.create_user.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if pool_provider_type (nullable) is None
        # and model_fields_set contains the field
        if self.pool_provider_type is None and "pool_provider_type" in self.model_fields_set:
            _dict['poolProviderType'] = None

        # set to None if smbios_asset_tag (nullable) is None
        # and model_fields_set contains the field
        if self.smbios_asset_tag is None and "smbios_asset_tag" in self.model_fields_set:
            _dict['smbiosAssetTag'] = None

        # set to None if host_id (nullable) is None
        # and model_fields_set contains the field
        if self.host_id is None and "host_id" in self.model_fields_set:
            _dict['hostId'] = None

        # set to None if nested_virtualization (nullable) is None
        # and model_fields_set contains the field
        if self.nested_virtualization is None and "nested_virtualization" in self.model_fields_set:
            _dict['nestedVirtualization'] = None

        # set to None if power_schedule_type (nullable) is None
        # and model_fields_set contains the field
        if self.power_schedule_type is None and "power_schedule_type" in self.model_fields_set:
            _dict['powerScheduleType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListHosts200ResponseAllOfServersInnerConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "poolProviderType": obj.get("poolProviderType"),
            "isVpcSelectable": obj.get("isVpcSelectable"),
            "smbiosAssetTag": obj.get("smbiosAssetTag"),
            "isEC2": obj.get("isEC2"),
            "resourcePoolId": obj.get("resourcePoolId"),
            "hostId": obj.get("hostId"),
            "createUser": ListHosts200ResponseAllOfServersInnerConfigCreateUser.from_dict(obj["createUser"]) if obj.get("createUser") is not None else None,
            "nestedVirtualization": obj.get("nestedVirtualization"),
            "vmwareFolderId": obj.get("vmwareFolderId"),
            "noAgent": obj.get("noAgent"),
            "powerScheduleType": obj.get("powerScheduleType")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


