# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf5Config(BaseModel):
    """
    ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf5Config
    """ # noqa: E501
    role_attribute_name: Optional[StrictStr] = Field(default=None, alias="roleAttributeName")
    required_attribute_value: Optional[StrictStr] = Field(default=None, alias="requiredAttributeValue")
    given_name_attribute: Optional[StrictStr] = Field(default=None, alias="givenNameAttribute")
    surname_attribute: Optional[StrictStr] = Field(default=None, alias="surnameAttribute")
    logout_url: Optional[StrictStr] = Field(default=None, alias="logoutUrl")
    do_not_include_saml_request: Optional[StrictBool] = Field(default=None, alias="doNotIncludeSAMLRequest")
    public_key: Optional[StrictStr] = Field(default=None, alias="publicKey")
    email_attribute: Optional[StrictStr] = Field(default=None, alias="emailAttribute")
    url: Optional[StrictStr] = None
    do_not_validate_signature: Optional[StrictBool] = Field(default=None, alias="doNotValidateSignature")
    do_not_validate_status_code: Optional[StrictBool] = Field(default=None, alias="doNotValidateStatusCode")
    do_not_validate_destination: Optional[StrictBool] = Field(default=None, alias="doNotValidateDestination")
    do_not_validate_issue_instants: Optional[StrictBool] = Field(default=None, alias="doNotValidateIssueInstants")
    do_not_validate_assertions: Optional[StrictBool] = Field(default=None, alias="doNotValidateAssertions")
    do_not_validate_auth_statements: Optional[StrictBool] = Field(default=None, alias="doNotValidateAuthStatements")
    do_not_validate_subject: Optional[StrictBool] = Field(default=None, alias="doNotValidateSubject")
    do_not_validate_conditions: Optional[StrictBool] = Field(default=None, alias="doNotValidateConditions")
    do_not_validate_audiences: Optional[StrictBool] = Field(default=None, alias="doNotValidateAudiences")
    do_not_validate_subject_recipients: Optional[StrictBool] = Field(default=None, alias="doNotValidateSubjectRecipients")
    saml_signature_mode: Optional[StrictStr] = Field(default=None, alias="SAMLSignatureMode")
    force_authn: Optional[StrictBool] = Field(default=None, alias="forceAuthn")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["roleAttributeName", "requiredAttributeValue", "givenNameAttribute", "surnameAttribute", "logoutUrl", "doNotIncludeSAMLRequest", "publicKey", "emailAttribute", "url", "doNotValidateSignature", "doNotValidateStatusCode", "doNotValidateDestination", "doNotValidateIssueInstants", "doNotValidateAssertions", "doNotValidateAuthStatements", "doNotValidateSubject", "doNotValidateConditions", "doNotValidateAudiences", "doNotValidateSubjectRecipients", "SAMLSignatureMode", "forceAuthn"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf5Config from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf5Config from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "roleAttributeName": obj.get("roleAttributeName"),
            "requiredAttributeValue": obj.get("requiredAttributeValue"),
            "givenNameAttribute": obj.get("givenNameAttribute"),
            "surnameAttribute": obj.get("surnameAttribute"),
            "logoutUrl": obj.get("logoutUrl"),
            "doNotIncludeSAMLRequest": obj.get("doNotIncludeSAMLRequest"),
            "publicKey": obj.get("publicKey"),
            "emailAttribute": obj.get("emailAttribute"),
            "url": obj.get("url"),
            "doNotValidateSignature": obj.get("doNotValidateSignature"),
            "doNotValidateStatusCode": obj.get("doNotValidateStatusCode"),
            "doNotValidateDestination": obj.get("doNotValidateDestination"),
            "doNotValidateIssueInstants": obj.get("doNotValidateIssueInstants"),
            "doNotValidateAssertions": obj.get("doNotValidateAssertions"),
            "doNotValidateAuthStatements": obj.get("doNotValidateAuthStatements"),
            "doNotValidateSubject": obj.get("doNotValidateSubject"),
            "doNotValidateConditions": obj.get("doNotValidateConditions"),
            "doNotValidateAudiences": obj.get("doNotValidateAudiences"),
            "doNotValidateSubjectRecipients": obj.get("doNotValidateSubjectRecipients"),
            "SAMLSignatureMode": obj.get("SAMLSignatureMode"),
            "forceAuthn": obj.get("forceAuthn")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


