# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_activity200_response_all_of_activity_inner_activity_inner_user import ListActivity200ResponseAllOfActivityInnerActivityInnerUser
from morpheus.models.list_apps200_response_all_of_apps_inner_blueprint import ListApps200ResponseAllOfAppsInnerBlueprint
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from morpheus.models.list_guidances200_response_all_of_discoveries_inner_any_of_resource_controllers_inner import ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceControllersInner
from morpheus.models.list_instances200_response_all_of_instances_inner_cluster import ListInstances200ResponseAllOfInstancesInnerCluster
from morpheus.models.list_instances200_response_all_of_instances_inner_config import ListInstances200ResponseAllOfInstancesInnerConfig
from morpheus.models.list_instances200_response_all_of_instances_inner_connection_info_inner import ListInstances200ResponseAllOfInstancesInnerConnectionInfoInner
from morpheus.models.list_instances200_response_all_of_instances_inner_evars_inner import ListInstances200ResponseAllOfInstancesInnerEvarsInner
from morpheus.models.list_instances200_response_all_of_instances_inner_instance_price import ListInstances200ResponseAllOfInstancesInnerInstancePrice
from morpheus.models.list_instances200_response_all_of_instances_inner_instance_type import ListInstances200ResponseAllOfInstancesInnerInstanceType
from morpheus.models.list_instances200_response_all_of_instances_inner_interfaces_inner import ListInstances200ResponseAllOfInstancesInnerInterfacesInner
from morpheus.models.list_instances200_response_all_of_instances_inner_layout import ListInstances200ResponseAllOfInstancesInnerLayout
from morpheus.models.list_instances200_response_all_of_instances_inner_stats import ListInstances200ResponseAllOfInstancesInnerStats
from morpheus.models.list_instances200_response_all_of_instances_inner_tags_inner import ListInstances200ResponseAllOfInstancesInnerTagsInner
from morpheus.models.list_instances200_response_all_of_instances_inner_volumes_inner import ListInstances200ResponseAllOfInstancesInnerVolumesInner
from typing import Optional, Set
from typing_extensions import Self

class ListInstances200ResponseAllOfInstancesInner(BaseModel):
    """
    ListInstances200ResponseAllOfInstancesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    uuid: Optional[StrictStr] = None
    account_id: Optional[StrictInt] = Field(default=None, alias="accountId")
    tenant: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    instance_type: Optional[ListInstances200ResponseAllOfInstancesInnerInstanceType] = Field(default=None, alias="instanceType")
    group: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    cloud: Optional[ListApps200ResponseAllOfAppsInnerBlueprint] = None
    cluster: Optional[ListInstances200ResponseAllOfInstancesInnerCluster] = None
    containers: Optional[List[StrictInt]] = None
    servers: Optional[List[StrictInt]] = None
    connection_info: Optional[List[ListInstances200ResponseAllOfInstancesInnerConnectionInfoInner]] = Field(default=None, alias="connectionInfo")
    layout: Optional[ListInstances200ResponseAllOfInstancesInnerLayout] = None
    plan: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = None
    name: Optional[StrictStr] = None
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    description: Optional[StrictStr] = None
    environment: Optional[StrictStr] = None
    config: Optional[ListInstances200ResponseAllOfInstancesInnerConfig] = None
    config_group: Optional[StrictStr] = Field(default=None, alias="configGroup")
    config_id: Optional[StrictStr] = Field(default=None, alias="configId")
    config_role: Optional[StrictStr] = Field(default=None, alias="configRole")
    volumes: Optional[List[ListInstances200ResponseAllOfInstancesInnerVolumesInner]] = None
    controllers: Optional[List[ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceControllersInner]] = None
    interfaces: Optional[List[ListInstances200ResponseAllOfInstancesInnerInterfacesInner]] = None
    custom_options: Optional[Dict[str, Any]] = Field(default=None, alias="customOptions")
    instance_version: Optional[StrictStr] = Field(default=None, alias="instanceVersion")
    labels: Optional[List[StrictStr]] = None
    tags: Optional[List[ListInstances200ResponseAllOfInstancesInnerTagsInner]] = None
    evars: Optional[List[ListInstances200ResponseAllOfInstancesInnerEvarsInner]] = None
    max_memory: Optional[StrictInt] = Field(default=None, alias="maxMemory")
    max_storage: Optional[StrictInt] = Field(default=None, alias="maxStorage")
    max_cores: Optional[StrictInt] = Field(default=None, alias="maxCores")
    cores_per_socket: Optional[StrictInt] = Field(default=None, alias="coresPerSocket")
    max_cpu: Optional[StrictStr] = Field(default=None, alias="maxCpu")
    hourly_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="hourlyCost")
    hourly_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="hourlyPrice")
    instance_price: Optional[ListInstances200ResponseAllOfInstancesInnerInstancePrice] = Field(default=None, alias="instancePrice")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    host_name: Optional[StrictStr] = Field(default=None, alias="hostName")
    domain_name: Optional[StrictStr] = Field(default=None, alias="domainName")
    environment_prefix: Optional[StrictStr] = Field(default=None, alias="environmentPrefix")
    firewall_enabled: Optional[StrictBool] = Field(default=None, alias="firewallEnabled")
    network_level: Optional[StrictStr] = Field(default=None, alias="networkLevel")
    auto_scale: Optional[StrictBool] = Field(default=None, alias="autoScale")
    instance_context: Optional[StrictStr] = Field(default=None, alias="instanceContext")
    current_deploy_id: Optional[StrictStr] = Field(default=None, alias="currentDeployId")
    locked: Optional[StrictBool] = None
    status: Optional[StrictStr] = None
    status_message: Optional[StrictStr] = Field(default=None, alias="statusMessage")
    error_message: Optional[StrictStr] = Field(default=None, alias="errorMessage")
    status_date: Optional[datetime] = Field(default=None, alias="statusDate")
    status_percent: Optional[StrictStr] = Field(default=None, alias="statusPercent")
    status_eta: Optional[StrictStr] = Field(default=None, alias="statusEta")
    user_status: Optional[StrictStr] = Field(default=None, alias="userStatus")
    expire_days: Optional[StrictInt] = Field(default=None, alias="expireDays")
    renew_days: Optional[StrictInt] = Field(default=None, alias="renewDays")
    expire_count: Optional[StrictInt] = Field(default=None, alias="expireCount")
    expire_date: Optional[datetime] = Field(default=None, alias="expireDate")
    expire_warning_date: Optional[datetime] = Field(default=None, alias="expireWarningDate")
    expire_warning_sent: Optional[StrictBool] = Field(default=None, alias="expireWarningSent")
    shutdown_days: Optional[StrictInt] = Field(default=None, alias="shutdownDays")
    shutdown_renew_days: Optional[StrictInt] = Field(default=None, alias="shutdownRenewDays")
    shutdown_count: Optional[StrictInt] = Field(default=None, alias="shutdownCount")
    shutdown_date: Optional[datetime] = Field(default=None, alias="shutdownDate")
    shutdown_warning_date: Optional[datetime] = Field(default=None, alias="shutdownWarningDate")
    shutdown_warning_sent: Optional[StrictBool] = Field(default=None, alias="shutdownWarningSent")
    removal_date: Optional[datetime] = Field(default=None, alias="removalDate")
    created_by: Optional[ListActivity200ResponseAllOfActivityInnerActivityInnerUser] = Field(default=None, alias="createdBy")
    owner: Optional[ListActivity200ResponseAllOfActivityInnerActivityInnerUser] = None
    notes: Optional[StrictStr] = None
    stats: Optional[ListInstances200ResponseAllOfInstancesInnerStats] = None
    power_schedule: Optional[StrictStr] = Field(default=None, alias="powerSchedule")
    is_scalable: Optional[StrictBool] = Field(default=None, alias="isScalable")
    instance_threshold: Optional[Dict[str, Any]] = Field(default=None, alias="instanceThreshold")
    is_busy: Optional[StrictBool] = Field(default=None, alias="isBusy")
    apps: Optional[List[Dict[str, Any]]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "uuid", "accountId", "tenant", "instanceType", "group", "cloud", "cluster", "containers", "servers", "connectionInfo", "layout", "plan", "name", "displayName", "description", "environment", "config", "configGroup", "configId", "configRole", "volumes", "controllers", "interfaces", "customOptions", "instanceVersion", "labels", "tags", "evars", "maxMemory", "maxStorage", "maxCores", "coresPerSocket", "maxCpu", "hourlyCost", "hourlyPrice", "instancePrice", "dateCreated", "lastUpdated", "hostName", "domainName", "environmentPrefix", "firewallEnabled", "networkLevel", "autoScale", "instanceContext", "currentDeployId", "locked", "status", "statusMessage", "errorMessage", "statusDate", "statusPercent", "statusEta", "userStatus", "expireDays", "renewDays", "expireCount", "expireDate", "expireWarningDate", "expireWarningSent", "shutdownDays", "shutdownRenewDays", "shutdownCount", "shutdownDate", "shutdownWarningDate", "shutdownWarningSent", "removalDate", "createdBy", "owner", "notes", "stats", "powerSchedule", "isScalable", "instanceThreshold", "isBusy", "apps"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListInstances200ResponseAllOfInstancesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tenant
        if self.tenant:
            _dict['tenant'] = self.tenant.to_dict()
        # override the default output from pydantic by calling `to_dict()` of instance_type
        if self.instance_type:
            _dict['instanceType'] = self.instance_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of group
        if self.group:
            _dict['group'] = self.group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cloud
        if self.cloud:
            _dict['cloud'] = self.cloud.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cluster
        if self.cluster:
            _dict['cluster'] = self.cluster.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in connection_info (list)
        _items = []
        if self.connection_info:
            for _item_connection_info in self.connection_info:
                if _item_connection_info:
                    _items.append(_item_connection_info.to_dict())
            _dict['connectionInfo'] = _items
        # override the default output from pydantic by calling `to_dict()` of layout
        if self.layout:
            _dict['layout'] = self.layout.to_dict()
        # override the default output from pydantic by calling `to_dict()` of plan
        if self.plan:
            _dict['plan'] = self.plan.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in volumes (list)
        _items = []
        if self.volumes:
            for _item_volumes in self.volumes:
                if _item_volumes:
                    _items.append(_item_volumes.to_dict())
            _dict['volumes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in controllers (list)
        _items = []
        if self.controllers:
            for _item_controllers in self.controllers:
                if _item_controllers:
                    _items.append(_item_controllers.to_dict())
            _dict['controllers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in interfaces (list)
        _items = []
        if self.interfaces:
            for _item_interfaces in self.interfaces:
                if _item_interfaces:
                    _items.append(_item_interfaces.to_dict())
            _dict['interfaces'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in evars (list)
        _items = []
        if self.evars:
            for _item_evars in self.evars:
                if _item_evars:
                    _items.append(_item_evars.to_dict())
            _dict['evars'] = _items
        # override the default output from pydantic by calling `to_dict()` of instance_price
        if self.instance_price:
            _dict['instancePrice'] = self.instance_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stats
        if self.stats:
            _dict['stats'] = self.stats.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if environment (nullable) is None
        # and model_fields_set contains the field
        if self.environment is None and "environment" in self.model_fields_set:
            _dict['environment'] = None

        # set to None if config_group (nullable) is None
        # and model_fields_set contains the field
        if self.config_group is None and "config_group" in self.model_fields_set:
            _dict['configGroup'] = None

        # set to None if config_id (nullable) is None
        # and model_fields_set contains the field
        if self.config_id is None and "config_id" in self.model_fields_set:
            _dict['configId'] = None

        # set to None if config_role (nullable) is None
        # and model_fields_set contains the field
        if self.config_role is None and "config_role" in self.model_fields_set:
            _dict['configRole'] = None

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        # set to None if cores_per_socket (nullable) is None
        # and model_fields_set contains the field
        if self.cores_per_socket is None and "cores_per_socket" in self.model_fields_set:
            _dict['coresPerSocket'] = None

        # set to None if max_cpu (nullable) is None
        # and model_fields_set contains the field
        if self.max_cpu is None and "max_cpu" in self.model_fields_set:
            _dict['maxCpu'] = None

        # set to None if domain_name (nullable) is None
        # and model_fields_set contains the field
        if self.domain_name is None and "domain_name" in self.model_fields_set:
            _dict['domainName'] = None

        # set to None if environment_prefix (nullable) is None
        # and model_fields_set contains the field
        if self.environment_prefix is None and "environment_prefix" in self.model_fields_set:
            _dict['environmentPrefix'] = None

        # set to None if instance_context (nullable) is None
        # and model_fields_set contains the field
        if self.instance_context is None and "instance_context" in self.model_fields_set:
            _dict['instanceContext'] = None

        # set to None if current_deploy_id (nullable) is None
        # and model_fields_set contains the field
        if self.current_deploy_id is None and "current_deploy_id" in self.model_fields_set:
            _dict['currentDeployId'] = None

        # set to None if status_message (nullable) is None
        # and model_fields_set contains the field
        if self.status_message is None and "status_message" in self.model_fields_set:
            _dict['statusMessage'] = None

        # set to None if error_message (nullable) is None
        # and model_fields_set contains the field
        if self.error_message is None and "error_message" in self.model_fields_set:
            _dict['errorMessage'] = None

        # set to None if status_percent (nullable) is None
        # and model_fields_set contains the field
        if self.status_percent is None and "status_percent" in self.model_fields_set:
            _dict['statusPercent'] = None

        # set to None if status_eta (nullable) is None
        # and model_fields_set contains the field
        if self.status_eta is None and "status_eta" in self.model_fields_set:
            _dict['statusEta'] = None

        # set to None if user_status (nullable) is None
        # and model_fields_set contains the field
        if self.user_status is None and "user_status" in self.model_fields_set:
            _dict['userStatus'] = None

        # set to None if removal_date (nullable) is None
        # and model_fields_set contains the field
        if self.removal_date is None and "removal_date" in self.model_fields_set:
            _dict['removalDate'] = None

        # set to None if notes (nullable) is None
        # and model_fields_set contains the field
        if self.notes is None and "notes" in self.model_fields_set:
            _dict['notes'] = None

        # set to None if power_schedule (nullable) is None
        # and model_fields_set contains the field
        if self.power_schedule is None and "power_schedule" in self.model_fields_set:
            _dict['powerSchedule'] = None

        # set to None if instance_threshold (nullable) is None
        # and model_fields_set contains the field
        if self.instance_threshold is None and "instance_threshold" in self.model_fields_set:
            _dict['instanceThreshold'] = None

        # set to None if apps (nullable) is None
        # and model_fields_set contains the field
        if self.apps is None and "apps" in self.model_fields_set:
            _dict['apps'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListInstances200ResponseAllOfInstancesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "uuid": obj.get("uuid"),
            "accountId": obj.get("accountId"),
            "tenant": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["tenant"]) if obj.get("tenant") is not None else None,
            "instanceType": ListInstances200ResponseAllOfInstancesInnerInstanceType.from_dict(obj["instanceType"]) if obj.get("instanceType") is not None else None,
            "group": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["group"]) if obj.get("group") is not None else None,
            "cloud": ListApps200ResponseAllOfAppsInnerBlueprint.from_dict(obj["cloud"]) if obj.get("cloud") is not None else None,
            "cluster": ListInstances200ResponseAllOfInstancesInnerCluster.from_dict(obj["cluster"]) if obj.get("cluster") is not None else None,
            "containers": obj.get("containers"),
            "servers": obj.get("servers"),
            "connectionInfo": [ListInstances200ResponseAllOfInstancesInnerConnectionInfoInner.from_dict(_item) for _item in obj["connectionInfo"]] if obj.get("connectionInfo") is not None else None,
            "layout": ListInstances200ResponseAllOfInstancesInnerLayout.from_dict(obj["layout"]) if obj.get("layout") is not None else None,
            "plan": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["plan"]) if obj.get("plan") is not None else None,
            "name": obj.get("name"),
            "displayName": obj.get("displayName"),
            "description": obj.get("description"),
            "environment": obj.get("environment"),
            "config": ListInstances200ResponseAllOfInstancesInnerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "configGroup": obj.get("configGroup"),
            "configId": obj.get("configId"),
            "configRole": obj.get("configRole"),
            "volumes": [ListInstances200ResponseAllOfInstancesInnerVolumesInner.from_dict(_item) for _item in obj["volumes"]] if obj.get("volumes") is not None else None,
            "controllers": [ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceControllersInner.from_dict(_item) for _item in obj["controllers"]] if obj.get("controllers") is not None else None,
            "interfaces": [ListInstances200ResponseAllOfInstancesInnerInterfacesInner.from_dict(_item) for _item in obj["interfaces"]] if obj.get("interfaces") is not None else None,
            "customOptions": obj.get("customOptions"),
            "instanceVersion": obj.get("instanceVersion"),
            "labels": obj.get("labels"),
            "tags": [ListInstances200ResponseAllOfInstancesInnerTagsInner.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "evars": [ListInstances200ResponseAllOfInstancesInnerEvarsInner.from_dict(_item) for _item in obj["evars"]] if obj.get("evars") is not None else None,
            "maxMemory": obj.get("maxMemory"),
            "maxStorage": obj.get("maxStorage"),
            "maxCores": obj.get("maxCores"),
            "coresPerSocket": obj.get("coresPerSocket"),
            "maxCpu": obj.get("maxCpu"),
            "hourlyCost": obj.get("hourlyCost"),
            "hourlyPrice": obj.get("hourlyPrice"),
            "instancePrice": ListInstances200ResponseAllOfInstancesInnerInstancePrice.from_dict(obj["instancePrice"]) if obj.get("instancePrice") is not None else None,
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "hostName": obj.get("hostName"),
            "domainName": obj.get("domainName"),
            "environmentPrefix": obj.get("environmentPrefix"),
            "firewallEnabled": obj.get("firewallEnabled"),
            "networkLevel": obj.get("networkLevel"),
            "autoScale": obj.get("autoScale"),
            "instanceContext": obj.get("instanceContext"),
            "currentDeployId": obj.get("currentDeployId"),
            "locked": obj.get("locked"),
            "status": obj.get("status"),
            "statusMessage": obj.get("statusMessage"),
            "errorMessage": obj.get("errorMessage"),
            "statusDate": obj.get("statusDate"),
            "statusPercent": obj.get("statusPercent"),
            "statusEta": obj.get("statusEta"),
            "userStatus": obj.get("userStatus"),
            "expireDays": obj.get("expireDays"),
            "renewDays": obj.get("renewDays"),
            "expireCount": obj.get("expireCount"),
            "expireDate": obj.get("expireDate"),
            "expireWarningDate": obj.get("expireWarningDate"),
            "expireWarningSent": obj.get("expireWarningSent"),
            "shutdownDays": obj.get("shutdownDays"),
            "shutdownRenewDays": obj.get("shutdownRenewDays"),
            "shutdownCount": obj.get("shutdownCount"),
            "shutdownDate": obj.get("shutdownDate"),
            "shutdownWarningDate": obj.get("shutdownWarningDate"),
            "shutdownWarningSent": obj.get("shutdownWarningSent"),
            "removalDate": obj.get("removalDate"),
            "createdBy": ListActivity200ResponseAllOfActivityInnerActivityInnerUser.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None,
            "owner": ListActivity200ResponseAllOfActivityInnerActivityInnerUser.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "notes": obj.get("notes"),
            "stats": ListInstances200ResponseAllOfInstancesInnerStats.from_dict(obj["stats"]) if obj.get("stats") is not None else None,
            "powerSchedule": obj.get("powerSchedule"),
            "isScalable": obj.get("isScalable"),
            "instanceThreshold": obj.get("instanceThreshold"),
            "isBusy": obj.get("isBusy"),
            "apps": obj.get("apps")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


