# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ListInvoices200ResponseAllOfInvoicesInnerLineItemsInner(BaseModel):
    """
    ListInvoices200ResponseAllOfInvoicesInnerLineItemsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    invoice_id: Optional[StrictInt] = Field(default=None, alias="invoiceId")
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    ref_id: Optional[StrictInt] = Field(default=None, alias="refId")
    ref_name: Optional[StrictStr] = Field(default=None, alias="refName")
    start_date: Optional[datetime] = Field(default=None, alias="startDate")
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    item_id: Optional[StrictStr] = Field(default=None, alias="itemId")
    item_type: Optional[StrictStr] = Field(default=None, alias="itemType")
    item_name: Optional[StrictStr] = Field(default=None, alias="itemName")
    item_description: Optional[StrictStr] = Field(default=None, alias="itemDescription")
    product_id: Optional[StrictStr] = Field(default=None, alias="productId")
    product_code: Optional[StrictStr] = Field(default=None, alias="productCode")
    product_name: Optional[StrictStr] = Field(default=None, alias="productName")
    item_seller: Optional[StrictStr] = Field(default=None, alias="itemSeller")
    item_action: Optional[StrictStr] = Field(default=None, alias="itemAction")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    rate_id: Optional[StrictStr] = Field(default=None, alias="rateId")
    rate_class: Optional[StrictStr] = Field(default=None, alias="rateClass")
    rate_unit: Optional[StrictStr] = Field(default=None, alias="rateUnit")
    rate_term: Optional[StrictStr] = Field(default=None, alias="rateTerm")
    usage_type: Optional[StrictStr] = Field(default=None, alias="usageType")
    usage_category: Optional[StrictStr] = Field(default=None, alias="usageCategory")
    usage_service: Optional[StrictStr] = Field(default=None, alias="usageService")
    item_usage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="itemUsage")
    item_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="itemRate")
    item_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="itemCost")
    item_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="itemPrice")
    item_tax: Optional[StrictInt] = Field(default=None, alias="itemTax")
    item_term: Optional[StrictStr] = Field(default=None, alias="itemTerm")
    tax_type: Optional[StrictStr] = Field(default=None, alias="taxType")
    region_code: Optional[StrictStr] = Field(default=None, alias="regionCode")
    currency: Optional[StrictStr] = None
    conversion_rate: Optional[StrictInt] = Field(default=None, alias="conversionRate")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "invoiceId", "refType", "refId", "refName", "startDate", "endDate", "itemId", "itemType", "itemName", "itemDescription", "productId", "productCode", "productName", "itemSeller", "itemAction", "externalId", "rateId", "rateClass", "rateUnit", "rateTerm", "usageType", "usageCategory", "usageService", "itemUsage", "itemRate", "itemCost", "itemPrice", "itemTax", "itemTerm", "taxType", "regionCode", "currency", "conversionRate", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListInvoices200ResponseAllOfInvoicesInnerLineItemsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if item_type (nullable) is None
        # and model_fields_set contains the field
        if self.item_type is None and "item_type" in self.model_fields_set:
            _dict['itemType'] = None

        # set to None if product_id (nullable) is None
        # and model_fields_set contains the field
        if self.product_id is None and "product_id" in self.model_fields_set:
            _dict['productId'] = None

        # set to None if item_seller (nullable) is None
        # and model_fields_set contains the field
        if self.item_seller is None and "item_seller" in self.model_fields_set:
            _dict['itemSeller'] = None

        # set to None if item_action (nullable) is None
        # and model_fields_set contains the field
        if self.item_action is None and "item_action" in self.model_fields_set:
            _dict['itemAction'] = None

        # set to None if rate_class (nullable) is None
        # and model_fields_set contains the field
        if self.rate_class is None and "rate_class" in self.model_fields_set:
            _dict['rateClass'] = None

        # set to None if rate_term (nullable) is None
        # and model_fields_set contains the field
        if self.rate_term is None and "rate_term" in self.model_fields_set:
            _dict['rateTerm'] = None

        # set to None if item_term (nullable) is None
        # and model_fields_set contains the field
        if self.item_term is None and "item_term" in self.model_fields_set:
            _dict['itemTerm'] = None

        # set to None if tax_type (nullable) is None
        # and model_fields_set contains the field
        if self.tax_type is None and "tax_type" in self.model_fields_set:
            _dict['taxType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListInvoices200ResponseAllOfInvoicesInnerLineItemsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "invoiceId": obj.get("invoiceId"),
            "refType": obj.get("refType"),
            "refId": obj.get("refId"),
            "refName": obj.get("refName"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "itemId": obj.get("itemId"),
            "itemType": obj.get("itemType"),
            "itemName": obj.get("itemName"),
            "itemDescription": obj.get("itemDescription"),
            "productId": obj.get("productId"),
            "productCode": obj.get("productCode"),
            "productName": obj.get("productName"),
            "itemSeller": obj.get("itemSeller"),
            "itemAction": obj.get("itemAction"),
            "externalId": obj.get("externalId"),
            "rateId": obj.get("rateId"),
            "rateClass": obj.get("rateClass"),
            "rateUnit": obj.get("rateUnit"),
            "rateTerm": obj.get("rateTerm"),
            "usageType": obj.get("usageType"),
            "usageCategory": obj.get("usageCategory"),
            "usageService": obj.get("usageService"),
            "itemUsage": obj.get("itemUsage"),
            "itemRate": obj.get("itemRate"),
            "itemCost": obj.get("itemCost"),
            "itemPrice": obj.get("itemPrice"),
            "itemTax": obj.get("itemTax"),
            "itemTerm": obj.get("itemTerm"),
            "taxType": obj.get("taxType"),
            "regionCode": obj.get("regionCode"),
            "currency": obj.get("currency"),
            "conversionRate": obj.get("conversionRate"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


