# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_load_balancer_monitors200_response_all_of_load_balancer_monitors_inner_load_balancer import ListLoadBalancerMonitors200ResponseAllOfLoadBalancerMonitorsInnerLoadBalancer
from typing import Optional, Set
from typing_extensions import Self

class ListLoadBalancerMonitors200ResponseAllOfLoadBalancerMonitorsInner(BaseModel):
    """
    ListLoadBalancerMonitors200ResponseAllOfLoadBalancerMonitorsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    load_balancer: Optional[ListLoadBalancerMonitors200ResponseAllOfLoadBalancerMonitorsInnerLoadBalancer] = Field(default=None, alias="loadBalancer")
    name: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    category: Optional[StrictStr] = None
    visibility: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    monitor_type: Optional[StrictStr] = Field(default=None, alias="monitorType")
    monitor_interval: Optional[StrictInt] = Field(default=None, alias="monitorInterval")
    monitor_timeout: Optional[StrictInt] = Field(default=None, alias="monitorTimeout")
    send_data: Optional[StrictStr] = Field(default=None, alias="sendData")
    send_version: Optional[StrictStr] = Field(default=None, alias="sendVersion")
    send_type: Optional[StrictStr] = Field(default=None, alias="sendType")
    receive_data: Optional[StrictStr] = Field(default=None, alias="receiveData")
    receive_code: Optional[StrictStr] = Field(default=None, alias="receiveCode")
    disabled_data: Optional[StrictStr] = Field(default=None, alias="disabledData")
    monitor_username: Optional[StrictStr] = Field(default=None, alias="monitorUsername")
    monitor_password: Optional[StrictStr] = Field(default=None, alias="monitorPassword")
    monitor_destination: Optional[StrictStr] = Field(default=None, alias="monitorDestination")
    monitor_reverse: Optional[StrictBool] = Field(default=None, alias="monitorReverse")
    monitor_transparent: Optional[StrictBool] = Field(default=None, alias="monitorTransparent")
    monitor_adaptive: Optional[StrictBool] = Field(default=None, alias="monitorAdaptive")
    alias_address: Optional[StrictStr] = Field(default=None, alias="aliasAddress")
    alias_port: Optional[StrictInt] = Field(default=None, alias="aliasPort")
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    monitor_source: Optional[StrictStr] = Field(default=None, alias="monitorSource")
    status: Optional[StrictStr] = None
    status_message: Optional[StrictStr] = Field(default=None, alias="statusMessage")
    status_date: Optional[datetime] = Field(default=None, alias="statusDate")
    enabled: Optional[StrictBool] = None
    max_retry: Optional[StrictInt] = Field(default=None, alias="maxRetry")
    fall_count: Optional[StrictInt] = Field(default=None, alias="fallCount")
    rise_count: Optional[StrictInt] = Field(default=None, alias="riseCount")
    data_length: Optional[StrictStr] = Field(default=None, alias="dataLength")
    config: Optional[Dict[str, Any]] = None
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "loadBalancer", "name", "code", "category", "visibility", "description", "monitorType", "monitorInterval", "monitorTimeout", "sendData", "sendVersion", "sendType", "receiveData", "receiveCode", "disabledData", "monitorUsername", "monitorPassword", "monitorDestination", "monitorReverse", "monitorTransparent", "monitorAdaptive", "aliasAddress", "aliasPort", "internalId", "externalId", "monitorSource", "status", "statusMessage", "statusDate", "enabled", "maxRetry", "fallCount", "riseCount", "dataLength", "config", "createdBy", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListLoadBalancerMonitors200ResponseAllOfLoadBalancerMonitorsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of load_balancer
        if self.load_balancer:
            _dict['loadBalancer'] = self.load_balancer.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if code (nullable) is None
        # and model_fields_set contains the field
        if self.code is None and "code" in self.model_fields_set:
            _dict['code'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if send_data (nullable) is None
        # and model_fields_set contains the field
        if self.send_data is None and "send_data" in self.model_fields_set:
            _dict['sendData'] = None

        # set to None if receive_data (nullable) is None
        # and model_fields_set contains the field
        if self.receive_data is None and "receive_data" in self.model_fields_set:
            _dict['receiveData'] = None

        # set to None if disabled_data (nullable) is None
        # and model_fields_set contains the field
        if self.disabled_data is None and "disabled_data" in self.model_fields_set:
            _dict['disabledData'] = None

        # set to None if monitor_username (nullable) is None
        # and model_fields_set contains the field
        if self.monitor_username is None and "monitor_username" in self.model_fields_set:
            _dict['monitorUsername'] = None

        # set to None if monitor_password (nullable) is None
        # and model_fields_set contains the field
        if self.monitor_password is None and "monitor_password" in self.model_fields_set:
            _dict['monitorPassword'] = None

        # set to None if alias_address (nullable) is None
        # and model_fields_set contains the field
        if self.alias_address is None and "alias_address" in self.model_fields_set:
            _dict['aliasAddress'] = None

        # set to None if status_message (nullable) is None
        # and model_fields_set contains the field
        if self.status_message is None and "status_message" in self.model_fields_set:
            _dict['statusMessage'] = None

        # set to None if status_date (nullable) is None
        # and model_fields_set contains the field
        if self.status_date is None and "status_date" in self.model_fields_set:
            _dict['statusDate'] = None

        # set to None if data_length (nullable) is None
        # and model_fields_set contains the field
        if self.data_length is None and "data_length" in self.model_fields_set:
            _dict['dataLength'] = None

        # set to None if created_by (nullable) is None
        # and model_fields_set contains the field
        if self.created_by is None and "created_by" in self.model_fields_set:
            _dict['createdBy'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListLoadBalancerMonitors200ResponseAllOfLoadBalancerMonitorsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "loadBalancer": ListLoadBalancerMonitors200ResponseAllOfLoadBalancerMonitorsInnerLoadBalancer.from_dict(obj["loadBalancer"]) if obj.get("loadBalancer") is not None else None,
            "name": obj.get("name"),
            "code": obj.get("code"),
            "category": obj.get("category"),
            "visibility": obj.get("visibility"),
            "description": obj.get("description"),
            "monitorType": obj.get("monitorType"),
            "monitorInterval": obj.get("monitorInterval"),
            "monitorTimeout": obj.get("monitorTimeout"),
            "sendData": obj.get("sendData"),
            "sendVersion": obj.get("sendVersion"),
            "sendType": obj.get("sendType"),
            "receiveData": obj.get("receiveData"),
            "receiveCode": obj.get("receiveCode"),
            "disabledData": obj.get("disabledData"),
            "monitorUsername": obj.get("monitorUsername"),
            "monitorPassword": obj.get("monitorPassword"),
            "monitorDestination": obj.get("monitorDestination"),
            "monitorReverse": obj.get("monitorReverse"),
            "monitorTransparent": obj.get("monitorTransparent"),
            "monitorAdaptive": obj.get("monitorAdaptive"),
            "aliasAddress": obj.get("aliasAddress"),
            "aliasPort": obj.get("aliasPort"),
            "internalId": obj.get("internalId"),
            "externalId": obj.get("externalId"),
            "monitorSource": obj.get("monitorSource"),
            "status": obj.get("status"),
            "statusMessage": obj.get("statusMessage"),
            "statusDate": obj.get("statusDate"),
            "enabled": obj.get("enabled"),
            "maxRetry": obj.get("maxRetry"),
            "fallCount": obj.get("fallCount"),
            "riseCount": obj.get("riseCount"),
            "dataLength": obj.get("dataLength"),
            "config": obj.get("config"),
            "createdBy": obj.get("createdBy"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


