# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_activity200_response_all_of_activity_inner_activity_inner_user import ListActivity200ResponseAllOfActivityInnerActivityInnerUser
from typing import Optional, Set
from typing_extensions import Self

class ListLoadBalancerPoolNodes200ResponseAllOfLoadBalancerNodesInner(BaseModel):
    """
    ListLoadBalancerPoolNodes200ResponseAllOfLoadBalancerNodesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    visibility: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    ip_address: Optional[StrictStr] = Field(default=None, alias="ipAddress")
    port: Optional[StrictInt] = None
    port_type: Optional[StrictStr] = Field(default=None, alias="portType")
    monitor_port: Optional[StrictStr] = Field(default=None, alias="monitorPort")
    weight: Optional[StrictInt] = None
    node_state: Optional[StrictStr] = Field(default=None, alias="nodeState")
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    enabled: Optional[StrictBool] = None
    status: Optional[StrictStr] = None
    status_message: Optional[StrictStr] = Field(default=None, alias="statusMessage")
    status_date: Optional[datetime] = Field(default=None, alias="statusDate")
    server: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    instance_id: Optional[StrictInt] = Field(default=None, alias="instanceId")
    container_id: Optional[StrictInt] = Field(default=None, alias="containerId")
    node_source: Optional[StrictStr] = Field(default=None, alias="nodeSource")
    monitor: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    max_connections: Optional[StrictInt] = Field(default=None, alias="maxConnections")
    external_ref_type: Optional[StrictStr] = Field(default=None, alias="externalRefType")
    external_ref_id: Optional[StrictStr] = Field(default=None, alias="externalRefId")
    external_ref_name: Optional[StrictStr] = Field(default=None, alias="externalRefName")
    created_by: Optional[ListActivity200ResponseAllOfActivityInnerActivityInnerUser] = Field(default=None, alias="createdBy")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "visibility", "description", "ipAddress", "port", "portType", "monitorPort", "weight", "nodeState", "internalId", "externalId", "enabled", "status", "statusMessage", "statusDate", "server", "instanceId", "containerId", "nodeSource", "monitor", "maxConnections", "externalRefType", "externalRefId", "externalRefName", "createdBy", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListLoadBalancerPoolNodes200ResponseAllOfLoadBalancerNodesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of server
        if self.server:
            _dict['server'] = self.server.to_dict()
        # override the default output from pydantic by calling `to_dict()` of monitor
        if self.monitor:
            _dict['monitor'] = self.monitor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if port_type (nullable) is None
        # and model_fields_set contains the field
        if self.port_type is None and "port_type" in self.model_fields_set:
            _dict['portType'] = None

        # set to None if monitor_port (nullable) is None
        # and model_fields_set contains the field
        if self.monitor_port is None and "monitor_port" in self.model_fields_set:
            _dict['monitorPort'] = None

        # set to None if weight (nullable) is None
        # and model_fields_set contains the field
        if self.weight is None and "weight" in self.model_fields_set:
            _dict['weight'] = None

        # set to None if node_state (nullable) is None
        # and model_fields_set contains the field
        if self.node_state is None and "node_state" in self.model_fields_set:
            _dict['nodeState'] = None

        # set to None if internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_id is None and "internal_id" in self.model_fields_set:
            _dict['internalId'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if status_message (nullable) is None
        # and model_fields_set contains the field
        if self.status_message is None and "status_message" in self.model_fields_set:
            _dict['statusMessage'] = None

        # set to None if status_date (nullable) is None
        # and model_fields_set contains the field
        if self.status_date is None and "status_date" in self.model_fields_set:
            _dict['statusDate'] = None

        # set to None if instance_id (nullable) is None
        # and model_fields_set contains the field
        if self.instance_id is None and "instance_id" in self.model_fields_set:
            _dict['instanceId'] = None

        # set to None if container_id (nullable) is None
        # and model_fields_set contains the field
        if self.container_id is None and "container_id" in self.model_fields_set:
            _dict['containerId'] = None

        # set to None if node_source (nullable) is None
        # and model_fields_set contains the field
        if self.node_source is None and "node_source" in self.model_fields_set:
            _dict['nodeSource'] = None

        # set to None if max_connections (nullable) is None
        # and model_fields_set contains the field
        if self.max_connections is None and "max_connections" in self.model_fields_set:
            _dict['maxConnections'] = None

        # set to None if external_ref_type (nullable) is None
        # and model_fields_set contains the field
        if self.external_ref_type is None and "external_ref_type" in self.model_fields_set:
            _dict['externalRefType'] = None

        # set to None if external_ref_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_ref_id is None and "external_ref_id" in self.model_fields_set:
            _dict['externalRefId'] = None

        # set to None if external_ref_name (nullable) is None
        # and model_fields_set contains the field
        if self.external_ref_name is None and "external_ref_name" in self.model_fields_set:
            _dict['externalRefName'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListLoadBalancerPoolNodes200ResponseAllOfLoadBalancerNodesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "visibility": obj.get("visibility"),
            "description": obj.get("description"),
            "ipAddress": obj.get("ipAddress"),
            "port": obj.get("port"),
            "portType": obj.get("portType"),
            "monitorPort": obj.get("monitorPort"),
            "weight": obj.get("weight"),
            "nodeState": obj.get("nodeState"),
            "internalId": obj.get("internalId"),
            "externalId": obj.get("externalId"),
            "enabled": obj.get("enabled"),
            "status": obj.get("status"),
            "statusMessage": obj.get("statusMessage"),
            "statusDate": obj.get("statusDate"),
            "server": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["server"]) if obj.get("server") is not None else None,
            "instanceId": obj.get("instanceId"),
            "containerId": obj.get("containerId"),
            "nodeSource": obj.get("nodeSource"),
            "monitor": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["monitor"]) if obj.get("monitor") is not None else None,
            "maxConnections": obj.get("maxConnections"),
            "externalRefType": obj.get("externalRefType"),
            "externalRefId": obj.get("externalRefId"),
            "externalRefName": obj.get("externalRefName"),
            "createdBy": ListActivity200ResponseAllOfActivityInnerActivityInnerUser.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None,
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


