# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_load_balancer_monitors200_response_all_of_load_balancer_monitors_inner_load_balancer import ListLoadBalancerMonitors200ResponseAllOfLoadBalancerMonitorsInnerLoadBalancer
from typing import Optional, Set
from typing_extensions import Self

class ListLoadBalancerVirtualServers200ResponseAllOfLoadBalancerInstancesInner(BaseModel):
    """
    ListLoadBalancerVirtualServers200ResponseAllOfLoadBalancerInstancesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    load_balancer: Optional[ListLoadBalancerMonitors200ResponseAllOfLoadBalancerMonitorsInnerLoadBalancer] = Field(default=None, alias="loadBalancer")
    instance: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    active: Optional[StrictBool] = None
    sticky: Optional[StrictBool] = None
    ssl_enabled: Optional[StrictStr] = Field(default=None, alias="sslEnabled")
    external_address: Optional[StrictBool] = Field(default=None, alias="externalAddress")
    backend_port: Optional[StrictStr] = Field(default=None, alias="backendPort")
    vip_type: Optional[StrictStr] = Field(default=None, alias="vipType")
    vip_address: Optional[StrictStr] = Field(default=None, alias="vipAddress")
    vip_hostname: Optional[StrictStr] = Field(default=None, alias="vipHostname")
    vip_protocol: Optional[StrictStr] = Field(default=None, alias="vipProtocol")
    vip_scheme: Optional[StrictStr] = Field(default=None, alias="vipScheme")
    vip_mode: Optional[StrictStr] = Field(default=None, alias="vipMode")
    vip_name: Optional[StrictStr] = Field(default=None, alias="vipName")
    vip_port: Optional[StrictInt] = Field(default=None, alias="vipPort")
    vip_sticky: Optional[StrictStr] = Field(default=None, alias="vipSticky")
    vip_balance: Optional[StrictStr] = Field(default=None, alias="vipBalance")
    service_port: Optional[StrictStr] = Field(default=None, alias="servicePort")
    source_address: Optional[StrictStr] = Field(default=None, alias="sourceAddress")
    ssl_cert: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = Field(default=None, alias="sslCert")
    ssl_mode: Optional[StrictStr] = Field(default=None, alias="sslMode")
    ssl_redirect_mode: Optional[StrictStr] = Field(default=None, alias="sslRedirectMode")
    vip_shared: Optional[StrictBool] = Field(default=None, alias="vipShared")
    vip_direct_address: Optional[StrictStr] = Field(default=None, alias="vipDirectAddress")
    server_name: Optional[StrictStr] = Field(default=None, alias="serverName")
    pool_name: Optional[StrictStr] = Field(default=None, alias="poolName")
    removing: Optional[StrictBool] = None
    vip_source: Optional[StrictStr] = Field(default=None, alias="vipSource")
    extra_config: Optional[StrictStr] = Field(default=None, alias="extraConfig")
    service_access: Optional[StrictStr] = Field(default=None, alias="serviceAccess")
    network_id: Optional[StrictStr] = Field(default=None, alias="networkId")
    subnet_id: Optional[StrictStr] = Field(default=None, alias="subnetId")
    external_port_id: Optional[StrictStr] = Field(default=None, alias="externalPortId")
    status: Optional[StrictStr] = None
    vip_status: Optional[StrictStr] = Field(default=None, alias="vipStatus")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "loadBalancer", "instance", "description", "internalId", "externalId", "dateCreated", "lastUpdated", "active", "sticky", "sslEnabled", "externalAddress", "backendPort", "vipType", "vipAddress", "vipHostname", "vipProtocol", "vipScheme", "vipMode", "vipName", "vipPort", "vipSticky", "vipBalance", "servicePort", "sourceAddress", "sslCert", "sslMode", "sslRedirectMode", "vipShared", "vipDirectAddress", "serverName", "poolName", "removing", "vipSource", "extraConfig", "serviceAccess", "networkId", "subnetId", "externalPortId", "status", "vipStatus"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListLoadBalancerVirtualServers200ResponseAllOfLoadBalancerInstancesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of load_balancer
        if self.load_balancer:
            _dict['loadBalancer'] = self.load_balancer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ssl_cert
        if self.ssl_cert:
            _dict['sslCert'] = self.ssl_cert.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if instance (nullable) is None
        # and model_fields_set contains the field
        if self.instance is None and "instance" in self.model_fields_set:
            _dict['instance'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if ssl_enabled (nullable) is None
        # and model_fields_set contains the field
        if self.ssl_enabled is None and "ssl_enabled" in self.model_fields_set:
            _dict['sslEnabled'] = None

        # set to None if backend_port (nullable) is None
        # and model_fields_set contains the field
        if self.backend_port is None and "backend_port" in self.model_fields_set:
            _dict['backendPort'] = None

        # set to None if vip_type (nullable) is None
        # and model_fields_set contains the field
        if self.vip_type is None and "vip_type" in self.model_fields_set:
            _dict['vipType'] = None

        # set to None if vip_hostname (nullable) is None
        # and model_fields_set contains the field
        if self.vip_hostname is None and "vip_hostname" in self.model_fields_set:
            _dict['vipHostname'] = None

        # set to None if vip_scheme (nullable) is None
        # and model_fields_set contains the field
        if self.vip_scheme is None and "vip_scheme" in self.model_fields_set:
            _dict['vipScheme'] = None

        # set to None if vip_mode (nullable) is None
        # and model_fields_set contains the field
        if self.vip_mode is None and "vip_mode" in self.model_fields_set:
            _dict['vipMode'] = None

        # set to None if vip_sticky (nullable) is None
        # and model_fields_set contains the field
        if self.vip_sticky is None and "vip_sticky" in self.model_fields_set:
            _dict['vipSticky'] = None

        # set to None if vip_balance (nullable) is None
        # and model_fields_set contains the field
        if self.vip_balance is None and "vip_balance" in self.model_fields_set:
            _dict['vipBalance'] = None

        # set to None if service_port (nullable) is None
        # and model_fields_set contains the field
        if self.service_port is None and "service_port" in self.model_fields_set:
            _dict['servicePort'] = None

        # set to None if source_address (nullable) is None
        # and model_fields_set contains the field
        if self.source_address is None and "source_address" in self.model_fields_set:
            _dict['sourceAddress'] = None

        # set to None if ssl_mode (nullable) is None
        # and model_fields_set contains the field
        if self.ssl_mode is None and "ssl_mode" in self.model_fields_set:
            _dict['sslMode'] = None

        # set to None if ssl_redirect_mode (nullable) is None
        # and model_fields_set contains the field
        if self.ssl_redirect_mode is None and "ssl_redirect_mode" in self.model_fields_set:
            _dict['sslRedirectMode'] = None

        # set to None if vip_direct_address (nullable) is None
        # and model_fields_set contains the field
        if self.vip_direct_address is None and "vip_direct_address" in self.model_fields_set:
            _dict['vipDirectAddress'] = None

        # set to None if server_name (nullable) is None
        # and model_fields_set contains the field
        if self.server_name is None and "server_name" in self.model_fields_set:
            _dict['serverName'] = None

        # set to None if pool_name (nullable) is None
        # and model_fields_set contains the field
        if self.pool_name is None and "pool_name" in self.model_fields_set:
            _dict['poolName'] = None

        # set to None if extra_config (nullable) is None
        # and model_fields_set contains the field
        if self.extra_config is None and "extra_config" in self.model_fields_set:
            _dict['extraConfig'] = None

        # set to None if service_access (nullable) is None
        # and model_fields_set contains the field
        if self.service_access is None and "service_access" in self.model_fields_set:
            _dict['serviceAccess'] = None

        # set to None if network_id (nullable) is None
        # and model_fields_set contains the field
        if self.network_id is None and "network_id" in self.model_fields_set:
            _dict['networkId'] = None

        # set to None if subnet_id (nullable) is None
        # and model_fields_set contains the field
        if self.subnet_id is None and "subnet_id" in self.model_fields_set:
            _dict['subnetId'] = None

        # set to None if external_port_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_port_id is None and "external_port_id" in self.model_fields_set:
            _dict['externalPortId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListLoadBalancerVirtualServers200ResponseAllOfLoadBalancerInstancesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "loadBalancer": ListLoadBalancerMonitors200ResponseAllOfLoadBalancerMonitorsInnerLoadBalancer.from_dict(obj["loadBalancer"]) if obj.get("loadBalancer") is not None else None,
            "instance": obj.get("instance"),
            "description": obj.get("description"),
            "internalId": obj.get("internalId"),
            "externalId": obj.get("externalId"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "active": obj.get("active"),
            "sticky": obj.get("sticky"),
            "sslEnabled": obj.get("sslEnabled"),
            "externalAddress": obj.get("externalAddress"),
            "backendPort": obj.get("backendPort"),
            "vipType": obj.get("vipType"),
            "vipAddress": obj.get("vipAddress"),
            "vipHostname": obj.get("vipHostname"),
            "vipProtocol": obj.get("vipProtocol"),
            "vipScheme": obj.get("vipScheme"),
            "vipMode": obj.get("vipMode"),
            "vipName": obj.get("vipName"),
            "vipPort": obj.get("vipPort"),
            "vipSticky": obj.get("vipSticky"),
            "vipBalance": obj.get("vipBalance"),
            "servicePort": obj.get("servicePort"),
            "sourceAddress": obj.get("sourceAddress"),
            "sslCert": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["sslCert"]) if obj.get("sslCert") is not None else None,
            "sslMode": obj.get("sslMode"),
            "sslRedirectMode": obj.get("sslRedirectMode"),
            "vipShared": obj.get("vipShared"),
            "vipDirectAddress": obj.get("vipDirectAddress"),
            "serverName": obj.get("serverName"),
            "poolName": obj.get("poolName"),
            "removing": obj.get("removing"),
            "vipSource": obj.get("vipSource"),
            "extraConfig": obj.get("extraConfig"),
            "serviceAccess": obj.get("serviceAccess"),
            "networkId": obj.get("networkId"),
            "subnetId": obj.get("subnetId"),
            "externalPortId": obj.get("externalPortId"),
            "status": obj.get("status"),
            "vipStatus": obj.get("vipStatus")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


