# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_activity200_response_all_of_activity_inner_activity_inner_user import ListActivity200ResponseAllOfActivityInnerActivityInnerUser
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from morpheus.models.list_policies200_response_all_of_policies_inner_config import ListPolicies200ResponseAllOfPoliciesInnerConfig
from morpheus.models.list_policies200_response_all_of_policies_inner_role import ListPolicies200ResponseAllOfPoliciesInnerRole
from typing import Optional, Set
from typing_extensions import Self

class ListPolicies200ResponseAllOfPoliciesInner(BaseModel):
    """
    ListPolicies200ResponseAllOfPoliciesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    policy_type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = Field(default=None, alias="policyType")
    zone: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    site: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    user: Optional[ListActivity200ResponseAllOfActivityInnerActivityInnerUser] = None
    role: Optional[ListPolicies200ResponseAllOfPoliciesInnerRole] = None
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    ref_id: Optional[StrictStr] = Field(default=None, alias="refId")
    each_user: Optional[StrictBool] = Field(default=None, alias="eachUser")
    config: Optional[ListPolicies200ResponseAllOfPoliciesInnerConfig] = None
    enabled: Optional[StrictBool] = None
    owner: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    accounts: Optional[List[GetAlerts200ResponseAllOfCheckGroupsInnerInstance]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "description", "policyType", "zone", "site", "user", "role", "refType", "refId", "eachUser", "config", "enabled", "owner", "accounts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListPolicies200ResponseAllOfPoliciesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of policy_type
        if self.policy_type:
            _dict['policyType'] = self.policy_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of zone
        if self.zone:
            _dict['zone'] = self.zone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of site
        if self.site:
            _dict['site'] = self.site.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of role
        if self.role:
            _dict['role'] = self.role.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in accounts (list)
        _items = []
        if self.accounts:
            for _item_accounts in self.accounts:
                if _item_accounts:
                    _items.append(_item_accounts.to_dict())
            _dict['accounts'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if ref_type (nullable) is None
        # and model_fields_set contains the field
        if self.ref_type is None and "ref_type" in self.model_fields_set:
            _dict['refType'] = None

        # set to None if ref_id (nullable) is None
        # and model_fields_set contains the field
        if self.ref_id is None and "ref_id" in self.model_fields_set:
            _dict['refId'] = None

        # set to None if each_user (nullable) is None
        # and model_fields_set contains the field
        if self.each_user is None and "each_user" in self.model_fields_set:
            _dict['eachUser'] = None

        # set to None if accounts (nullable) is None
        # and model_fields_set contains the field
        if self.accounts is None and "accounts" in self.model_fields_set:
            _dict['accounts'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListPolicies200ResponseAllOfPoliciesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "policyType": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["policyType"]) if obj.get("policyType") is not None else None,
            "zone": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["zone"]) if obj.get("zone") is not None else None,
            "site": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["site"]) if obj.get("site") is not None else None,
            "user": ListActivity200ResponseAllOfActivityInnerActivityInnerUser.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "role": ListPolicies200ResponseAllOfPoliciesInnerRole.from_dict(obj["role"]) if obj.get("role") is not None else None,
            "refType": obj.get("refType"),
            "refId": obj.get("refId"),
            "eachUser": obj.get("eachUser"),
            "config": ListPolicies200ResponseAllOfPoliciesInnerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "enabled": obj.get("enabled"),
            "owner": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "accounts": [GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(_item) for _item in obj["accounts"]] if obj.get("accounts") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


