# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ListSecurityGroups200ResponseAllOfSecurityGroupsInnerRulesInner(BaseModel):
    """
    ListSecurityGroups200ResponseAllOfSecurityGroupsInnerRulesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    rule_type: Optional[StrictStr] = Field(default=None, alias="ruleType")
    custom_rule: Optional[StrictBool] = Field(default=None, alias="customRule")
    instance_type_id: Optional[StrictStr] = Field(default=None, alias="instanceTypeId")
    direction: Optional[StrictStr] = None
    policy: Optional[StrictStr] = None
    source_type: Optional[StrictStr] = Field(default=None, alias="sourceType")
    source: Optional[StrictStr] = None
    source_group: Optional[StrictStr] = Field(default=None, alias="sourceGroup")
    source_tier: Optional[StrictStr] = Field(default=None, alias="sourceTier")
    port_range: Optional[StrictStr] = Field(default=None, alias="portRange")
    protocol: Optional[StrictStr] = None
    destination_type: Optional[StrictStr] = Field(default=None, alias="destinationType")
    destination: Optional[StrictStr] = None
    destination_group: Optional[StrictStr] = Field(default=None, alias="destinationGroup")
    destination_tier: Optional[StrictStr] = Field(default=None, alias="destinationTier")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    enabled: Optional[StrictStr] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "ruleType", "customRule", "instanceTypeId", "direction", "policy", "sourceType", "source", "sourceGroup", "sourceTier", "portRange", "protocol", "destinationType", "destination", "destinationGroup", "destinationTier", "externalId", "enabled"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListSecurityGroups200ResponseAllOfSecurityGroupsInnerRulesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if instance_type_id (nullable) is None
        # and model_fields_set contains the field
        if self.instance_type_id is None and "instance_type_id" in self.model_fields_set:
            _dict['instanceTypeId'] = None

        # set to None if source (nullable) is None
        # and model_fields_set contains the field
        if self.source is None and "source" in self.model_fields_set:
            _dict['source'] = None

        # set to None if source_group (nullable) is None
        # and model_fields_set contains the field
        if self.source_group is None and "source_group" in self.model_fields_set:
            _dict['sourceGroup'] = None

        # set to None if source_tier (nullable) is None
        # and model_fields_set contains the field
        if self.source_tier is None and "source_tier" in self.model_fields_set:
            _dict['sourceTier'] = None

        # set to None if port_range (nullable) is None
        # and model_fields_set contains the field
        if self.port_range is None and "port_range" in self.model_fields_set:
            _dict['portRange'] = None

        # set to None if destination (nullable) is None
        # and model_fields_set contains the field
        if self.destination is None and "destination" in self.model_fields_set:
            _dict['destination'] = None

        # set to None if destination_group (nullable) is None
        # and model_fields_set contains the field
        if self.destination_group is None and "destination_group" in self.model_fields_set:
            _dict['destinationGroup'] = None

        # set to None if destination_tier (nullable) is None
        # and model_fields_set contains the field
        if self.destination_tier is None and "destination_tier" in self.model_fields_set:
            _dict['destinationTier'] = None

        # set to None if enabled (nullable) is None
        # and model_fields_set contains the field
        if self.enabled is None and "enabled" in self.model_fields_set:
            _dict['enabled'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListSecurityGroups200ResponseAllOfSecurityGroupsInnerRulesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "ruleType": obj.get("ruleType"),
            "customRule": obj.get("customRule"),
            "instanceTypeId": obj.get("instanceTypeId"),
            "direction": obj.get("direction"),
            "policy": obj.get("policy"),
            "sourceType": obj.get("sourceType"),
            "source": obj.get("source"),
            "sourceGroup": obj.get("sourceGroup"),
            "sourceTier": obj.get("sourceTier"),
            "portRange": obj.get("portRange"),
            "protocol": obj.get("protocol"),
            "destinationType": obj.get("destinationType"),
            "destination": obj.get("destination"),
            "destinationGroup": obj.get("destinationGroup"),
            "destinationTier": obj.get("destinationTier"),
            "externalId": obj.get("externalId"),
            "enabled": obj.get("enabled")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


