# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_instance_type_provisioning200_response_all_of_instance_type_instance_type_layouts_inner_provision_type_storage_types_inner import GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerProvisionTypeStorageTypesInner
from morpheus.models.list_storage_server_types200_response_all_of_storage_server_types_inner_group_option_types_inner import ListStorageServerTypes200ResponseAllOfStorageServerTypesInnerGroupOptionTypesInner
from morpheus.models.list_storage_server_types200_response_all_of_storage_server_types_inner_option_types_inner import ListStorageServerTypes200ResponseAllOfStorageServerTypesInnerOptionTypesInner
from typing import Optional, Set
from typing_extensions import Self

class ListStorageServerTypes200ResponseAllOfStorageServerTypesInner(BaseModel):
    """
    ListStorageServerTypes200ResponseAllOfStorageServerTypesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    code: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    creatable: Optional[StrictBool] = None
    has_namespaces: Optional[StrictBool] = Field(default=None, alias="hasNamespaces")
    has_groups: Optional[StrictBool] = Field(default=None, alias="hasGroups")
    has_block: Optional[StrictBool] = Field(default=None, alias="hasBlock")
    has_object: Optional[StrictBool] = Field(default=None, alias="hasObject")
    has_file: Optional[StrictBool] = Field(default=None, alias="hasFile")
    has_datastore: Optional[StrictBool] = Field(default=None, alias="hasDatastore")
    has_disks: Optional[StrictBool] = Field(default=None, alias="hasDisks")
    has_hosts: Optional[StrictBool] = Field(default=None, alias="hasHosts")
    create_namespaces: Optional[StrictBool] = Field(default=None, alias="createNamespaces")
    create_group: Optional[StrictBool] = Field(default=None, alias="createGroup")
    create_block: Optional[StrictBool] = Field(default=None, alias="createBlock")
    create_object: Optional[StrictBool] = Field(default=None, alias="createObject")
    create_file: Optional[StrictBool] = Field(default=None, alias="createFile")
    create_datastore: Optional[StrictBool] = Field(default=None, alias="createDatastore")
    create_disk: Optional[StrictBool] = Field(default=None, alias="createDisk")
    create_host: Optional[StrictBool] = Field(default=None, alias="createHost")
    icon_code: Optional[StrictStr] = Field(default=None, alias="iconCode")
    has_file_browser: Optional[StrictBool] = Field(default=None, alias="hasFileBrowser")
    option_types: Optional[List[ListStorageServerTypes200ResponseAllOfStorageServerTypesInnerOptionTypesInner]] = Field(default=None, alias="optionTypes")
    group_option_types: Optional[List[ListStorageServerTypes200ResponseAllOfStorageServerTypesInnerGroupOptionTypesInner]] = Field(default=None, alias="groupOptionTypes")
    bucket_option_types: Optional[List[Dict[str, Any]]] = Field(default=None, alias="bucketOptionTypes")
    share_option_types: Optional[List[Dict[str, Any]]] = Field(default=None, alias="shareOptionTypes")
    share_access_option_types: Optional[List[Dict[str, Any]]] = Field(default=None, alias="shareAccessOptionTypes")
    storage_volume_types: Optional[List[GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerProvisionTypeStorageTypesInner]] = Field(default=None, alias="storageVolumeTypes")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "code", "name", "description", "enabled", "creatable", "hasNamespaces", "hasGroups", "hasBlock", "hasObject", "hasFile", "hasDatastore", "hasDisks", "hasHosts", "createNamespaces", "createGroup", "createBlock", "createObject", "createFile", "createDatastore", "createDisk", "createHost", "iconCode", "hasFileBrowser", "optionTypes", "groupOptionTypes", "bucketOptionTypes", "shareOptionTypes", "shareAccessOptionTypes", "storageVolumeTypes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListStorageServerTypes200ResponseAllOfStorageServerTypesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in option_types (list)
        _items = []
        if self.option_types:
            for _item_option_types in self.option_types:
                if _item_option_types:
                    _items.append(_item_option_types.to_dict())
            _dict['optionTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in group_option_types (list)
        _items = []
        if self.group_option_types:
            for _item_group_option_types in self.group_option_types:
                if _item_group_option_types:
                    _items.append(_item_group_option_types.to_dict())
            _dict['groupOptionTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in storage_volume_types (list)
        _items = []
        if self.storage_volume_types:
            for _item_storage_volume_types in self.storage_volume_types:
                if _item_storage_volume_types:
                    _items.append(_item_storage_volume_types.to_dict())
            _dict['storageVolumeTypes'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if icon_code (nullable) is None
        # and model_fields_set contains the field
        if self.icon_code is None and "icon_code" in self.model_fields_set:
            _dict['iconCode'] = None

        # set to None if bucket_option_types (nullable) is None
        # and model_fields_set contains the field
        if self.bucket_option_types is None and "bucket_option_types" in self.model_fields_set:
            _dict['bucketOptionTypes'] = None

        # set to None if share_option_types (nullable) is None
        # and model_fields_set contains the field
        if self.share_option_types is None and "share_option_types" in self.model_fields_set:
            _dict['shareOptionTypes'] = None

        # set to None if share_access_option_types (nullable) is None
        # and model_fields_set contains the field
        if self.share_access_option_types is None and "share_access_option_types" in self.model_fields_set:
            _dict['shareAccessOptionTypes'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListStorageServerTypes200ResponseAllOfStorageServerTypesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "code": obj.get("code"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "enabled": obj.get("enabled"),
            "creatable": obj.get("creatable"),
            "hasNamespaces": obj.get("hasNamespaces"),
            "hasGroups": obj.get("hasGroups"),
            "hasBlock": obj.get("hasBlock"),
            "hasObject": obj.get("hasObject"),
            "hasFile": obj.get("hasFile"),
            "hasDatastore": obj.get("hasDatastore"),
            "hasDisks": obj.get("hasDisks"),
            "hasHosts": obj.get("hasHosts"),
            "createNamespaces": obj.get("createNamespaces"),
            "createGroup": obj.get("createGroup"),
            "createBlock": obj.get("createBlock"),
            "createObject": obj.get("createObject"),
            "createFile": obj.get("createFile"),
            "createDatastore": obj.get("createDatastore"),
            "createDisk": obj.get("createDisk"),
            "createHost": obj.get("createHost"),
            "iconCode": obj.get("iconCode"),
            "hasFileBrowser": obj.get("hasFileBrowser"),
            "optionTypes": [ListStorageServerTypes200ResponseAllOfStorageServerTypesInnerOptionTypesInner.from_dict(_item) for _item in obj["optionTypes"]] if obj.get("optionTypes") is not None else None,
            "groupOptionTypes": [ListStorageServerTypes200ResponseAllOfStorageServerTypesInnerGroupOptionTypesInner.from_dict(_item) for _item in obj["groupOptionTypes"]] if obj.get("groupOptionTypes") is not None else None,
            "bucketOptionTypes": obj.get("bucketOptionTypes"),
            "shareOptionTypes": obj.get("shareOptionTypes"),
            "shareAccessOptionTypes": obj.get("shareAccessOptionTypes"),
            "storageVolumeTypes": [GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerProvisionTypeStorageTypesInner.from_dict(_item) for _item in obj["storageVolumeTypes"]] if obj.get("storageVolumeTypes") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


