# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_task_types200_response_task_types_inner_option_types_inner import ListTaskTypes200ResponseTaskTypesInnerOptionTypesInner
from typing import Optional, Set
from typing_extensions import Self

class ListTaskTypes200ResponseTaskTypesInner(BaseModel):
    """
    ListTaskTypes200ResponseTaskTypesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    code: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    category: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    scriptable: Optional[StrictBool] = None
    enabled: Optional[StrictBool] = None
    has_results: Optional[StrictBool] = Field(default=None, alias="hasResults")
    allow_execute_local: Optional[StrictBool] = Field(default=None, alias="allowExecuteLocal")
    allow_execute_remote: Optional[StrictBool] = Field(default=None, alias="allowExecuteRemote")
    allow_execute_resource: Optional[StrictBool] = Field(default=None, alias="allowExecuteResource")
    allow_local_repo: Optional[StrictBool] = Field(default=None, alias="allowLocalRepo")
    allow_remote_key_auth: Optional[StrictBool] = Field(default=None, alias="allowRemoteKeyAuth")
    option_types: Optional[List[ListTaskTypes200ResponseTaskTypesInnerOptionTypesInner]] = Field(default=None, alias="optionTypes")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "code", "name", "category", "description", "scriptable", "enabled", "hasResults", "allowExecuteLocal", "allowExecuteRemote", "allowExecuteResource", "allowLocalRepo", "allowRemoteKeyAuth", "optionTypes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListTaskTypes200ResponseTaskTypesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in option_types (list)
        _items = []
        if self.option_types:
            for _item_option_types in self.option_types:
                if _item_option_types:
                    _items.append(_item_option_types.to_dict())
            _dict['optionTypes'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if allow_execute_local (nullable) is None
        # and model_fields_set contains the field
        if self.allow_execute_local is None and "allow_execute_local" in self.model_fields_set:
            _dict['allowExecuteLocal'] = None

        # set to None if allow_execute_remote (nullable) is None
        # and model_fields_set contains the field
        if self.allow_execute_remote is None and "allow_execute_remote" in self.model_fields_set:
            _dict['allowExecuteRemote'] = None

        # set to None if allow_execute_resource (nullable) is None
        # and model_fields_set contains the field
        if self.allow_execute_resource is None and "allow_execute_resource" in self.model_fields_set:
            _dict['allowExecuteResource'] = None

        # set to None if allow_local_repo (nullable) is None
        # and model_fields_set contains the field
        if self.allow_local_repo is None and "allow_local_repo" in self.model_fields_set:
            _dict['allowLocalRepo'] = None

        # set to None if allow_remote_key_auth (nullable) is None
        # and model_fields_set contains the field
        if self.allow_remote_key_auth is None and "allow_remote_key_auth" in self.model_fields_set:
            _dict['allowRemoteKeyAuth'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListTaskTypes200ResponseTaskTypesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "code": obj.get("code"),
            "name": obj.get("name"),
            "category": obj.get("category"),
            "description": obj.get("description"),
            "scriptable": obj.get("scriptable"),
            "enabled": obj.get("enabled"),
            "hasResults": obj.get("hasResults"),
            "allowExecuteLocal": obj.get("allowExecuteLocal"),
            "allowExecuteRemote": obj.get("allowExecuteRemote"),
            "allowExecuteResource": obj.get("allowExecuteResource"),
            "allowLocalRepo": obj.get("allowLocalRepo"),
            "allowRemoteKeyAuth": obj.get("allowRemoteKeyAuth"),
            "optionTypes": [ListTaskTypes200ResponseTaskTypesInnerOptionTypesInner.from_dict(_item) for _item in obj["optionTypes"]] if obj.get("optionTypes") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


